/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a product code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductCode implements SdkPojo, Serializable, ToCopyableBuilder<ProductCode.Builder, ProductCode> {
    private static final SdkField<String> PRODUCT_CODE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProductCodeId")
            .getter(getter(ProductCode::productCodeId))
            .setter(setter(Builder::productCodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode")
                    .unmarshallLocationName("productCode").build()).build();

    private static final SdkField<String> PRODUCT_CODE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProductCodeType")
            .getter(getter(ProductCode::productCodeTypeAsString))
            .setter(setter(Builder::productCodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_ID_FIELD,
            PRODUCT_CODE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String productCodeId;

    private final String productCodeType;

    private ProductCode(BuilderImpl builder) {
        this.productCodeId = builder.productCodeId;
        this.productCodeType = builder.productCodeType;
    }

    /**
     * <p>
     * The product code.
     * </p>
     * 
     * @return The product code.
     */
    public String productCodeId() {
        return productCodeId;
    }

    /**
     * <p>
     * The type of product code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productCodeType}
     * will return {@link ProductCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productCodeTypeAsString}.
     * </p>
     * 
     * @return The type of product code.
     * @see ProductCodeValues
     */
    public ProductCodeValues productCodeType() {
        return ProductCodeValues.fromValue(productCodeType);
    }

    /**
     * <p>
     * The type of product code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productCodeType}
     * will return {@link ProductCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productCodeTypeAsString}.
     * </p>
     * 
     * @return The type of product code.
     * @see ProductCodeValues
     */
    public String productCodeTypeAsString() {
        return productCodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productCodeId());
        hashCode = 31 * hashCode + Objects.hashCode(productCodeTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductCode)) {
            return false;
        }
        ProductCode other = (ProductCode) obj;
        return Objects.equals(productCodeId(), other.productCodeId())
                && Objects.equals(productCodeTypeAsString(), other.productCodeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProductCode").add("ProductCodeId", productCodeId())
                .add("ProductCodeType", productCodeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductCodeId":
            return Optional.ofNullable(clazz.cast(productCodeId()));
        case "ProductCodeType":
            return Optional.ofNullable(clazz.cast(productCodeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductCode, T> g) {
        return obj -> g.apply((ProductCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductCode> {
        /**
         * <p>
         * The product code.
         * </p>
         * 
         * @param productCodeId
         *        The product code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodeId(String productCodeId);

        /**
         * <p>
         * The type of product code.
         * </p>
         * 
         * @param productCodeType
         *        The type of product code.
         * @see ProductCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductCodeValues
         */
        Builder productCodeType(String productCodeType);

        /**
         * <p>
         * The type of product code.
         * </p>
         * 
         * @param productCodeType
         *        The type of product code.
         * @see ProductCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductCodeValues
         */
        Builder productCodeType(ProductCodeValues productCodeType);
    }

    static final class BuilderImpl implements Builder {
        private String productCodeId;

        private String productCodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductCode model) {
            productCodeId(model.productCodeId);
            productCodeType(model.productCodeType);
        }

        public final String getProductCodeId() {
            return productCodeId;
        }

        @Override
        public final Builder productCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
            return this;
        }

        public final void setProductCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
        }

        public final String getProductCodeType() {
            return productCodeType;
        }

        @Override
        public final Builder productCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
            return this;
        }

        @Override
        public final Builder productCodeType(ProductCodeValues productCodeType) {
            this.productCodeType(productCodeType == null ? null : productCodeType.toString());
            return this;
        }

        public final void setProductCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
        }

        @Override
        public ProductCode build() {
            return new ProductCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
