/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the time period for a Scheduled Instance to start its first schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotStartTimeRangeRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotStartTimeRangeRequest.Builder, SlotStartTimeRangeRequest> {
    private static final SdkField<Instant> EARLIEST_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EarliestTime")
            .getter(getter(SlotStartTimeRangeRequest::earliestTime))
            .setter(setter(Builder::earliestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestTime")
                    .unmarshallLocationName("EarliestTime").build()).build();

    private static final SdkField<Instant> LATEST_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestTime")
            .getter(getter(SlotStartTimeRangeRequest::latestTime))
            .setter(setter(Builder::latestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestTime")
                    .unmarshallLocationName("LatestTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EARLIEST_TIME_FIELD,
            LATEST_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant earliestTime;

    private final Instant latestTime;

    private SlotStartTimeRangeRequest(BuilderImpl builder) {
        this.earliestTime = builder.earliestTime;
        this.latestTime = builder.latestTime;
    }

    /**
     * <p>
     * The earliest date and time, in UTC, for the Scheduled Instance to start.
     * </p>
     * 
     * @return The earliest date and time, in UTC, for the Scheduled Instance to start.
     */
    public Instant earliestTime() {
        return earliestTime;
    }

    /**
     * <p>
     * The latest date and time, in UTC, for the Scheduled Instance to start.
     * </p>
     * 
     * @return The latest date and time, in UTC, for the Scheduled Instance to start.
     */
    public Instant latestTime() {
        return latestTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(earliestTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotStartTimeRangeRequest)) {
            return false;
        }
        SlotStartTimeRangeRequest other = (SlotStartTimeRangeRequest) obj;
        return Objects.equals(earliestTime(), other.earliestTime()) && Objects.equals(latestTime(), other.latestTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SlotStartTimeRangeRequest").add("EarliestTime", earliestTime()).add("LatestTime", latestTime())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EarliestTime":
            return Optional.ofNullable(clazz.cast(earliestTime()));
        case "LatestTime":
            return Optional.ofNullable(clazz.cast(latestTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotStartTimeRangeRequest, T> g) {
        return obj -> g.apply((SlotStartTimeRangeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotStartTimeRangeRequest> {
        /**
         * <p>
         * The earliest date and time, in UTC, for the Scheduled Instance to start.
         * </p>
         * 
         * @param earliestTime
         *        The earliest date and time, in UTC, for the Scheduled Instance to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestTime(Instant earliestTime);

        /**
         * <p>
         * The latest date and time, in UTC, for the Scheduled Instance to start.
         * </p>
         * 
         * @param latestTime
         *        The latest date and time, in UTC, for the Scheduled Instance to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestTime(Instant latestTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant earliestTime;

        private Instant latestTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotStartTimeRangeRequest model) {
            earliestTime(model.earliestTime);
            latestTime(model.latestTime);
        }

        public final Instant getEarliestTime() {
            return earliestTime;
        }

        @Override
        public final Builder earliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
            return this;
        }

        public final void setEarliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
        }

        public final Instant getLatestTime() {
            return latestTime;
        }

        @Override
        public final Builder latestTime(Instant latestTime) {
            this.latestTime = latestTime;
            return this;
        }

        public final void setLatestTime(Instant latestTime) {
            this.latestTime = latestTime;
        }

        @Override
        public SlotStartTimeRangeRequest build() {
            return new SlotStartTimeRangeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
