/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClientVpnRouteRequest extends Ec2Request implements
        ToCopyableBuilder<CreateClientVpnRouteRequest.Builder, CreateClientVpnRouteRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(CreateClientVpnRouteRequest::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("ClientVpnEndpointId").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(CreateClientVpnRouteRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("DestinationCidrBlock").build()).build();

    private static final SdkField<String> TARGET_VPC_SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetVpcSubnetId")
            .getter(getter(CreateClientVpnRouteRequest::targetVpcSubnetId))
            .setter(setter(Builder::targetVpcSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVpcSubnetId")
                    .unmarshallLocationName("TargetVpcSubnetId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateClientVpnRouteRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateClientVpnRouteRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            DESTINATION_CIDR_BLOCK_FIELD, TARGET_VPC_SUBNET_ID_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));

    private final String clientVpnEndpointId;

    private final String destinationCidrBlock;

    private final String targetVpcSubnetId;

    private final String description;

    private final String clientToken;

    private CreateClientVpnRouteRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.targetVpcSubnetId = builder.targetVpcSubnetId;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint to which to add the route.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint to which to add the route.
     */
    public String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, of the route destination. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To add a route for Internet access, enter <code>0.0.0.0/0</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
     * </p>
     * </li>
     * <li>
     * <p>
     * To add a route for an on-premises network, enter the AWS Site-to-Site VPN connection's IPv4 CIDR range
     * </p>
     * </li>
     * <li>
     * <p>
     * To add a route for the local network, enter the client CIDR range
     * </p>
     * </li>
     * </ul>
     * 
     * @return The IPv4 address range, in CIDR notation, of the route destination. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To add a route for Internet access, enter <code>0.0.0.0/0</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To add a route for an on-premises network, enter the AWS Site-to-Site VPN connection's IPv4 CIDR range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To add a route for the local network, enter the client CIDR range
     *         </p>
     *         </li>
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target
     * network of the Client VPN endpoint.
     * </p>
     * <p>
     * Alternatively, if you're adding a route for the local network, specify <code>local</code>.
     * </p>
     * 
     * @return The ID of the subnet through which you want to route traffic. The specified subnet must be an existing
     *         target network of the Client VPN endpoint.</p>
     *         <p>
     *         Alternatively, if you're adding a route for the local network, specify <code>local</code>.
     */
    public String targetVpcSubnetId() {
        return targetVpcSubnetId;
    }

    /**
     * <p>
     * A brief description of the route.
     * </p>
     * 
     * @return A brief description of the route.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(targetVpcSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClientVpnRouteRequest)) {
            return false;
        }
        CreateClientVpnRouteRequest other = (CreateClientVpnRouteRequest) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(targetVpcSubnetId(), other.targetVpcSubnetId())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateClientVpnRouteRequest").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("DestinationCidrBlock", destinationCidrBlock()).add("TargetVpcSubnetId", targetVpcSubnetId())
                .add("Description", description()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "TargetVpcSubnetId":
            return Optional.ofNullable(clazz.cast(targetVpcSubnetId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClientVpnRouteRequest, T> g) {
        return obj -> g.apply((CreateClientVpnRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateClientVpnRouteRequest> {
        /**
         * <p>
         * The ID of the Client VPN endpoint to which to add the route.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint to which to add the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the route destination. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To add a route for Internet access, enter <code>0.0.0.0/0</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
         * </p>
         * </li>
         * <li>
         * <p>
         * To add a route for an on-premises network, enter the AWS Site-to-Site VPN connection's IPv4 CIDR range
         * </p>
         * </li>
         * <li>
         * <p>
         * To add a route for the local network, enter the client CIDR range
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationCidrBlock
         *        The IPv4 address range, in CIDR notation, of the route destination. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To add a route for Internet access, enter <code>0.0.0.0/0</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To add a route for an on-premises network, enter the AWS Site-to-Site VPN connection's IPv4 CIDR range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To add a route for the local network, enter the client CIDR range
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target
         * network of the Client VPN endpoint.
         * </p>
         * <p>
         * Alternatively, if you're adding a route for the local network, specify <code>local</code>.
         * </p>
         * 
         * @param targetVpcSubnetId
         *        The ID of the subnet through which you want to route traffic. The specified subnet must be an existing
         *        target network of the Client VPN endpoint.</p>
         *        <p>
         *        Alternatively, if you're adding a route for the local network, specify <code>local</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVpcSubnetId(String targetVpcSubnetId);

        /**
         * <p>
         * A brief description of the route.
         * </p>
         * 
         * @param description
         *        A brief description of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String destinationCidrBlock;

        private String targetVpcSubnetId;

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClientVpnRouteRequest model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            destinationCidrBlock(model.destinationCidrBlock);
            targetVpcSubnetId(model.targetVpcSubnetId);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getTargetVpcSubnetId() {
            return targetVpcSubnetId;
        }

        @Override
        public final Builder targetVpcSubnetId(String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
            return this;
        }

        public final void setTargetVpcSubnetId(String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClientVpnRouteRequest build() {
            return new CreateClientVpnRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
