/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceRouteTableAssociationResponse extends Ec2Response implements
        ToCopyableBuilder<ReplaceRouteTableAssociationResponse.Builder, ReplaceRouteTableAssociationResponse> {
    private static final SdkField<String> NEW_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewAssociationId")
            .getter(getter(ReplaceRouteTableAssociationResponse::newAssociationId))
            .setter(setter(Builder::newAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewAssociationId")
                    .unmarshallLocationName("newAssociationId").build()).build();

    private static final SdkField<RouteTableAssociationState> ASSOCIATION_STATE_FIELD = SdkField
            .<RouteTableAssociationState> builder(MarshallingType.SDK_POJO)
            .memberName("AssociationState")
            .getter(getter(ReplaceRouteTableAssociationResponse::associationState))
            .setter(setter(Builder::associationState))
            .constructor(RouteTableAssociationState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationState")
                    .unmarshallLocationName("associationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_ASSOCIATION_ID_FIELD,
            ASSOCIATION_STATE_FIELD));

    private final String newAssociationId;

    private final RouteTableAssociationState associationState;

    private ReplaceRouteTableAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.newAssociationId = builder.newAssociationId;
        this.associationState = builder.associationState;
    }

    /**
     * <p>
     * The ID of the new association.
     * </p>
     * 
     * @return The ID of the new association.
     */
    public String newAssociationId() {
        return newAssociationId;
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * 
     * @return The state of the association.
     */
    public RouteTableAssociationState associationState() {
        return associationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(newAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationState());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceRouteTableAssociationResponse)) {
            return false;
        }
        ReplaceRouteTableAssociationResponse other = (ReplaceRouteTableAssociationResponse) obj;
        return Objects.equals(newAssociationId(), other.newAssociationId())
                && Objects.equals(associationState(), other.associationState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplaceRouteTableAssociationResponse").add("NewAssociationId", newAssociationId())
                .add("AssociationState", associationState()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NewAssociationId":
            return Optional.ofNullable(clazz.cast(newAssociationId()));
        case "AssociationState":
            return Optional.ofNullable(clazz.cast(associationState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceRouteTableAssociationResponse, T> g) {
        return obj -> g.apply((ReplaceRouteTableAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ReplaceRouteTableAssociationResponse> {
        /**
         * <p>
         * The ID of the new association.
         * </p>
         * 
         * @param newAssociationId
         *        The ID of the new association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newAssociationId(String newAssociationId);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param associationState
         *        The state of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationState(RouteTableAssociationState associationState);

        /**
         * <p>
         * The state of the association.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteTableAssociationState.Builder} avoiding the
         * need to create one manually via {@link RouteTableAssociationState#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteTableAssociationState.Builder#build()} is called immediately
         * and its result is passed to {@link #associationState(RouteTableAssociationState)}.
         * 
         * @param associationState
         *        a consumer that will call methods on {@link RouteTableAssociationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationState(RouteTableAssociationState)
         */
        default Builder associationState(Consumer<RouteTableAssociationState.Builder> associationState) {
            return associationState(RouteTableAssociationState.builder().applyMutation(associationState).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String newAssociationId;

        private RouteTableAssociationState associationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceRouteTableAssociationResponse model) {
            super(model);
            newAssociationId(model.newAssociationId);
            associationState(model.associationState);
        }

        public final String getNewAssociationId() {
            return newAssociationId;
        }

        @Override
        public final Builder newAssociationId(String newAssociationId) {
            this.newAssociationId = newAssociationId;
            return this;
        }

        public final void setNewAssociationId(String newAssociationId) {
            this.newAssociationId = newAssociationId;
        }

        public final RouteTableAssociationState.Builder getAssociationState() {
            return associationState != null ? associationState.toBuilder() : null;
        }

        @Override
        public final Builder associationState(RouteTableAssociationState associationState) {
            this.associationState = associationState;
            return this;
        }

        public final void setAssociationState(RouteTableAssociationState.BuilderImpl associationState) {
            this.associationState = associationState != null ? associationState.build() : null;
        }

        @Override
        public ReplaceRouteTableAssociationResponse build() {
            return new ReplaceRouteTableAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
