/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes association information for an Elastic IP address (IPv4 only), or a Carrier IP address (for a network
 * interface which resides in a subnet in a Wavelength Zone).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterfaceAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterfaceAssociation.Builder, NetworkInterfaceAssociation> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(NetworkInterfaceAssociation::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("allocationId").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationId")
            .getter(getter(NetworkInterfaceAssociation::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("associationId").build()).build();

    private static final SdkField<String> IP_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpOwnerId")
            .getter(getter(NetworkInterfaceAssociation::ipOwnerId))
            .setter(setter(Builder::ipOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpOwnerId")
                    .unmarshallLocationName("ipOwnerId").build()).build();

    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicDnsName")
            .getter(getter(NetworkInterfaceAssociation::publicDnsName))
            .setter(setter(Builder::publicDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicDnsName")
                    .unmarshallLocationName("publicDnsName").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(NetworkInterfaceAssociation::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("publicIp").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerOwnedIp")
            .getter(getter(NetworkInterfaceAssociation::customerOwnedIp))
            .setter(setter(Builder::customerOwnedIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIp")
                    .unmarshallLocationName("customerOwnedIp").build()).build();

    private static final SdkField<String> CARRIER_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CarrierIp")
            .getter(getter(NetworkInterfaceAssociation::carrierIp))
            .setter(setter(Builder::carrierIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierIp")
                    .unmarshallLocationName("carrierIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD,
            ASSOCIATION_ID_FIELD, IP_OWNER_ID_FIELD, PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_FIELD, CUSTOMER_OWNED_IP_FIELD,
            CARRIER_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationId;

    private final String associationId;

    private final String ipOwnerId;

    private final String publicDnsName;

    private final String publicIp;

    private final String customerOwnedIp;

    private final String carrierIp;

    private NetworkInterfaceAssociation(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.ipOwnerId = builder.ipOwnerId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
        this.customerOwnedIp = builder.customerOwnedIp;
        this.carrierIp = builder.carrierIp;
    }

    /**
     * <p>
     * The allocation ID.
     * </p>
     * 
     * @return The allocation ID.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The association ID.
     * </p>
     * 
     * @return The association ID.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The ID of the Elastic IP address owner.
     * </p>
     * 
     * @return The ID of the Elastic IP address owner.
     */
    public String ipOwnerId() {
        return ipOwnerId;
    }

    /**
     * <p>
     * The public DNS name.
     * </p>
     * 
     * @return The public DNS name.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The address of the Elastic IP address bound to the network interface.
     * </p>
     * 
     * @return The address of the Elastic IP address bound to the network interface.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The customer-owned IP address associated with the network interface.
     * </p>
     * 
     * @return The customer-owned IP address associated with the network interface.
     */
    public String customerOwnedIp() {
        return customerOwnedIp;
    }

    /**
     * <p>
     * The carrier IP address associated with the network interface.
     * </p>
     * <p>
     * This option is only available when the network interface is in a subnet which is associated with a Wavelength
     * Zone.
     * </p>
     * 
     * @return The carrier IP address associated with the network interface.</p>
     *         <p>
     *         This option is only available when the network interface is in a subnet which is associated with a
     *         Wavelength Zone.
     */
    public String carrierIp() {
        return carrierIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(ipOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(carrierIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAssociation)) {
            return false;
        }
        NetworkInterfaceAssociation other = (NetworkInterfaceAssociation) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(ipOwnerId(), other.ipOwnerId()) && Objects.equals(publicDnsName(), other.publicDnsName())
                && Objects.equals(publicIp(), other.publicIp()) && Objects.equals(customerOwnedIp(), other.customerOwnedIp())
                && Objects.equals(carrierIp(), other.carrierIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkInterfaceAssociation").add("AllocationId", allocationId())
                .add("AssociationId", associationId()).add("IpOwnerId", ipOwnerId()).add("PublicDnsName", publicDnsName())
                .add("PublicIp", publicIp()).add("CustomerOwnedIp", customerOwnedIp()).add("CarrierIp", carrierIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "IpOwnerId":
            return Optional.ofNullable(clazz.cast(ipOwnerId()));
        case "PublicDnsName":
            return Optional.ofNullable(clazz.cast(publicDnsName()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "CustomerOwnedIp":
            return Optional.ofNullable(clazz.cast(customerOwnedIp()));
        case "CarrierIp":
            return Optional.ofNullable(clazz.cast(carrierIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfaceAssociation, T> g) {
        return obj -> g.apply((NetworkInterfaceAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterfaceAssociation> {
        /**
         * <p>
         * The allocation ID.
         * </p>
         * 
         * @param allocationId
         *        The allocation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The association ID.
         * </p>
         * 
         * @param associationId
         *        The association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The ID of the Elastic IP address owner.
         * </p>
         * 
         * @param ipOwnerId
         *        The ID of the Elastic IP address owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipOwnerId(String ipOwnerId);

        /**
         * <p>
         * The public DNS name.
         * </p>
         * 
         * @param publicDnsName
         *        The public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The address of the Elastic IP address bound to the network interface.
         * </p>
         * 
         * @param publicIp
         *        The address of the Elastic IP address bound to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The customer-owned IP address associated with the network interface.
         * </p>
         * 
         * @param customerOwnedIp
         *        The customer-owned IP address associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIp(String customerOwnedIp);

        /**
         * <p>
         * The carrier IP address associated with the network interface.
         * </p>
         * <p>
         * This option is only available when the network interface is in a subnet which is associated with a Wavelength
         * Zone.
         * </p>
         * 
         * @param carrierIp
         *        The carrier IP address associated with the network interface.</p>
         *        <p>
         *        This option is only available when the network interface is in a subnet which is associated with a
         *        Wavelength Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierIp(String carrierIp);
    }

    static final class BuilderImpl implements Builder {
        private String allocationId;

        private String associationId;

        private String ipOwnerId;

        private String publicDnsName;

        private String publicIp;

        private String customerOwnedIp;

        private String carrierIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAssociation model) {
            allocationId(model.allocationId);
            associationId(model.associationId);
            ipOwnerId(model.ipOwnerId);
            publicDnsName(model.publicDnsName);
            publicIp(model.publicIp);
            customerOwnedIp(model.customerOwnedIp);
            carrierIp(model.carrierIp);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getIpOwnerId() {
            return ipOwnerId;
        }

        @Override
        public final Builder ipOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
            return this;
        }

        public final void setIpOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getCustomerOwnedIp() {
            return customerOwnedIp;
        }

        @Override
        public final Builder customerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
            return this;
        }

        public final void setCustomerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
        }

        public final String getCarrierIp() {
            return carrierIp;
        }

        @Override
        public final Builder carrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
            return this;
        }

        public final void setCarrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
        }

        @Override
        public NetworkInterfaceAssociation build() {
            return new NetworkInterfaceAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
