/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrafficMirrorFiltersResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTrafficMirrorFiltersResponse> {
    private static final SdkField<List<TrafficMirrorFilter>> TRAFFIC_MIRROR_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrafficMirrorFilters").getter(DescribeTrafficMirrorFiltersResponse.getter(DescribeTrafficMirrorFiltersResponse::trafficMirrorFilters)).setter(DescribeTrafficMirrorFiltersResponse.setter(Builder::trafficMirrorFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterSet").unmarshallLocationName("trafficMirrorFilterSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficMirrorFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTrafficMirrorFiltersResponse.getter(DescribeTrafficMirrorFiltersResponse::nextToken)).setter(DescribeTrafficMirrorFiltersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TrafficMirrorFilter> trafficMirrorFilters;
    private final String nextToken;

    private DescribeTrafficMirrorFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilters = builder.trafficMirrorFilters;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTrafficMirrorFilters() {
        return this.trafficMirrorFilters != null && !(this.trafficMirrorFilters instanceof SdkAutoConstructList);
    }

    public List<TrafficMirrorFilter> trafficMirrorFilters() {
        return this.trafficMirrorFilters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrafficMirrorFilters() ? this.trafficMirrorFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficMirrorFiltersResponse)) {
            return false;
        }
        DescribeTrafficMirrorFiltersResponse other = (DescribeTrafficMirrorFiltersResponse)((Object)obj);
        return this.hasTrafficMirrorFilters() == other.hasTrafficMirrorFilters() && Objects.equals(this.trafficMirrorFilters(), other.trafficMirrorFilters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrafficMirrorFiltersResponse").add("TrafficMirrorFilters", this.hasTrafficMirrorFilters() ? this.trafficMirrorFilters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilters": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficMirrorFiltersResponse, T> g) {
        return obj -> g.apply((DescribeTrafficMirrorFiltersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TrafficMirrorFilter> trafficMirrorFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficMirrorFiltersResponse model) {
            super(model);
            this.trafficMirrorFilters(model.trafficMirrorFilters);
            this.nextToken(model.nextToken);
        }

        public final Collection<TrafficMirrorFilter.Builder> getTrafficMirrorFilters() {
            if (this.trafficMirrorFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trafficMirrorFilters != null ? (Collection)this.trafficMirrorFilters.stream().map(TrafficMirrorFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficMirrorFilters(Collection<TrafficMirrorFilter> trafficMirrorFilters) {
            this.trafficMirrorFilters = TrafficMirrorFilterSetCopier.copy(trafficMirrorFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorFilters(TrafficMirrorFilter ... trafficMirrorFilters) {
            this.trafficMirrorFilters(Arrays.asList(trafficMirrorFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorFilters(Consumer<TrafficMirrorFilter.Builder> ... trafficMirrorFilters) {
            this.trafficMirrorFilters(Stream.of(trafficMirrorFilters).map(c -> (TrafficMirrorFilter)((TrafficMirrorFilter.Builder)TrafficMirrorFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrafficMirrorFilters(Collection<TrafficMirrorFilter.BuilderImpl> trafficMirrorFilters) {
            this.trafficMirrorFilters = TrafficMirrorFilterSetCopier.copyFromBuilder(trafficMirrorFilters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTrafficMirrorFiltersResponse build() {
            return new DescribeTrafficMirrorFiltersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrafficMirrorFiltersResponse> {
        public Builder trafficMirrorFilters(Collection<TrafficMirrorFilter> var1);

        public Builder trafficMirrorFilters(TrafficMirrorFilter ... var1);

        public Builder trafficMirrorFilters(Consumer<TrafficMirrorFilter.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

