/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet registers the running Spot Instances with
 * these Classic Load Balancers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassicLoadBalancersConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassicLoadBalancersConfig.Builder, ClassicLoadBalancersConfig> {
    private static final SdkField<List<ClassicLoadBalancer>> CLASSIC_LOAD_BALANCERS_FIELD = SdkField
            .<List<ClassicLoadBalancer>> builder(MarshallingType.LIST)
            .memberName("ClassicLoadBalancers")
            .getter(getter(ClassicLoadBalancersConfig::classicLoadBalancers))
            .setter(setter(Builder::classicLoadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLoadBalancers")
                    .unmarshallLocationName("classicLoadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ClassicLoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClassicLoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIC_LOAD_BALANCERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ClassicLoadBalancer> classicLoadBalancers;

    private ClassicLoadBalancersConfig(BuilderImpl builder) {
        this.classicLoadBalancers = builder.classicLoadBalancers;
    }

    /**
     * Returns true if the ClassicLoadBalancers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasClassicLoadBalancers() {
        return classicLoadBalancers != null && !(classicLoadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Classic Load Balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClassicLoadBalancers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more Classic Load Balancers.
     */
    public List<ClassicLoadBalancer> classicLoadBalancers() {
        return classicLoadBalancers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClassicLoadBalancers() ? classicLoadBalancers() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassicLoadBalancersConfig)) {
            return false;
        }
        ClassicLoadBalancersConfig other = (ClassicLoadBalancersConfig) obj;
        return hasClassicLoadBalancers() == other.hasClassicLoadBalancers()
                && Objects.equals(classicLoadBalancers(), other.classicLoadBalancers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClassicLoadBalancersConfig")
                .add("ClassicLoadBalancers", hasClassicLoadBalancers() ? classicLoadBalancers() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClassicLoadBalancers":
            return Optional.ofNullable(clazz.cast(classicLoadBalancers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassicLoadBalancersConfig, T> g) {
        return obj -> g.apply((ClassicLoadBalancersConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassicLoadBalancersConfig> {
        /**
         * <p>
         * One or more Classic Load Balancers.
         * </p>
         * 
         * @param classicLoadBalancers
         *        One or more Classic Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancers(Collection<ClassicLoadBalancer> classicLoadBalancers);

        /**
         * <p>
         * One or more Classic Load Balancers.
         * </p>
         * 
         * @param classicLoadBalancers
         *        One or more Classic Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancers(ClassicLoadBalancer... classicLoadBalancers);

        /**
         * <p>
         * One or more Classic Load Balancers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClassicLoadBalancer>.Builder} avoiding the
         * need to create one manually via {@link List<ClassicLoadBalancer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClassicLoadBalancer>.Builder#build()} is called immediately
         * and its result is passed to {@link #classicLoadBalancers(List<ClassicLoadBalancer>)}.
         * 
         * @param classicLoadBalancers
         *        a consumer that will call methods on {@link List<ClassicLoadBalancer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classicLoadBalancers(List<ClassicLoadBalancer>)
         */
        Builder classicLoadBalancers(Consumer<ClassicLoadBalancer.Builder>... classicLoadBalancers);
    }

    static final class BuilderImpl implements Builder {
        private List<ClassicLoadBalancer> classicLoadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClassicLoadBalancersConfig model) {
            classicLoadBalancers(model.classicLoadBalancers);
        }

        public final Collection<ClassicLoadBalancer.Builder> getClassicLoadBalancers() {
            if (classicLoadBalancers instanceof SdkAutoConstructList) {
                return null;
            }
            return classicLoadBalancers != null ? classicLoadBalancers.stream().map(ClassicLoadBalancer::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder classicLoadBalancers(Collection<ClassicLoadBalancer> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copy(classicLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLoadBalancers(ClassicLoadBalancer... classicLoadBalancers) {
            classicLoadBalancers(Arrays.asList(classicLoadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLoadBalancers(Consumer<ClassicLoadBalancer.Builder>... classicLoadBalancers) {
            classicLoadBalancers(Stream.of(classicLoadBalancers).map(c -> ClassicLoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setClassicLoadBalancers(Collection<ClassicLoadBalancer.BuilderImpl> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copyFromBuilder(classicLoadBalancers);
        }

        @Override
        public ClassicLoadBalancersConfig build() {
            return new ClassicLoadBalancersConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
