/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSpotInstanceRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpotInstanceRequestsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeSpotInstanceRequestsRequest.Builder, DescribeSpotInstanceRequestsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeSpotInstanceRequestsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SPOT_INSTANCE_REQUEST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SpotInstanceRequestIds")
            .getter(getter(DescribeSpotInstanceRequestsRequest::spotInstanceRequestIds))
            .setter(setter(Builder::spotInstanceRequestIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId")
                    .unmarshallLocationName("SpotInstanceRequestId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SpotInstanceRequestId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SpotInstanceRequestId")
                                                    .unmarshallLocationName("SpotInstanceRequestId").build()).build()).build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSpotInstanceRequestsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeSpotInstanceRequestsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            SPOT_INSTANCE_REQUEST_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<Filter> filters;

    private final List<String> spotInstanceRequestIds;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeSpotInstanceRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.spotInstanceRequestIds = builder.spotInstanceRequestIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone-group</code> - The Availability Zone group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>create-time</code> - The time stamp when the Spot Instance request was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fault-code</code> - The fault code related to the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fault-message</code> - The fault message related to the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance that fulfilled the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch-group</code> - The Spot Instance launch group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted on
     * instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device mapping
     * (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General
     * Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput
     * Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.group-id</code> - The ID of the security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.group-name</code> - The name of the security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.image-id</code> - The ID of the AMI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.kernel-id</code> - The kernel ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.key-name</code> - The name of the key pair the instance launched with.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.ramdisk-id</code> - The RAM disk ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP
     * address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted when
     * the instance is terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.description</code> - A description of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.device-index</code> - The index of the device for the network interface attachment on the
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-description</code> - The product description associated with the instance (<code>Linux/UNIX</code>
     * | <code>Windows</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-instance-request-id</code> - The Spot Instance request ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> |
     * <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information can help you
     * track your Amazon EC2 Spot Instance requests. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request status</a> in the
     * <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-message</code> - The message explaining the status of the Spot Instance request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>valid-from</code> - The start date of the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>valid-until</code> - The end date of the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone-group</code> - The Availability Zone group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>create-time</code> - The time stamp when the Spot Instance request was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fault-code</code> - The fault code related to the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fault-message</code> - The fault message related to the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance that fulfilled the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch-group</code> - The Spot Instance launch group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is
     *         deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device
     *         mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for
     *         General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for
     *         Throughput Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.group-id</code> - The ID of the security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.group-name</code> - The name of the security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.image-id</code> - The ID of the AMI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.kernel-id</code> - The kernel ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.key-name</code> - The name of the key pair the instance launched with.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.ramdisk-id</code> - The RAM disk ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary
     *         private IP address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted
     *         when the instance is terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.description</code> - A description of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.device-index</code> - The index of the device for the network interface
     *         attachment on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.group-id</code> - The ID of the security group associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.private-ip-address</code> - The primary private IP address of the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-description</code> - The product description associated with the instance (
     *         <code>Linux/UNIX</code> | <code>Windows</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-instance-request-id</code> - The Spot Instance request ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> |
     *         <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information can
     *         help you track your Amazon EC2 Spot Instance requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request status</a>
     *         in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-message</code> - The message explaining the status of the Spot Instance request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>valid-from</code> - The start date of the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>valid-until</code> - The end date of the request.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * Returns true if the SpotInstanceRequestIds property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSpotInstanceRequestIds() {
        return spotInstanceRequestIds != null && !(spotInstanceRequestIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Spot Instance request IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSpotInstanceRequestIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more Spot Instance request IDs.
     */
    public List<String> spotInstanceRequestIds() {
        return spotInstanceRequestIds;
    }

    /**
     * <p>
     * The token to request the next set of results. This value is <code>null</code> when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to request the next set of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. Specify a value between 5 and 1000. To retrieve the
     * remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. Specify a value between 5 and 1000. To retrieve
     *         the remaining results, make another call with the returned <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSpotInstanceRequestIds() ? spotInstanceRequestIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotInstanceRequestsRequest)) {
            return false;
        }
        DescribeSpotInstanceRequestsRequest other = (DescribeSpotInstanceRequestsRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasSpotInstanceRequestIds() == other.hasSpotInstanceRequestIds()
                && Objects.equals(spotInstanceRequestIds(), other.spotInstanceRequestIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSpotInstanceRequestsRequest").add("Filters", hasFilters() ? filters() : null)
                .add("SpotInstanceRequestIds", hasSpotInstanceRequestIds() ? spotInstanceRequestIds() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SpotInstanceRequestIds":
            return Optional.ofNullable(clazz.cast(spotInstanceRequestIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotInstanceRequestsRequest, T> g) {
        return obj -> g.apply((DescribeSpotInstanceRequestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSpotInstanceRequestsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone-group</code> - The Availability Zone group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the Spot Instance request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-code</code> - The fault code related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-message</code> - The fault message related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance that fulfilled the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-group</code> - The Spot Instance launch group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted
         * on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device
         * mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General
         * Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput
         * Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.image-id</code> - The ID of the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.key-name</code> - The name of the key pair the instance launched with.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP
         * address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted
         * when the instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - A description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.device-index</code> - The index of the device for the network interface attachment on
         * the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description associated with the instance (
         * <code>Linux/UNIX</code> | <code>Windows</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The Spot Instance request ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> |
         * <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information can help
         * you track your Amazon EC2 Spot Instance requests. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request status</a> in
         * the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The message explaining the status of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-from</code> - The start date of the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-until</code> - The end date of the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone-group</code> - The Availability Zone group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time stamp when the Spot Instance request was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fault-code</code> - The fault code related to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fault-message</code> - The fault message related to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance that fulfilled the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-group</code> - The Spot Instance launch group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is
         *        deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block
         *        device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for
         *        General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code>
         *        for Throughput Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.group-id</code> - The ID of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.group-name</code> - The name of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.image-id</code> - The ID of the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.key-name</code> - The name of the key pair the instance launched with.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary
         *        private IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is
         *        deleted when the instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - A description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.device-index</code> - The index of the device for the network interface
         *        attachment on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of the security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-ip-address</code> - The primary private IP address of the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The product description associated with the instance (
         *        <code>Linux/UNIX</code> | <code>Windows</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The Spot Instance request ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> |
         *        <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information
         *        can help you track your Amazon EC2 Spot Instance requests. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request
         *        status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The message explaining the status of the Spot Instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>valid-from</code> - The start date of the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>valid-until</code> - The end date of the request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone-group</code> - The Availability Zone group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the Spot Instance request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-code</code> - The fault code related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-message</code> - The fault message related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance that fulfilled the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-group</code> - The Spot Instance launch group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted
         * on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device
         * mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General
         * Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput
         * Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.image-id</code> - The ID of the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.key-name</code> - The name of the key pair the instance launched with.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP
         * address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted
         * when the instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - A description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.device-index</code> - The index of the device for the network interface attachment on
         * the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description associated with the instance (
         * <code>Linux/UNIX</code> | <code>Windows</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The Spot Instance request ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> |
         * <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information can help
         * you track your Amazon EC2 Spot Instance requests. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request status</a> in
         * the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The message explaining the status of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-from</code> - The start date of the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-until</code> - The end date of the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone-group</code> - The Availability Zone group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time stamp when the Spot Instance request was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fault-code</code> - The fault code related to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fault-message</code> - The fault message related to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance that fulfilled the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-group</code> - The Spot Instance launch group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is
         *        deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block
         *        device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for
         *        General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code>
         *        for Throughput Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.group-id</code> - The ID of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.group-name</code> - The name of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.image-id</code> - The ID of the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.key-name</code> - The name of the key pair the instance launched with.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary
         *        private IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is
         *        deleted when the instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - A description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.device-index</code> - The index of the device for the network interface
         *        attachment on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of the security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-ip-address</code> - The primary private IP address of the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The product description associated with the instance (
         *        <code>Linux/UNIX</code> | <code>Windows</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The Spot Instance request ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> |
         *        <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information
         *        can help you track your Amazon EC2 Spot Instance requests. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request
         *        status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The message explaining the status of the Spot Instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>valid-from</code> - The start date of the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>valid-until</code> - The end date of the request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone-group</code> - The Availability Zone group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the Spot Instance request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-code</code> - The fault code related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-message</code> - The fault message related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance that fulfilled the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-group</code> - The Spot Instance launch group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted
         * on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device
         * mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General
         * Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput
         * Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.image-id</code> - The ID of the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.key-name</code> - The name of the key pair the instance launched with.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP
         * address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted
         * when the instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - A description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.device-index</code> - The index of the device for the network interface attachment on
         * the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description associated with the instance (
         * <code>Linux/UNIX</code> | <code>Windows</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The Spot Instance request ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> |
         * <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information can help
         * you track your Amazon EC2 Spot Instance requests. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request status</a> in
         * the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The message explaining the status of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-from</code> - The start date of the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-until</code> - The end date of the request.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more Spot Instance request IDs.
         * </p>
         * 
         * @param spotInstanceRequestIds
         *        One or more Spot Instance request IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds);

        /**
         * <p>
         * One or more Spot Instance request IDs.
         * </p>
         * 
         * @param spotInstanceRequestIds
         *        One or more Spot Instance request IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestIds(String... spotInstanceRequestIds);

        /**
         * <p>
         * The token to request the next set of results. This value is <code>null</code> when there are no more results
         * to return.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next set of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call. Specify a value between 5 and 1000. To retrieve the
         * remaining results, make another call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. Specify a value between 5 and 1000. To
         *        retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> spotInstanceRequestIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotInstanceRequestsRequest model) {
            super(model);
            filters(model.filters);
            spotInstanceRequestIds(model.spotInstanceRequestIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getSpotInstanceRequestIds() {
            if (spotInstanceRequestIds instanceof SdkAutoConstructList) {
                return null;
            }
            return spotInstanceRequestIds;
        }

        @Override
        public final Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequestIds(String... spotInstanceRequestIds) {
            spotInstanceRequestIds(Arrays.asList(spotInstanceRequestIds));
            return this;
        }

        public final void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSpotInstanceRequestsRequest build() {
            return new DescribeSpotInstanceRequestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
