/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportImageResponse extends Ec2Response implements
        ToCopyableBuilder<ExportImageResponse.Builder, ExportImageResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ExportImageResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> DISK_IMAGE_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DiskImageFormat")
            .getter(getter(ExportImageResponse::diskImageFormatAsString))
            .setter(setter(Builder::diskImageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageFormat")
                    .unmarshallLocationName("diskImageFormat").build()).build();

    private static final SdkField<String> EXPORT_IMAGE_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExportImageTaskId")
            .getter(getter(ExportImageResponse::exportImageTaskId))
            .setter(setter(Builder::exportImageTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportImageTaskId")
                    .unmarshallLocationName("exportImageTaskId").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ExportImageResponse::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RoleName")
            .getter(getter(ExportImageResponse::roleName))
            .setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName")
                    .unmarshallLocationName("roleName").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Progress")
            .getter(getter(ExportImageResponse::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<ExportTaskS3Location> S3_EXPORT_LOCATION_FIELD = SdkField
            .<ExportTaskS3Location> builder(MarshallingType.SDK_POJO)
            .memberName("S3ExportLocation")
            .getter(getter(ExportImageResponse::s3ExportLocation))
            .setter(setter(Builder::s3ExportLocation))
            .constructor(ExportTaskS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportLocation")
                    .unmarshallLocationName("s3ExportLocation").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ExportImageResponse::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(ExportImageResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ExportImageResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DISK_IMAGE_FORMAT_FIELD, EXPORT_IMAGE_TASK_ID_FIELD, IMAGE_ID_FIELD, ROLE_NAME_FIELD, PROGRESS_FIELD,
            S3_EXPORT_LOCATION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD));

    private final String description;

    private final String diskImageFormat;

    private final String exportImageTaskId;

    private final String imageId;

    private final String roleName;

    private final String progress;

    private final ExportTaskS3Location s3ExportLocation;

    private final String status;

    private final String statusMessage;

    private final List<Tag> tags;

    private ExportImageResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.diskImageFormat = builder.diskImageFormat;
        this.exportImageTaskId = builder.exportImageTaskId;
        this.imageId = builder.imageId;
        this.roleName = builder.roleName;
        this.progress = builder.progress;
        this.s3ExportLocation = builder.s3ExportLocation;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A description of the image being exported.
     * </p>
     * 
     * @return A description of the image being exported.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The disk image format for the exported image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return The disk image format for the exported image.
     * @see DiskImageFormat
     */
    public DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(diskImageFormat);
    }

    /**
     * <p>
     * The disk image format for the exported image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return The disk image format for the exported image.
     * @see DiskImageFormat
     */
    public String diskImageFormatAsString() {
        return diskImageFormat;
    }

    /**
     * <p>
     * The ID of the export image task.
     * </p>
     * 
     * @return The ID of the export image task.
     */
    public String exportImageTaskId() {
        return exportImageTaskId;
    }

    /**
     * <p>
     * The ID of the image.
     * </p>
     * 
     * @return The ID of the image.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the role that grants VM Import/Export permission to export images to your Amazon S3 bucket.
     * </p>
     * 
     * @return The name of the role that grants VM Import/Export permission to export images to your Amazon S3 bucket.
     */
    public String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The percent complete of the export image task.
     * </p>
     * 
     * @return The percent complete of the export image task.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * Information about the destination Amazon S3 bucket.
     * </p>
     * 
     * @return Information about the destination Amazon S3 bucket.
     */
    public ExportTaskS3Location s3ExportLocation() {
        return s3ExportLocation;
    }

    /**
     * <p>
     * The status of the export image task. The possible values are <code>active</code>, <code>completed</code>,
     * <code>deleting</code>, and <code>deleted</code>.
     * </p>
     * 
     * @return The status of the export image task. The possible values are <code>active</code>, <code>completed</code>,
     *         <code>deleting</code>, and <code>deleted</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The status message for the export image task.
     * </p>
     * 
     * @return The status message for the export image task.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the image being exported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the image being exported.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportImageTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportImageResponse)) {
            return false;
        }
        ExportImageResponse other = (ExportImageResponse) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(diskImageFormatAsString(), other.diskImageFormatAsString())
                && Objects.equals(exportImageTaskId(), other.exportImageTaskId()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(roleName(), other.roleName()) && Objects.equals(progress(), other.progress())
                && Objects.equals(s3ExportLocation(), other.s3ExportLocation()) && Objects.equals(status(), other.status())
                && Objects.equals(statusMessage(), other.statusMessage()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportImageResponse").add("Description", description())
                .add("DiskImageFormat", diskImageFormatAsString()).add("ExportImageTaskId", exportImageTaskId())
                .add("ImageId", imageId()).add("RoleName", roleName()).add("Progress", progress())
                .add("S3ExportLocation", s3ExportLocation()).add("Status", status()).add("StatusMessage", statusMessage())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiskImageFormat":
            return Optional.ofNullable(clazz.cast(diskImageFormatAsString()));
        case "ExportImageTaskId":
            return Optional.ofNullable(clazz.cast(exportImageTaskId()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "S3ExportLocation":
            return Optional.ofNullable(clazz.cast(s3ExportLocation()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportImageResponse, T> g) {
        return obj -> g.apply((ExportImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ExportImageResponse> {
        /**
         * <p>
         * A description of the image being exported.
         * </p>
         * 
         * @param description
         *        A description of the image being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The disk image format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The disk image format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(String diskImageFormat);

        /**
         * <p>
         * The disk image format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The disk image format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(DiskImageFormat diskImageFormat);

        /**
         * <p>
         * The ID of the export image task.
         * </p>
         * 
         * @param exportImageTaskId
         *        The ID of the export image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportImageTaskId(String exportImageTaskId);

        /**
         * <p>
         * The ID of the image.
         * </p>
         * 
         * @param imageId
         *        The ID of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the role that grants VM Import/Export permission to export images to your Amazon S3 bucket.
         * </p>
         * 
         * @param roleName
         *        The name of the role that grants VM Import/Export permission to export images to your Amazon S3
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The percent complete of the export image task.
         * </p>
         * 
         * @param progress
         *        The percent complete of the export image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * Information about the destination Amazon S3 bucket.
         * </p>
         * 
         * @param s3ExportLocation
         *        Information about the destination Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportLocation(ExportTaskS3Location s3ExportLocation);

        /**
         * <p>
         * Information about the destination Amazon S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportTaskS3Location.Builder} avoiding the need
         * to create one manually via {@link ExportTaskS3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportTaskS3Location.Builder#build()} is called immediately and
         * its result is passed to {@link #s3ExportLocation(ExportTaskS3Location)}.
         * 
         * @param s3ExportLocation
         *        a consumer that will call methods on {@link ExportTaskS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ExportLocation(ExportTaskS3Location)
         */
        default Builder s3ExportLocation(Consumer<ExportTaskS3Location.Builder> s3ExportLocation) {
            return s3ExportLocation(ExportTaskS3Location.builder().applyMutation(s3ExportLocation).build());
        }

        /**
         * <p>
         * The status of the export image task. The possible values are <code>active</code>, <code>completed</code>,
         * <code>deleting</code>, and <code>deleted</code>.
         * </p>
         * 
         * @param status
         *        The status of the export image task. The possible values are <code>active</code>,
         *        <code>completed</code>, <code>deleting</code>, and <code>deleted</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The status message for the export image task.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the export image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Any tags assigned to the image being exported.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the image being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the image being exported.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the image being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the image being exported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String description;

        private String diskImageFormat;

        private String exportImageTaskId;

        private String imageId;

        private String roleName;

        private String progress;

        private ExportTaskS3Location s3ExportLocation;

        private String status;

        private String statusMessage;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportImageResponse model) {
            super(model);
            description(model.description);
            diskImageFormat(model.diskImageFormat);
            exportImageTaskId(model.exportImageTaskId);
            imageId(model.imageId);
            roleName(model.roleName);
            progress(model.progress);
            s3ExportLocation(model.s3ExportLocation);
            status(model.status);
            statusMessage(model.statusMessage);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDiskImageFormat() {
            return diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat == null ? null : diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final String getExportImageTaskId() {
            return exportImageTaskId;
        }

        @Override
        public final Builder exportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
            return this;
        }

        public final void setExportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final ExportTaskS3Location.Builder getS3ExportLocation() {
            return s3ExportLocation != null ? s3ExportLocation.toBuilder() : null;
        }

        @Override
        public final Builder s3ExportLocation(ExportTaskS3Location s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation;
            return this;
        }

        public final void setS3ExportLocation(ExportTaskS3Location.BuilderImpl s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation != null ? s3ExportLocation.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public ExportImageResponse build() {
            return new ExportImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
