/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExportEnvironment {
    CITRIX("citrix"),
    VMWARE("vmware"),
    MICROSOFT("microsoft"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExportEnvironment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportEnvironment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExportEnvironment.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportEnvironment> knownValues() {
        return Stream.of(ExportEnvironment.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

