/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcClassicLinkRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeVpcClassicLinkRequest.Builder, DescribeVpcClassicLinkRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeVpcClassicLinkRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> VPC_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcIds")
            .getter(getter(DescribeVpcClassicLinkRequest::vpcIds))
            .setter(setter(Builder::vpcIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcId").unmarshallLocationName("VpcId").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, VPC_IDS_FIELD));

    private final List<Filter> filters;

    private final List<String> vpcIds;

    private DescribeVpcClassicLinkRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.vpcIds = builder.vpcIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> |
     * <code>false</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> |
     *         <code>false</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * Returns true if the VpcIds property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVpcIds() {
        return vpcIds != null && !(vpcIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more VPCs for which you want to describe the ClassicLink status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more VPCs for which you want to describe the ClassicLink status.
     */
    public List<String> vpcIds() {
        return vpcIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcIds() ? vpcIds() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkRequest)) {
            return false;
        }
        DescribeVpcClassicLinkRequest other = (DescribeVpcClassicLinkRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasVpcIds() == other.hasVpcIds() && Objects.equals(vpcIds(), other.vpcIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVpcClassicLinkRequest").add("Filters", hasFilters() ? filters() : null)
                .add("VpcIds", hasVpcIds() ? vpcIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "VpcIds":
            return Optional.ofNullable(clazz.cast(vpcIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcClassicLinkRequest, T> g) {
        return obj -> g.apply((DescribeVpcClassicLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpcClassicLinkRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> |
         * <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> |
         *        <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> |
         * <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> |
         *        <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> |
         * <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more VPCs for which you want to describe the ClassicLink status.
         * </p>
         * 
         * @param vpcIds
         *        One or more VPCs for which you want to describe the ClassicLink status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIds(Collection<String> vpcIds);

        /**
         * <p>
         * One or more VPCs for which you want to describe the ClassicLink status.
         * </p>
         * 
         * @param vpcIds
         *        One or more VPCs for which you want to describe the ClassicLink status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIds(String... vpcIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkRequest model) {
            super(model);
            filters(model.filters);
            vpcIds(model.vpcIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpcIds() {
            if (vpcIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcIds;
        }

        @Override
        public final Builder vpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcIds(String... vpcIds) {
            vpcIds(Arrays.asList(vpcIds));
            return this;
        }

        public final void setVpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVpcClassicLinkRequest build() {
            return new DescribeVpcClassicLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
