/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an explanation code for an unreachable path. For more information, see <a
 * href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation
 * codes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Explanation implements SdkPojo, Serializable, ToCopyableBuilder<Explanation.Builder, Explanation> {
    private static final SdkField<AnalysisComponent> ACL_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Acl")
            .getter(getter(Explanation::acl))
            .setter(setter(Builder::acl))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Acl").unmarshallLocationName("acl")
                    .build()).build();

    private static final SdkField<AnalysisAclRule> ACL_RULE_FIELD = SdkField
            .<AnalysisAclRule> builder(MarshallingType.SDK_POJO)
            .memberName("AclRule")
            .getter(getter(Explanation::aclRule))
            .setter(setter(Builder::aclRule))
            .constructor(AnalysisAclRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclRule")
                    .unmarshallLocationName("aclRule").build()).build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Address")
            .getter(getter(Explanation::address))
            .setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address")
                    .unmarshallLocationName("address").build()).build();

    private static final SdkField<List<String>> ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Addresses")
            .getter(getter(Explanation::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressSet")
                    .unmarshallLocationName("addressSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AnalysisComponent> ATTACHED_TO_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("AttachedTo")
            .getter(getter(Explanation::attachedTo))
            .setter(setter(Builder::attachedTo))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedTo")
                    .unmarshallLocationName("attachedTo").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(Explanation::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneSet")
                    .unmarshallLocationName("availabilityZoneSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Cidrs")
            .getter(getter(Explanation::cidrs))
            .setter(setter(Builder::cidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrSet")
                    .unmarshallLocationName("cidrSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Component")
            .getter(getter(Explanation::component))
            .setter(setter(Builder::component))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component")
                    .unmarshallLocationName("component").build()).build();

    private static final SdkField<AnalysisComponent> CUSTOMER_GATEWAY_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerGateway")
            .getter(getter(Explanation::customerGateway))
            .setter(setter(Builder::customerGateway))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGateway")
                    .unmarshallLocationName("customerGateway").build()).build();

    private static final SdkField<AnalysisComponent> DESTINATION_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Destination")
            .getter(getter(Explanation::destination))
            .setter(setter(Builder::destination))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination")
                    .unmarshallLocationName("destination").build()).build();

    private static final SdkField<AnalysisComponent> DESTINATION_VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationVpc")
            .getter(getter(Explanation::destinationVpc))
            .setter(setter(Builder::destinationVpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationVpc")
                    .unmarshallLocationName("destinationVpc").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Direction")
            .getter(getter(Explanation::direction))
            .setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction")
                    .unmarshallLocationName("direction").build()).build();

    private static final SdkField<String> EXPLANATION_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExplanationCode")
            .getter(getter(Explanation::explanationCode))
            .setter(setter(Builder::explanationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplanationCode")
                    .unmarshallLocationName("explanationCode").build()).build();

    private static final SdkField<AnalysisComponent> INGRESS_ROUTE_TABLE_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("IngressRouteTable")
            .getter(getter(Explanation::ingressRouteTable))
            .setter(setter(Builder::ingressRouteTable))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressRouteTable")
                    .unmarshallLocationName("ingressRouteTable").build()).build();

    private static final SdkField<AnalysisComponent> INTERNET_GATEWAY_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("InternetGateway")
            .getter(getter(Explanation::internetGateway))
            .setter(setter(Builder::internetGateway))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGateway")
                    .unmarshallLocationName("internetGateway").build()).build();

    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerArn")
            .getter(getter(Explanation::loadBalancerArn))
            .setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn")
                    .unmarshallLocationName("loadBalancerArn").build()).build();

    private static final SdkField<AnalysisLoadBalancerListener> CLASSIC_LOAD_BALANCER_LISTENER_FIELD = SdkField
            .<AnalysisLoadBalancerListener> builder(MarshallingType.SDK_POJO)
            .memberName("ClassicLoadBalancerListener")
            .getter(getter(Explanation::classicLoadBalancerListener))
            .setter(setter(Builder::classicLoadBalancerListener))
            .constructor(AnalysisLoadBalancerListener::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLoadBalancerListener")
                    .unmarshallLocationName("classicLoadBalancerListener").build()).build();

    private static final SdkField<Integer> LOAD_BALANCER_LISTENER_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LoadBalancerListenerPort")
            .getter(getter(Explanation::loadBalancerListenerPort))
            .setter(setter(Builder::loadBalancerListenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerListenerPort")
                    .unmarshallLocationName("loadBalancerListenerPort").build()).build();

    private static final SdkField<AnalysisLoadBalancerTarget> LOAD_BALANCER_TARGET_FIELD = SdkField
            .<AnalysisLoadBalancerTarget> builder(MarshallingType.SDK_POJO)
            .memberName("LoadBalancerTarget")
            .getter(getter(Explanation::loadBalancerTarget))
            .setter(setter(Builder::loadBalancerTarget))
            .constructor(AnalysisLoadBalancerTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTarget")
                    .unmarshallLocationName("loadBalancerTarget").build()).build();

    private static final SdkField<AnalysisComponent> LOAD_BALANCER_TARGET_GROUP_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("LoadBalancerTargetGroup")
            .getter(getter(Explanation::loadBalancerTargetGroup))
            .setter(setter(Builder::loadBalancerTargetGroup))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTargetGroup")
                    .unmarshallLocationName("loadBalancerTargetGroup").build()).build();

    private static final SdkField<List<AnalysisComponent>> LOAD_BALANCER_TARGET_GROUPS_FIELD = SdkField
            .<List<AnalysisComponent>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerTargetGroups")
            .getter(getter(Explanation::loadBalancerTargetGroups))
            .setter(setter(Builder::loadBalancerTargetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTargetGroupSet")
                    .unmarshallLocationName("loadBalancerTargetGroupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AnalysisComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> LOAD_BALANCER_TARGET_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LoadBalancerTargetPort")
            .getter(getter(Explanation::loadBalancerTargetPort))
            .setter(setter(Builder::loadBalancerTargetPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTargetPort")
                    .unmarshallLocationName("loadBalancerTargetPort").build()).build();

    private static final SdkField<AnalysisComponent> ELASTIC_LOAD_BALANCER_LISTENER_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("ElasticLoadBalancerListener")
            .getter(getter(Explanation::elasticLoadBalancerListener))
            .setter(setter(Builder::elasticLoadBalancerListener))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticLoadBalancerListener")
                    .unmarshallLocationName("elasticLoadBalancerListener").build()).build();

    private static final SdkField<String> MISSING_COMPONENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MissingComponent")
            .getter(getter(Explanation::missingComponent))
            .setter(setter(Builder::missingComponent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingComponent")
                    .unmarshallLocationName("missingComponent").build()).build();

    private static final SdkField<AnalysisComponent> NAT_GATEWAY_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("NatGateway")
            .getter(getter(Explanation::natGateway))
            .setter(setter(Builder::natGateway))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGateway")
                    .unmarshallLocationName("natGateway").build()).build();

    private static final SdkField<AnalysisComponent> NETWORK_INTERFACE_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkInterface")
            .getter(getter(Explanation::networkInterface))
            .setter(setter(Builder::networkInterface))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface")
                    .unmarshallLocationName("networkInterface").build()).build();

    private static final SdkField<String> PACKET_FIELD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PacketField")
            .getter(getter(Explanation::packetField))
            .setter(setter(Builder::packetField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketField")
                    .unmarshallLocationName("packetField").build()).build();

    private static final SdkField<AnalysisComponent> VPC_PEERING_CONNECTION_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("VpcPeeringConnection")
            .getter(getter(Explanation::vpcPeeringConnection))
            .setter(setter(Builder::vpcPeeringConnection))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnection")
                    .unmarshallLocationName("vpcPeeringConnection").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Port")
            .getter(getter(Explanation::port))
            .setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port")
                    .unmarshallLocationName("port").build()).build();

    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("PortRanges")
            .getter(getter(Explanation::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRangeSet")
                    .unmarshallLocationName("portRangeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AnalysisComponent> PREFIX_LIST_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("PrefixList")
            .getter(getter(Explanation::prefixList))
            .setter(setter(Builder::prefixList))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixList")
                    .unmarshallLocationName("prefixList").build()).build();

    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Protocols")
            .getter(getter(Explanation::protocols))
            .setter(setter(Builder::protocols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolSet")
                    .unmarshallLocationName("protocolSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AnalysisRouteTableRoute> ROUTE_TABLE_ROUTE_FIELD = SdkField
            .<AnalysisRouteTableRoute> builder(MarshallingType.SDK_POJO)
            .memberName("RouteTableRoute")
            .getter(getter(Explanation::routeTableRoute))
            .setter(setter(Builder::routeTableRoute))
            .constructor(AnalysisRouteTableRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableRoute")
                    .unmarshallLocationName("routeTableRoute").build()).build();

    private static final SdkField<AnalysisComponent> ROUTE_TABLE_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("RouteTable")
            .getter(getter(Explanation::routeTable))
            .setter(setter(Builder::routeTable))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTable")
                    .unmarshallLocationName("routeTable").build()).build();

    private static final SdkField<AnalysisComponent> SECURITY_GROUP_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("SecurityGroup")
            .getter(getter(Explanation::securityGroup))
            .setter(setter(Builder::securityGroup))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup")
                    .unmarshallLocationName("securityGroup").build()).build();

    private static final SdkField<AnalysisSecurityGroupRule> SECURITY_GROUP_RULE_FIELD = SdkField
            .<AnalysisSecurityGroupRule> builder(MarshallingType.SDK_POJO)
            .memberName("SecurityGroupRule")
            .getter(getter(Explanation::securityGroupRule))
            .setter(setter(Builder::securityGroupRule))
            .constructor(AnalysisSecurityGroupRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule")
                    .unmarshallLocationName("securityGroupRule").build()).build();

    private static final SdkField<List<AnalysisComponent>> SECURITY_GROUPS_FIELD = SdkField
            .<List<AnalysisComponent>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(Explanation::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupSet")
                    .unmarshallLocationName("securityGroupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AnalysisComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AnalysisComponent> SOURCE_VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("SourceVpc")
            .getter(getter(Explanation::sourceVpc))
            .setter(setter(Builder::sourceVpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVpc")
                    .unmarshallLocationName("sourceVpc").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(Explanation::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<AnalysisComponent> SUBNET_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Subnet")
            .getter(getter(Explanation::subnet))
            .setter(setter(Builder::subnet))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet")
                    .unmarshallLocationName("subnet").build()).build();

    private static final SdkField<AnalysisComponent> SUBNET_ROUTE_TABLE_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("SubnetRouteTable")
            .getter(getter(Explanation::subnetRouteTable))
            .setter(setter(Builder::subnetRouteTable))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetRouteTable")
                    .unmarshallLocationName("subnetRouteTable").build()).build();

    private static final SdkField<AnalysisComponent> VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Vpc")
            .getter(getter(Explanation::vpc))
            .setter(setter(Builder::vpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").unmarshallLocationName("vpc")
                    .build()).build();

    private static final SdkField<AnalysisComponent> VPC_ENDPOINT_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("VpcEndpoint")
            .getter(getter(Explanation::vpcEndpoint))
            .setter(setter(Builder::vpcEndpoint))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoint")
                    .unmarshallLocationName("vpcEndpoint").build()).build();

    private static final SdkField<AnalysisComponent> VPN_CONNECTION_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("VpnConnection")
            .getter(getter(Explanation::vpnConnection))
            .setter(setter(Builder::vpnConnection))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnection")
                    .unmarshallLocationName("vpnConnection").build()).build();

    private static final SdkField<AnalysisComponent> VPN_GATEWAY_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("VpnGateway")
            .getter(getter(Explanation::vpnGateway))
            .setter(setter(Builder::vpnGateway))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGateway")
                    .unmarshallLocationName("vpnGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACL_FIELD, ACL_RULE_FIELD,
            ADDRESS_FIELD, ADDRESSES_FIELD, ATTACHED_TO_FIELD, AVAILABILITY_ZONES_FIELD, CIDRS_FIELD, COMPONENT_FIELD,
            CUSTOMER_GATEWAY_FIELD, DESTINATION_FIELD, DESTINATION_VPC_FIELD, DIRECTION_FIELD, EXPLANATION_CODE_FIELD,
            INGRESS_ROUTE_TABLE_FIELD, INTERNET_GATEWAY_FIELD, LOAD_BALANCER_ARN_FIELD, CLASSIC_LOAD_BALANCER_LISTENER_FIELD,
            LOAD_BALANCER_LISTENER_PORT_FIELD, LOAD_BALANCER_TARGET_FIELD, LOAD_BALANCER_TARGET_GROUP_FIELD,
            LOAD_BALANCER_TARGET_GROUPS_FIELD, LOAD_BALANCER_TARGET_PORT_FIELD, ELASTIC_LOAD_BALANCER_LISTENER_FIELD,
            MISSING_COMPONENT_FIELD, NAT_GATEWAY_FIELD, NETWORK_INTERFACE_FIELD, PACKET_FIELD_FIELD,
            VPC_PEERING_CONNECTION_FIELD, PORT_FIELD, PORT_RANGES_FIELD, PREFIX_LIST_FIELD, PROTOCOLS_FIELD,
            ROUTE_TABLE_ROUTE_FIELD, ROUTE_TABLE_FIELD, SECURITY_GROUP_FIELD, SECURITY_GROUP_RULE_FIELD, SECURITY_GROUPS_FIELD,
            SOURCE_VPC_FIELD, STATE_FIELD, SUBNET_FIELD, SUBNET_ROUTE_TABLE_FIELD, VPC_FIELD, VPC_ENDPOINT_FIELD,
            VPN_CONNECTION_FIELD, VPN_GATEWAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final AnalysisComponent acl;

    private final AnalysisAclRule aclRule;

    private final String address;

    private final List<String> addresses;

    private final AnalysisComponent attachedTo;

    private final List<String> availabilityZones;

    private final List<String> cidrs;

    private final AnalysisComponent component;

    private final AnalysisComponent customerGateway;

    private final AnalysisComponent destination;

    private final AnalysisComponent destinationVpc;

    private final String direction;

    private final String explanationCode;

    private final AnalysisComponent ingressRouteTable;

    private final AnalysisComponent internetGateway;

    private final String loadBalancerArn;

    private final AnalysisLoadBalancerListener classicLoadBalancerListener;

    private final Integer loadBalancerListenerPort;

    private final AnalysisLoadBalancerTarget loadBalancerTarget;

    private final AnalysisComponent loadBalancerTargetGroup;

    private final List<AnalysisComponent> loadBalancerTargetGroups;

    private final Integer loadBalancerTargetPort;

    private final AnalysisComponent elasticLoadBalancerListener;

    private final String missingComponent;

    private final AnalysisComponent natGateway;

    private final AnalysisComponent networkInterface;

    private final String packetField;

    private final AnalysisComponent vpcPeeringConnection;

    private final Integer port;

    private final List<PortRange> portRanges;

    private final AnalysisComponent prefixList;

    private final List<String> protocols;

    private final AnalysisRouteTableRoute routeTableRoute;

    private final AnalysisComponent routeTable;

    private final AnalysisComponent securityGroup;

    private final AnalysisSecurityGroupRule securityGroupRule;

    private final List<AnalysisComponent> securityGroups;

    private final AnalysisComponent sourceVpc;

    private final String state;

    private final AnalysisComponent subnet;

    private final AnalysisComponent subnetRouteTable;

    private final AnalysisComponent vpc;

    private final AnalysisComponent vpcEndpoint;

    private final AnalysisComponent vpnConnection;

    private final AnalysisComponent vpnGateway;

    private Explanation(BuilderImpl builder) {
        this.acl = builder.acl;
        this.aclRule = builder.aclRule;
        this.address = builder.address;
        this.addresses = builder.addresses;
        this.attachedTo = builder.attachedTo;
        this.availabilityZones = builder.availabilityZones;
        this.cidrs = builder.cidrs;
        this.component = builder.component;
        this.customerGateway = builder.customerGateway;
        this.destination = builder.destination;
        this.destinationVpc = builder.destinationVpc;
        this.direction = builder.direction;
        this.explanationCode = builder.explanationCode;
        this.ingressRouteTable = builder.ingressRouteTable;
        this.internetGateway = builder.internetGateway;
        this.loadBalancerArn = builder.loadBalancerArn;
        this.classicLoadBalancerListener = builder.classicLoadBalancerListener;
        this.loadBalancerListenerPort = builder.loadBalancerListenerPort;
        this.loadBalancerTarget = builder.loadBalancerTarget;
        this.loadBalancerTargetGroup = builder.loadBalancerTargetGroup;
        this.loadBalancerTargetGroups = builder.loadBalancerTargetGroups;
        this.loadBalancerTargetPort = builder.loadBalancerTargetPort;
        this.elasticLoadBalancerListener = builder.elasticLoadBalancerListener;
        this.missingComponent = builder.missingComponent;
        this.natGateway = builder.natGateway;
        this.networkInterface = builder.networkInterface;
        this.packetField = builder.packetField;
        this.vpcPeeringConnection = builder.vpcPeeringConnection;
        this.port = builder.port;
        this.portRanges = builder.portRanges;
        this.prefixList = builder.prefixList;
        this.protocols = builder.protocols;
        this.routeTableRoute = builder.routeTableRoute;
        this.routeTable = builder.routeTable;
        this.securityGroup = builder.securityGroup;
        this.securityGroupRule = builder.securityGroupRule;
        this.securityGroups = builder.securityGroups;
        this.sourceVpc = builder.sourceVpc;
        this.state = builder.state;
        this.subnet = builder.subnet;
        this.subnetRouteTable = builder.subnetRouteTable;
        this.vpc = builder.vpc;
        this.vpcEndpoint = builder.vpcEndpoint;
        this.vpnConnection = builder.vpnConnection;
        this.vpnGateway = builder.vpnGateway;
    }

    /**
     * <p>
     * The network ACL.
     * </p>
     * 
     * @return The network ACL.
     */
    public AnalysisComponent acl() {
        return acl;
    }

    /**
     * <p>
     * The network ACL rule.
     * </p>
     * 
     * @return The network ACL rule.
     */
    public AnalysisAclRule aclRule() {
        return aclRule;
    }

    /**
     * <p>
     * The IPv4 address, in CIDR notation.
     * </p>
     * 
     * @return The IPv4 address, in CIDR notation.
     */
    public String address() {
        return address;
    }

    /**
     * Returns true if the Addresses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAddresses() {
        return addresses != null && !(addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 addresses, in CIDR notation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv4 addresses, in CIDR notation.
     */
    public List<String> addresses() {
        return addresses;
    }

    /**
     * <p>
     * The resource to which the component is attached.
     * </p>
     * 
     * @return The resource to which the component is attached.
     */
    public AnalysisComponent attachedTo() {
        return attachedTo;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Availability Zones.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * Returns true if the Cidrs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCidrs() {
        return cidrs != null && !(cidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CIDR ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCidrs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The CIDR ranges.
     */
    public List<String> cidrs() {
        return cidrs;
    }

    /**
     * <p>
     * The component.
     * </p>
     * 
     * @return The component.
     */
    public AnalysisComponent component() {
        return component;
    }

    /**
     * <p>
     * The customer gateway.
     * </p>
     * 
     * @return The customer gateway.
     */
    public AnalysisComponent customerGateway() {
        return customerGateway;
    }

    /**
     * <p>
     * The destination.
     * </p>
     * 
     * @return The destination.
     */
    public AnalysisComponent destination() {
        return destination;
    }

    /**
     * <p>
     * The destination VPC.
     * </p>
     * 
     * @return The destination VPC.
     */
    public AnalysisComponent destinationVpc() {
        return destinationVpc;
    }

    /**
     * <p>
     * The direction. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * egress
     * </p>
     * </li>
     * <li>
     * <p>
     * ingress
     * </p>
     * </li>
     * </ul>
     * 
     * @return The direction. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         egress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ingress
     *         </p>
     *         </li>
     */
    public String direction() {
        return direction;
    }

    /**
     * <p>
     * The explanation code.
     * </p>
     * 
     * @return The explanation code.
     */
    public String explanationCode() {
        return explanationCode;
    }

    /**
     * <p>
     * The route table.
     * </p>
     * 
     * @return The route table.
     */
    public AnalysisComponent ingressRouteTable() {
        return ingressRouteTable;
    }

    /**
     * <p>
     * The internet gateway.
     * </p>
     * 
     * @return The internet gateway.
     */
    public AnalysisComponent internetGateway() {
        return internetGateway;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * <p>
     * The listener for a Classic Load Balancer.
     * </p>
     * 
     * @return The listener for a Classic Load Balancer.
     */
    public AnalysisLoadBalancerListener classicLoadBalancerListener() {
        return classicLoadBalancerListener;
    }

    /**
     * <p>
     * The listener port of the load balancer.
     * </p>
     * 
     * @return The listener port of the load balancer.
     */
    public Integer loadBalancerListenerPort() {
        return loadBalancerListenerPort;
    }

    /**
     * <p>
     * The target.
     * </p>
     * 
     * @return The target.
     */
    public AnalysisLoadBalancerTarget loadBalancerTarget() {
        return loadBalancerTarget;
    }

    /**
     * <p>
     * The target group.
     * </p>
     * 
     * @return The target group.
     */
    public AnalysisComponent loadBalancerTargetGroup() {
        return loadBalancerTargetGroup;
    }

    /**
     * Returns true if the LoadBalancerTargetGroups property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLoadBalancerTargetGroups() {
        return loadBalancerTargetGroups != null && !(loadBalancerTargetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoadBalancerTargetGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The target groups.
     */
    public List<AnalysisComponent> loadBalancerTargetGroups() {
        return loadBalancerTargetGroups;
    }

    /**
     * <p>
     * The target port.
     * </p>
     * 
     * @return The target port.
     */
    public Integer loadBalancerTargetPort() {
        return loadBalancerTargetPort;
    }

    /**
     * <p>
     * The load balancer listener.
     * </p>
     * 
     * @return The load balancer listener.
     */
    public AnalysisComponent elasticLoadBalancerListener() {
        return elasticLoadBalancerListener;
    }

    /**
     * <p>
     * The missing component.
     * </p>
     * 
     * @return The missing component.
     */
    public String missingComponent() {
        return missingComponent;
    }

    /**
     * <p>
     * The NAT gateway.
     * </p>
     * 
     * @return The NAT gateway.
     */
    public AnalysisComponent natGateway() {
        return natGateway;
    }

    /**
     * <p>
     * The network interface.
     * </p>
     * 
     * @return The network interface.
     */
    public AnalysisComponent networkInterface() {
        return networkInterface;
    }

    /**
     * <p>
     * The packet field.
     * </p>
     * 
     * @return The packet field.
     */
    public String packetField() {
        return packetField;
    }

    /**
     * <p>
     * The VPC peering connection.
     * </p>
     * 
     * @return The VPC peering connection.
     */
    public AnalysisComponent vpcPeeringConnection() {
        return vpcPeeringConnection;
    }

    /**
     * <p>
     * The port.
     * </p>
     * 
     * @return The port.
     */
    public Integer port() {
        return port;
    }

    /**
     * Returns true if the PortRanges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The port ranges.
     */
    public List<PortRange> portRanges() {
        return portRanges;
    }

    /**
     * <p>
     * The prefix list.
     * </p>
     * 
     * @return The prefix list.
     */
    public AnalysisComponent prefixList() {
        return prefixList;
    }

    /**
     * Returns true if the Protocols property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProtocols() {
        return protocols != null && !(protocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocols.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProtocols()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The protocols.
     */
    public List<String> protocols() {
        return protocols;
    }

    /**
     * <p>
     * The route table route.
     * </p>
     * 
     * @return The route table route.
     */
    public AnalysisRouteTableRoute routeTableRoute() {
        return routeTableRoute;
    }

    /**
     * <p>
     * The route table.
     * </p>
     * 
     * @return The route table.
     */
    public AnalysisComponent routeTable() {
        return routeTable;
    }

    /**
     * <p>
     * The security group.
     * </p>
     * 
     * @return The security group.
     */
    public AnalysisComponent securityGroup() {
        return securityGroup;
    }

    /**
     * <p>
     * The security group rule.
     * </p>
     * 
     * @return The security group rule.
     */
    public AnalysisSecurityGroupRule securityGroupRule() {
        return securityGroupRule;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security groups.
     */
    public List<AnalysisComponent> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The source VPC.
     * </p>
     * 
     * @return The source VPC.
     */
    public AnalysisComponent sourceVpc() {
        return sourceVpc;
    }

    /**
     * <p>
     * The state.
     * </p>
     * 
     * @return The state.
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The subnet.
     * </p>
     * 
     * @return The subnet.
     */
    public AnalysisComponent subnet() {
        return subnet;
    }

    /**
     * <p>
     * The route table for the subnet.
     * </p>
     * 
     * @return The route table for the subnet.
     */
    public AnalysisComponent subnetRouteTable() {
        return subnetRouteTable;
    }

    /**
     * <p>
     * The component VPC.
     * </p>
     * 
     * @return The component VPC.
     */
    public AnalysisComponent vpc() {
        return vpc;
    }

    /**
     * <p>
     * The VPC endpoint.
     * </p>
     * 
     * @return The VPC endpoint.
     */
    public AnalysisComponent vpcEndpoint() {
        return vpcEndpoint;
    }

    /**
     * <p>
     * The VPN connection.
     * </p>
     * 
     * @return The VPN connection.
     */
    public AnalysisComponent vpnConnection() {
        return vpnConnection;
    }

    /**
     * <p>
     * The VPN gateway.
     * </p>
     * 
     * @return The VPN gateway.
     */
    public AnalysisComponent vpnGateway() {
        return vpnGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acl());
        hashCode = 31 * hashCode + Objects.hashCode(aclRule());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddresses() ? addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attachedTo());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrs() ? cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(component());
        hashCode = 31 * hashCode + Objects.hashCode(customerGateway());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationVpc());
        hashCode = 31 * hashCode + Objects.hashCode(direction());
        hashCode = 31 * hashCode + Objects.hashCode(explanationCode());
        hashCode = 31 * hashCode + Objects.hashCode(ingressRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(internetGateway());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(classicLoadBalancerListener());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerListenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerTarget());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerTargetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerTargetGroups() ? loadBalancerTargetGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerTargetPort());
        hashCode = 31 * hashCode + Objects.hashCode(elasticLoadBalancerListener());
        hashCode = 31 * hashCode + Objects.hashCode(missingComponent());
        hashCode = 31 * hashCode + Objects.hashCode(natGateway());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(packetField());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnection());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(prefixList());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocols() ? protocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeTableRoute());
        hashCode = 31 * hashCode + Objects.hashCode(routeTable());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupRule());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceVpc());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        hashCode = 31 * hashCode + Objects.hashCode(subnetRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnection());
        hashCode = 31 * hashCode + Objects.hashCode(vpnGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Explanation)) {
            return false;
        }
        Explanation other = (Explanation) obj;
        return Objects.equals(acl(), other.acl()) && Objects.equals(aclRule(), other.aclRule())
                && Objects.equals(address(), other.address()) && hasAddresses() == other.hasAddresses()
                && Objects.equals(addresses(), other.addresses()) && Objects.equals(attachedTo(), other.attachedTo())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && hasCidrs() == other.hasCidrs()
                && Objects.equals(cidrs(), other.cidrs()) && Objects.equals(component(), other.component())
                && Objects.equals(customerGateway(), other.customerGateway())
                && Objects.equals(destination(), other.destination()) && Objects.equals(destinationVpc(), other.destinationVpc())
                && Objects.equals(direction(), other.direction()) && Objects.equals(explanationCode(), other.explanationCode())
                && Objects.equals(ingressRouteTable(), other.ingressRouteTable())
                && Objects.equals(internetGateway(), other.internetGateway())
                && Objects.equals(loadBalancerArn(), other.loadBalancerArn())
                && Objects.equals(classicLoadBalancerListener(), other.classicLoadBalancerListener())
                && Objects.equals(loadBalancerListenerPort(), other.loadBalancerListenerPort())
                && Objects.equals(loadBalancerTarget(), other.loadBalancerTarget())
                && Objects.equals(loadBalancerTargetGroup(), other.loadBalancerTargetGroup())
                && hasLoadBalancerTargetGroups() == other.hasLoadBalancerTargetGroups()
                && Objects.equals(loadBalancerTargetGroups(), other.loadBalancerTargetGroups())
                && Objects.equals(loadBalancerTargetPort(), other.loadBalancerTargetPort())
                && Objects.equals(elasticLoadBalancerListener(), other.elasticLoadBalancerListener())
                && Objects.equals(missingComponent(), other.missingComponent())
                && Objects.equals(natGateway(), other.natGateway())
                && Objects.equals(networkInterface(), other.networkInterface())
                && Objects.equals(packetField(), other.packetField())
                && Objects.equals(vpcPeeringConnection(), other.vpcPeeringConnection()) && Objects.equals(port(), other.port())
                && hasPortRanges() == other.hasPortRanges() && Objects.equals(portRanges(), other.portRanges())
                && Objects.equals(prefixList(), other.prefixList()) && hasProtocols() == other.hasProtocols()
                && Objects.equals(protocols(), other.protocols()) && Objects.equals(routeTableRoute(), other.routeTableRoute())
                && Objects.equals(routeTable(), other.routeTable()) && Objects.equals(securityGroup(), other.securityGroup())
                && Objects.equals(securityGroupRule(), other.securityGroupRule())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(sourceVpc(), other.sourceVpc()) && Objects.equals(state(), other.state())
                && Objects.equals(subnet(), other.subnet()) && Objects.equals(subnetRouteTable(), other.subnetRouteTable())
                && Objects.equals(vpc(), other.vpc()) && Objects.equals(vpcEndpoint(), other.vpcEndpoint())
                && Objects.equals(vpnConnection(), other.vpnConnection()) && Objects.equals(vpnGateway(), other.vpnGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Explanation").add("Acl", acl()).add("AclRule", aclRule()).add("Address", address())
                .add("Addresses", hasAddresses() ? addresses() : null).add("AttachedTo", attachedTo())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("Cidrs", hasCidrs() ? cidrs() : null).add("Component", component())
                .add("CustomerGateway", customerGateway()).add("Destination", destination())
                .add("DestinationVpc", destinationVpc()).add("Direction", direction()).add("ExplanationCode", explanationCode())
                .add("IngressRouteTable", ingressRouteTable()).add("InternetGateway", internetGateway())
                .add("LoadBalancerArn", loadBalancerArn()).add("ClassicLoadBalancerListener", classicLoadBalancerListener())
                .add("LoadBalancerListenerPort", loadBalancerListenerPort()).add("LoadBalancerTarget", loadBalancerTarget())
                .add("LoadBalancerTargetGroup", loadBalancerTargetGroup())
                .add("LoadBalancerTargetGroups", hasLoadBalancerTargetGroups() ? loadBalancerTargetGroups() : null)
                .add("LoadBalancerTargetPort", loadBalancerTargetPort())
                .add("ElasticLoadBalancerListener", elasticLoadBalancerListener()).add("MissingComponent", missingComponent())
                .add("NatGateway", natGateway()).add("NetworkInterface", networkInterface()).add("PacketField", packetField())
                .add("VpcPeeringConnection", vpcPeeringConnection()).add("Port", port())
                .add("PortRanges", hasPortRanges() ? portRanges() : null).add("PrefixList", prefixList())
                .add("Protocols", hasProtocols() ? protocols() : null).add("RouteTableRoute", routeTableRoute())
                .add("RouteTable", routeTable()).add("SecurityGroup", securityGroup())
                .add("SecurityGroupRule", securityGroupRule())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SourceVpc", sourceVpc())
                .add("State", state()).add("Subnet", subnet()).add("SubnetRouteTable", subnetRouteTable()).add("Vpc", vpc())
                .add("VpcEndpoint", vpcEndpoint()).add("VpnConnection", vpnConnection()).add("VpnGateway", vpnGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Acl":
            return Optional.ofNullable(clazz.cast(acl()));
        case "AclRule":
            return Optional.ofNullable(clazz.cast(aclRule()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        case "AttachedTo":
            return Optional.ofNullable(clazz.cast(attachedTo()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "Cidrs":
            return Optional.ofNullable(clazz.cast(cidrs()));
        case "Component":
            return Optional.ofNullable(clazz.cast(component()));
        case "CustomerGateway":
            return Optional.ofNullable(clazz.cast(customerGateway()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationVpc":
            return Optional.ofNullable(clazz.cast(destinationVpc()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(direction()));
        case "ExplanationCode":
            return Optional.ofNullable(clazz.cast(explanationCode()));
        case "IngressRouteTable":
            return Optional.ofNullable(clazz.cast(ingressRouteTable()));
        case "InternetGateway":
            return Optional.ofNullable(clazz.cast(internetGateway()));
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "ClassicLoadBalancerListener":
            return Optional.ofNullable(clazz.cast(classicLoadBalancerListener()));
        case "LoadBalancerListenerPort":
            return Optional.ofNullable(clazz.cast(loadBalancerListenerPort()));
        case "LoadBalancerTarget":
            return Optional.ofNullable(clazz.cast(loadBalancerTarget()));
        case "LoadBalancerTargetGroup":
            return Optional.ofNullable(clazz.cast(loadBalancerTargetGroup()));
        case "LoadBalancerTargetGroups":
            return Optional.ofNullable(clazz.cast(loadBalancerTargetGroups()));
        case "LoadBalancerTargetPort":
            return Optional.ofNullable(clazz.cast(loadBalancerTargetPort()));
        case "ElasticLoadBalancerListener":
            return Optional.ofNullable(clazz.cast(elasticLoadBalancerListener()));
        case "MissingComponent":
            return Optional.ofNullable(clazz.cast(missingComponent()));
        case "NatGateway":
            return Optional.ofNullable(clazz.cast(natGateway()));
        case "NetworkInterface":
            return Optional.ofNullable(clazz.cast(networkInterface()));
        case "PacketField":
            return Optional.ofNullable(clazz.cast(packetField()));
        case "VpcPeeringConnection":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnection()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "PortRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        case "PrefixList":
            return Optional.ofNullable(clazz.cast(prefixList()));
        case "Protocols":
            return Optional.ofNullable(clazz.cast(protocols()));
        case "RouteTableRoute":
            return Optional.ofNullable(clazz.cast(routeTableRoute()));
        case "RouteTable":
            return Optional.ofNullable(clazz.cast(routeTable()));
        case "SecurityGroup":
            return Optional.ofNullable(clazz.cast(securityGroup()));
        case "SecurityGroupRule":
            return Optional.ofNullable(clazz.cast(securityGroupRule()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SourceVpc":
            return Optional.ofNullable(clazz.cast(sourceVpc()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Subnet":
            return Optional.ofNullable(clazz.cast(subnet()));
        case "SubnetRouteTable":
            return Optional.ofNullable(clazz.cast(subnetRouteTable()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "VpcEndpoint":
            return Optional.ofNullable(clazz.cast(vpcEndpoint()));
        case "VpnConnection":
            return Optional.ofNullable(clazz.cast(vpnConnection()));
        case "VpnGateway":
            return Optional.ofNullable(clazz.cast(vpnGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Explanation, T> g) {
        return obj -> g.apply((Explanation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Explanation> {
        /**
         * <p>
         * The network ACL.
         * </p>
         * 
         * @param acl
         *        The network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acl(AnalysisComponent acl);

        /**
         * <p>
         * The network ACL.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #acl(AnalysisComponent)}.
         * 
         * @param acl
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acl(AnalysisComponent)
         */
        default Builder acl(Consumer<AnalysisComponent.Builder> acl) {
            return acl(AnalysisComponent.builder().applyMutation(acl).build());
        }

        /**
         * <p>
         * The network ACL rule.
         * </p>
         * 
         * @param aclRule
         *        The network ACL rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aclRule(AnalysisAclRule aclRule);

        /**
         * <p>
         * The network ACL rule.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisAclRule.Builder} avoiding the need to
         * create one manually via {@link AnalysisAclRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisAclRule.Builder#build()} is called immediately and its
         * result is passed to {@link #aclRule(AnalysisAclRule)}.
         * 
         * @param aclRule
         *        a consumer that will call methods on {@link AnalysisAclRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aclRule(AnalysisAclRule)
         */
        default Builder aclRule(Consumer<AnalysisAclRule.Builder> aclRule) {
            return aclRule(AnalysisAclRule.builder().applyMutation(aclRule).build());
        }

        /**
         * <p>
         * The IPv4 address, in CIDR notation.
         * </p>
         * 
         * @param address
         *        The IPv4 address, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The IPv4 addresses, in CIDR notation.
         * </p>
         * 
         * @param addresses
         *        The IPv4 addresses, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<String> addresses);

        /**
         * <p>
         * The IPv4 addresses, in CIDR notation.
         * </p>
         * 
         * @param addresses
         *        The IPv4 addresses, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(String... addresses);

        /**
         * <p>
         * The resource to which the component is attached.
         * </p>
         * 
         * @param attachedTo
         *        The resource to which the component is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedTo(AnalysisComponent attachedTo);

        /**
         * <p>
         * The resource to which the component is attached.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #attachedTo(AnalysisComponent)}.
         * 
         * @param attachedTo
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedTo(AnalysisComponent)
         */
        default Builder attachedTo(Consumer<AnalysisComponent.Builder> attachedTo) {
            return attachedTo(AnalysisComponent.builder().applyMutation(attachedTo).build());
        }

        /**
         * <p>
         * The Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The CIDR ranges.
         * </p>
         * 
         * @param cidrs
         *        The CIDR ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(Collection<String> cidrs);

        /**
         * <p>
         * The CIDR ranges.
         * </p>
         * 
         * @param cidrs
         *        The CIDR ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(String... cidrs);

        /**
         * <p>
         * The component.
         * </p>
         * 
         * @param component
         *        The component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder component(AnalysisComponent component);

        /**
         * <p>
         * The component.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #component(AnalysisComponent)}.
         * 
         * @param component
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #component(AnalysisComponent)
         */
        default Builder component(Consumer<AnalysisComponent.Builder> component) {
            return component(AnalysisComponent.builder().applyMutation(component).build());
        }

        /**
         * <p>
         * The customer gateway.
         * </p>
         * 
         * @param customerGateway
         *        The customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGateway(AnalysisComponent customerGateway);

        /**
         * <p>
         * The customer gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #customerGateway(AnalysisComponent)}.
         * 
         * @param customerGateway
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerGateway(AnalysisComponent)
         */
        default Builder customerGateway(Consumer<AnalysisComponent.Builder> customerGateway) {
            return customerGateway(AnalysisComponent.builder().applyMutation(customerGateway).build());
        }

        /**
         * <p>
         * The destination.
         * </p>
         * 
         * @param destination
         *        The destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(AnalysisComponent destination);

        /**
         * <p>
         * The destination.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(AnalysisComponent)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(AnalysisComponent)
         */
        default Builder destination(Consumer<AnalysisComponent.Builder> destination) {
            return destination(AnalysisComponent.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The destination VPC.
         * </p>
         * 
         * @param destinationVpc
         *        The destination VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationVpc(AnalysisComponent destinationVpc);

        /**
         * <p>
         * The destination VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationVpc(AnalysisComponent)}.
         * 
         * @param destinationVpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationVpc(AnalysisComponent)
         */
        default Builder destinationVpc(Consumer<AnalysisComponent.Builder> destinationVpc) {
            return destinationVpc(AnalysisComponent.builder().applyMutation(destinationVpc).build());
        }

        /**
         * <p>
         * The direction. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * egress
         * </p>
         * </li>
         * <li>
         * <p>
         * ingress
         * </p>
         * </li>
         * </ul>
         * 
         * @param direction
         *        The direction. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        egress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ingress
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder direction(String direction);

        /**
         * <p>
         * The explanation code.
         * </p>
         * 
         * @param explanationCode
         *        The explanation code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explanationCode(String explanationCode);

        /**
         * <p>
         * The route table.
         * </p>
         * 
         * @param ingressRouteTable
         *        The route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressRouteTable(AnalysisComponent ingressRouteTable);

        /**
         * <p>
         * The route table.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #ingressRouteTable(AnalysisComponent)}.
         * 
         * @param ingressRouteTable
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressRouteTable(AnalysisComponent)
         */
        default Builder ingressRouteTable(Consumer<AnalysisComponent.Builder> ingressRouteTable) {
            return ingressRouteTable(AnalysisComponent.builder().applyMutation(ingressRouteTable).build());
        }

        /**
         * <p>
         * The internet gateway.
         * </p>
         * 
         * @param internetGateway
         *        The internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateway(AnalysisComponent internetGateway);

        /**
         * <p>
         * The internet gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #internetGateway(AnalysisComponent)}.
         * 
         * @param internetGateway
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetGateway(AnalysisComponent)
         */
        default Builder internetGateway(Consumer<AnalysisComponent.Builder> internetGateway) {
            return internetGateway(AnalysisComponent.builder().applyMutation(internetGateway).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The listener for a Classic Load Balancer.
         * </p>
         * 
         * @param classicLoadBalancerListener
         *        The listener for a Classic Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancerListener(AnalysisLoadBalancerListener classicLoadBalancerListener);

        /**
         * <p>
         * The listener for a Classic Load Balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisLoadBalancerListener.Builder} avoiding
         * the need to create one manually via {@link AnalysisLoadBalancerListener#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisLoadBalancerListener.Builder#build()} is called
         * immediately and its result is passed to {@link #classicLoadBalancerListener(AnalysisLoadBalancerListener)}.
         * 
         * @param classicLoadBalancerListener
         *        a consumer that will call methods on {@link AnalysisLoadBalancerListener.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classicLoadBalancerListener(AnalysisLoadBalancerListener)
         */
        default Builder classicLoadBalancerListener(Consumer<AnalysisLoadBalancerListener.Builder> classicLoadBalancerListener) {
            return classicLoadBalancerListener(AnalysisLoadBalancerListener.builder().applyMutation(classicLoadBalancerListener)
                    .build());
        }

        /**
         * <p>
         * The listener port of the load balancer.
         * </p>
         * 
         * @param loadBalancerListenerPort
         *        The listener port of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerListenerPort(Integer loadBalancerListenerPort);

        /**
         * <p>
         * The target.
         * </p>
         * 
         * @param loadBalancerTarget
         *        The target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTarget(AnalysisLoadBalancerTarget loadBalancerTarget);

        /**
         * <p>
         * The target.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisLoadBalancerTarget.Builder} avoiding the
         * need to create one manually via {@link AnalysisLoadBalancerTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisLoadBalancerTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #loadBalancerTarget(AnalysisLoadBalancerTarget)}.
         * 
         * @param loadBalancerTarget
         *        a consumer that will call methods on {@link AnalysisLoadBalancerTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerTarget(AnalysisLoadBalancerTarget)
         */
        default Builder loadBalancerTarget(Consumer<AnalysisLoadBalancerTarget.Builder> loadBalancerTarget) {
            return loadBalancerTarget(AnalysisLoadBalancerTarget.builder().applyMutation(loadBalancerTarget).build());
        }

        /**
         * <p>
         * The target group.
         * </p>
         * 
         * @param loadBalancerTargetGroup
         *        The target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroup(AnalysisComponent loadBalancerTargetGroup);

        /**
         * <p>
         * The target group.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancerTargetGroup(AnalysisComponent)}.
         * 
         * @param loadBalancerTargetGroup
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerTargetGroup(AnalysisComponent)
         */
        default Builder loadBalancerTargetGroup(Consumer<AnalysisComponent.Builder> loadBalancerTargetGroup) {
            return loadBalancerTargetGroup(AnalysisComponent.builder().applyMutation(loadBalancerTargetGroup).build());
        }

        /**
         * <p>
         * The target groups.
         * </p>
         * 
         * @param loadBalancerTargetGroups
         *        The target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroups(Collection<AnalysisComponent> loadBalancerTargetGroups);

        /**
         * <p>
         * The target groups.
         * </p>
         * 
         * @param loadBalancerTargetGroups
         *        The target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroups(AnalysisComponent... loadBalancerTargetGroups);

        /**
         * <p>
         * The target groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AnalysisComponent>.Builder} avoiding the
         * need to create one manually via {@link List<AnalysisComponent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnalysisComponent>.Builder#build()} is called immediately
         * and its result is passed to {@link #loadBalancerTargetGroups(List<AnalysisComponent>)}.
         * 
         * @param loadBalancerTargetGroups
         *        a consumer that will call methods on {@link List<AnalysisComponent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerTargetGroups(List<AnalysisComponent>)
         */
        Builder loadBalancerTargetGroups(Consumer<AnalysisComponent.Builder>... loadBalancerTargetGroups);

        /**
         * <p>
         * The target port.
         * </p>
         * 
         * @param loadBalancerTargetPort
         *        The target port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetPort(Integer loadBalancerTargetPort);

        /**
         * <p>
         * The load balancer listener.
         * </p>
         * 
         * @param elasticLoadBalancerListener
         *        The load balancer listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancerListener(AnalysisComponent elasticLoadBalancerListener);

        /**
         * <p>
         * The load balancer listener.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #elasticLoadBalancerListener(AnalysisComponent)}.
         * 
         * @param elasticLoadBalancerListener
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticLoadBalancerListener(AnalysisComponent)
         */
        default Builder elasticLoadBalancerListener(Consumer<AnalysisComponent.Builder> elasticLoadBalancerListener) {
            return elasticLoadBalancerListener(AnalysisComponent.builder().applyMutation(elasticLoadBalancerListener).build());
        }

        /**
         * <p>
         * The missing component.
         * </p>
         * 
         * @param missingComponent
         *        The missing component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingComponent(String missingComponent);

        /**
         * <p>
         * The NAT gateway.
         * </p>
         * 
         * @param natGateway
         *        The NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGateway(AnalysisComponent natGateway);

        /**
         * <p>
         * The NAT gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #natGateway(AnalysisComponent)}.
         * 
         * @param natGateway
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #natGateway(AnalysisComponent)
         */
        default Builder natGateway(Consumer<AnalysisComponent.Builder> natGateway) {
            return natGateway(AnalysisComponent.builder().applyMutation(natGateway).build());
        }

        /**
         * <p>
         * The network interface.
         * </p>
         * 
         * @param networkInterface
         *        The network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterface(AnalysisComponent networkInterface);

        /**
         * <p>
         * The network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #networkInterface(AnalysisComponent)}.
         * 
         * @param networkInterface
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterface(AnalysisComponent)
         */
        default Builder networkInterface(Consumer<AnalysisComponent.Builder> networkInterface) {
            return networkInterface(AnalysisComponent.builder().applyMutation(networkInterface).build());
        }

        /**
         * <p>
         * The packet field.
         * </p>
         * 
         * @param packetField
         *        The packet field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetField(String packetField);

        /**
         * <p>
         * The VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnection
         *        The VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnection(AnalysisComponent vpcPeeringConnection);

        /**
         * <p>
         * The VPC peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcPeeringConnection(AnalysisComponent)}.
         * 
         * @param vpcPeeringConnection
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcPeeringConnection(AnalysisComponent)
         */
        default Builder vpcPeeringConnection(Consumer<AnalysisComponent.Builder> vpcPeeringConnection) {
            return vpcPeeringConnection(AnalysisComponent.builder().applyMutation(vpcPeeringConnection).build());
        }

        /**
         * <p>
         * The port.
         * </p>
         * 
         * @param port
         *        The port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The port ranges.
         * </p>
         * 
         * @param portRanges
         *        The port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<PortRange> portRanges);

        /**
         * <p>
         * The port ranges.
         * </p>
         * 
         * @param portRanges
         *        The port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(PortRange... portRanges);

        /**
         * <p>
         * The port ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortRange>.Builder} avoiding the need to
         * create one manually via {@link List<PortRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #portRanges(List<PortRange>)}.
         * 
         * @param portRanges
         *        a consumer that will call methods on {@link List<PortRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRanges(List<PortRange>)
         */
        Builder portRanges(Consumer<PortRange.Builder>... portRanges);

        /**
         * <p>
         * The prefix list.
         * </p>
         * 
         * @param prefixList
         *        The prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixList(AnalysisComponent prefixList);

        /**
         * <p>
         * The prefix list.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #prefixList(AnalysisComponent)}.
         * 
         * @param prefixList
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixList(AnalysisComponent)
         */
        default Builder prefixList(Consumer<AnalysisComponent.Builder> prefixList) {
            return prefixList(AnalysisComponent.builder().applyMutation(prefixList).build());
        }

        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param protocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Collection<String> protocols);

        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param protocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(String... protocols);

        /**
         * <p>
         * The route table route.
         * </p>
         * 
         * @param routeTableRoute
         *        The route table route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute);

        /**
         * <p>
         * The route table route.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisRouteTableRoute.Builder} avoiding the
         * need to create one manually via {@link AnalysisRouteTableRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisRouteTableRoute.Builder#build()} is called immediately
         * and its result is passed to {@link #routeTableRoute(AnalysisRouteTableRoute)}.
         * 
         * @param routeTableRoute
         *        a consumer that will call methods on {@link AnalysisRouteTableRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTableRoute(AnalysisRouteTableRoute)
         */
        default Builder routeTableRoute(Consumer<AnalysisRouteTableRoute.Builder> routeTableRoute) {
            return routeTableRoute(AnalysisRouteTableRoute.builder().applyMutation(routeTableRoute).build());
        }

        /**
         * <p>
         * The route table.
         * </p>
         * 
         * @param routeTable
         *        The route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTable(AnalysisComponent routeTable);

        /**
         * <p>
         * The route table.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #routeTable(AnalysisComponent)}.
         * 
         * @param routeTable
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTable(AnalysisComponent)
         */
        default Builder routeTable(Consumer<AnalysisComponent.Builder> routeTable) {
            return routeTable(AnalysisComponent.builder().applyMutation(routeTable).build());
        }

        /**
         * <p>
         * The security group.
         * </p>
         * 
         * @param securityGroup
         *        The security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroup(AnalysisComponent securityGroup);

        /**
         * <p>
         * The security group.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #securityGroup(AnalysisComponent)}.
         * 
         * @param securityGroup
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroup(AnalysisComponent)
         */
        default Builder securityGroup(Consumer<AnalysisComponent.Builder> securityGroup) {
            return securityGroup(AnalysisComponent.builder().applyMutation(securityGroup).build());
        }

        /**
         * <p>
         * The security group rule.
         * </p>
         * 
         * @param securityGroupRule
         *        The security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule);

        /**
         * <p>
         * The security group rule.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisSecurityGroupRule.Builder} avoiding the
         * need to create one manually via {@link AnalysisSecurityGroupRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisSecurityGroupRule.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroupRule(AnalysisSecurityGroupRule)}.
         * 
         * @param securityGroupRule
         *        a consumer that will call methods on {@link AnalysisSecurityGroupRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupRule(AnalysisSecurityGroupRule)
         */
        default Builder securityGroupRule(Consumer<AnalysisSecurityGroupRule.Builder> securityGroupRule) {
            return securityGroupRule(AnalysisSecurityGroupRule.builder().applyMutation(securityGroupRule).build());
        }

        /**
         * <p>
         * The security groups.
         * </p>
         * 
         * @param securityGroups
         *        The security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<AnalysisComponent> securityGroups);

        /**
         * <p>
         * The security groups.
         * </p>
         * 
         * @param securityGroups
         *        The security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(AnalysisComponent... securityGroups);

        /**
         * <p>
         * The security groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AnalysisComponent>.Builder} avoiding the
         * need to create one manually via {@link List<AnalysisComponent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnalysisComponent>.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroups(List<AnalysisComponent>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on {@link List<AnalysisComponent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(List<AnalysisComponent>)
         */
        Builder securityGroups(Consumer<AnalysisComponent.Builder>... securityGroups);

        /**
         * <p>
         * The source VPC.
         * </p>
         * 
         * @param sourceVpc
         *        The source VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVpc(AnalysisComponent sourceVpc);

        /**
         * <p>
         * The source VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceVpc(AnalysisComponent)}.
         * 
         * @param sourceVpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceVpc(AnalysisComponent)
         */
        default Builder sourceVpc(Consumer<AnalysisComponent.Builder> sourceVpc) {
            return sourceVpc(AnalysisComponent.builder().applyMutation(sourceVpc).build());
        }

        /**
         * <p>
         * The state.
         * </p>
         * 
         * @param state
         *        The state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The subnet.
         * </p>
         * 
         * @param subnet
         *        The subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(AnalysisComponent subnet);

        /**
         * <p>
         * The subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #subnet(AnalysisComponent)}.
         * 
         * @param subnet
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnet(AnalysisComponent)
         */
        default Builder subnet(Consumer<AnalysisComponent.Builder> subnet) {
            return subnet(AnalysisComponent.builder().applyMutation(subnet).build());
        }

        /**
         * <p>
         * The route table for the subnet.
         * </p>
         * 
         * @param subnetRouteTable
         *        The route table for the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetRouteTable(AnalysisComponent subnetRouteTable);

        /**
         * <p>
         * The route table for the subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #subnetRouteTable(AnalysisComponent)}.
         * 
         * @param subnetRouteTable
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetRouteTable(AnalysisComponent)
         */
        default Builder subnetRouteTable(Consumer<AnalysisComponent.Builder> subnetRouteTable) {
            return subnetRouteTable(AnalysisComponent.builder().applyMutation(subnetRouteTable).build());
        }

        /**
         * <p>
         * The component VPC.
         * </p>
         * 
         * @param vpc
         *        The component VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(AnalysisComponent vpc);

        /**
         * <p>
         * The component VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #vpc(AnalysisComponent)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(AnalysisComponent)
         */
        default Builder vpc(Consumer<AnalysisComponent.Builder> vpc) {
            return vpc(AnalysisComponent.builder().applyMutation(vpc).build());
        }

        /**
         * <p>
         * The VPC endpoint.
         * </p>
         * 
         * @param vpcEndpoint
         *        The VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoint(AnalysisComponent vpcEndpoint);

        /**
         * <p>
         * The VPC endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcEndpoint(AnalysisComponent)}.
         * 
         * @param vpcEndpoint
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpoint(AnalysisComponent)
         */
        default Builder vpcEndpoint(Consumer<AnalysisComponent.Builder> vpcEndpoint) {
            return vpcEndpoint(AnalysisComponent.builder().applyMutation(vpcEndpoint).build());
        }

        /**
         * <p>
         * The VPN connection.
         * </p>
         * 
         * @param vpnConnection
         *        The VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnection(AnalysisComponent vpnConnection);

        /**
         * <p>
         * The VPN connection.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #vpnConnection(AnalysisComponent)}.
         * 
         * @param vpnConnection
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnConnection(AnalysisComponent)
         */
        default Builder vpnConnection(Consumer<AnalysisComponent.Builder> vpnConnection) {
            return vpnConnection(AnalysisComponent.builder().applyMutation(vpnConnection).build());
        }

        /**
         * <p>
         * The VPN gateway.
         * </p>
         * 
         * @param vpnGateway
         *        The VPN gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateway(AnalysisComponent vpnGateway);

        /**
         * <p>
         * The VPN gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #vpnGateway(AnalysisComponent)}.
         * 
         * @param vpnGateway
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnGateway(AnalysisComponent)
         */
        default Builder vpnGateway(Consumer<AnalysisComponent.Builder> vpnGateway) {
            return vpnGateway(AnalysisComponent.builder().applyMutation(vpnGateway).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnalysisComponent acl;

        private AnalysisAclRule aclRule;

        private String address;

        private List<String> addresses = DefaultSdkAutoConstructList.getInstance();

        private AnalysisComponent attachedTo;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();

        private AnalysisComponent component;

        private AnalysisComponent customerGateway;

        private AnalysisComponent destination;

        private AnalysisComponent destinationVpc;

        private String direction;

        private String explanationCode;

        private AnalysisComponent ingressRouteTable;

        private AnalysisComponent internetGateway;

        private String loadBalancerArn;

        private AnalysisLoadBalancerListener classicLoadBalancerListener;

        private Integer loadBalancerListenerPort;

        private AnalysisLoadBalancerTarget loadBalancerTarget;

        private AnalysisComponent loadBalancerTargetGroup;

        private List<AnalysisComponent> loadBalancerTargetGroups = DefaultSdkAutoConstructList.getInstance();

        private Integer loadBalancerTargetPort;

        private AnalysisComponent elasticLoadBalancerListener;

        private String missingComponent;

        private AnalysisComponent natGateway;

        private AnalysisComponent networkInterface;

        private String packetField;

        private AnalysisComponent vpcPeeringConnection;

        private Integer port;

        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private AnalysisComponent prefixList;

        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private AnalysisRouteTableRoute routeTableRoute;

        private AnalysisComponent routeTable;

        private AnalysisComponent securityGroup;

        private AnalysisSecurityGroupRule securityGroupRule;

        private List<AnalysisComponent> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private AnalysisComponent sourceVpc;

        private String state;

        private AnalysisComponent subnet;

        private AnalysisComponent subnetRouteTable;

        private AnalysisComponent vpc;

        private AnalysisComponent vpcEndpoint;

        private AnalysisComponent vpnConnection;

        private AnalysisComponent vpnGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(Explanation model) {
            acl(model.acl);
            aclRule(model.aclRule);
            address(model.address);
            addresses(model.addresses);
            attachedTo(model.attachedTo);
            availabilityZones(model.availabilityZones);
            cidrs(model.cidrs);
            component(model.component);
            customerGateway(model.customerGateway);
            destination(model.destination);
            destinationVpc(model.destinationVpc);
            direction(model.direction);
            explanationCode(model.explanationCode);
            ingressRouteTable(model.ingressRouteTable);
            internetGateway(model.internetGateway);
            loadBalancerArn(model.loadBalancerArn);
            classicLoadBalancerListener(model.classicLoadBalancerListener);
            loadBalancerListenerPort(model.loadBalancerListenerPort);
            loadBalancerTarget(model.loadBalancerTarget);
            loadBalancerTargetGroup(model.loadBalancerTargetGroup);
            loadBalancerTargetGroups(model.loadBalancerTargetGroups);
            loadBalancerTargetPort(model.loadBalancerTargetPort);
            elasticLoadBalancerListener(model.elasticLoadBalancerListener);
            missingComponent(model.missingComponent);
            natGateway(model.natGateway);
            networkInterface(model.networkInterface);
            packetField(model.packetField);
            vpcPeeringConnection(model.vpcPeeringConnection);
            port(model.port);
            portRanges(model.portRanges);
            prefixList(model.prefixList);
            protocols(model.protocols);
            routeTableRoute(model.routeTableRoute);
            routeTable(model.routeTable);
            securityGroup(model.securityGroup);
            securityGroupRule(model.securityGroupRule);
            securityGroups(model.securityGroups);
            sourceVpc(model.sourceVpc);
            state(model.state);
            subnet(model.subnet);
            subnetRouteTable(model.subnetRouteTable);
            vpc(model.vpc);
            vpcEndpoint(model.vpcEndpoint);
            vpnConnection(model.vpnConnection);
            vpnGateway(model.vpnGateway);
        }

        public final AnalysisComponent.Builder getAcl() {
            return acl != null ? acl.toBuilder() : null;
        }

        @Override
        public final Builder acl(AnalysisComponent acl) {
            this.acl = acl;
            return this;
        }

        public final void setAcl(AnalysisComponent.BuilderImpl acl) {
            this.acl = acl != null ? acl.build() : null;
        }

        public final AnalysisAclRule.Builder getAclRule() {
            return aclRule != null ? aclRule.toBuilder() : null;
        }

        @Override
        public final Builder aclRule(AnalysisAclRule aclRule) {
            this.aclRule = aclRule;
            return this;
        }

        public final void setAclRule(AnalysisAclRule.BuilderImpl aclRule) {
            this.aclRule = aclRule != null ? aclRule.build() : null;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final Collection<String> getAddresses() {
            if (addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return addresses;
        }

        @Override
        public final Builder addresses(Collection<String> addresses) {
            this.addresses = IpAddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(String... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        public final void setAddresses(Collection<String> addresses) {
            this.addresses = IpAddressListCopier.copy(addresses);
        }

        public final AnalysisComponent.Builder getAttachedTo() {
            return attachedTo != null ? attachedTo.toBuilder() : null;
        }

        @Override
        public final Builder attachedTo(AnalysisComponent attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final void setAttachedTo(AnalysisComponent.BuilderImpl attachedTo) {
            this.attachedTo = attachedTo != null ? attachedTo.build() : null;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        public final Collection<String> getCidrs() {
            if (cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrs;
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String... cidrs) {
            cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
        }

        public final AnalysisComponent.Builder getComponent() {
            return component != null ? component.toBuilder() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        public final AnalysisComponent.Builder getCustomerGateway() {
            return customerGateway != null ? customerGateway.toBuilder() : null;
        }

        @Override
        public final Builder customerGateway(AnalysisComponent customerGateway) {
            this.customerGateway = customerGateway;
            return this;
        }

        public final void setCustomerGateway(AnalysisComponent.BuilderImpl customerGateway) {
            this.customerGateway = customerGateway != null ? customerGateway.build() : null;
        }

        public final AnalysisComponent.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(AnalysisComponent destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(AnalysisComponent.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final AnalysisComponent.Builder getDestinationVpc() {
            return destinationVpc != null ? destinationVpc.toBuilder() : null;
        }

        @Override
        public final Builder destinationVpc(AnalysisComponent destinationVpc) {
            this.destinationVpc = destinationVpc;
            return this;
        }

        public final void setDestinationVpc(AnalysisComponent.BuilderImpl destinationVpc) {
            this.destinationVpc = destinationVpc != null ? destinationVpc.build() : null;
        }

        public final String getDirection() {
            return direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        public final String getExplanationCode() {
            return explanationCode;
        }

        @Override
        public final Builder explanationCode(String explanationCode) {
            this.explanationCode = explanationCode;
            return this;
        }

        public final void setExplanationCode(String explanationCode) {
            this.explanationCode = explanationCode;
        }

        public final AnalysisComponent.Builder getIngressRouteTable() {
            return ingressRouteTable != null ? ingressRouteTable.toBuilder() : null;
        }

        @Override
        public final Builder ingressRouteTable(AnalysisComponent ingressRouteTable) {
            this.ingressRouteTable = ingressRouteTable;
            return this;
        }

        public final void setIngressRouteTable(AnalysisComponent.BuilderImpl ingressRouteTable) {
            this.ingressRouteTable = ingressRouteTable != null ? ingressRouteTable.build() : null;
        }

        public final AnalysisComponent.Builder getInternetGateway() {
            return internetGateway != null ? internetGateway.toBuilder() : null;
        }

        @Override
        public final Builder internetGateway(AnalysisComponent internetGateway) {
            this.internetGateway = internetGateway;
            return this;
        }

        public final void setInternetGateway(AnalysisComponent.BuilderImpl internetGateway) {
            this.internetGateway = internetGateway != null ? internetGateway.build() : null;
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final AnalysisLoadBalancerListener.Builder getClassicLoadBalancerListener() {
            return classicLoadBalancerListener != null ? classicLoadBalancerListener.toBuilder() : null;
        }

        @Override
        public final Builder classicLoadBalancerListener(AnalysisLoadBalancerListener classicLoadBalancerListener) {
            this.classicLoadBalancerListener = classicLoadBalancerListener;
            return this;
        }

        public final void setClassicLoadBalancerListener(AnalysisLoadBalancerListener.BuilderImpl classicLoadBalancerListener) {
            this.classicLoadBalancerListener = classicLoadBalancerListener != null ? classicLoadBalancerListener.build() : null;
        }

        public final Integer getLoadBalancerListenerPort() {
            return loadBalancerListenerPort;
        }

        @Override
        public final Builder loadBalancerListenerPort(Integer loadBalancerListenerPort) {
            this.loadBalancerListenerPort = loadBalancerListenerPort;
            return this;
        }

        public final void setLoadBalancerListenerPort(Integer loadBalancerListenerPort) {
            this.loadBalancerListenerPort = loadBalancerListenerPort;
        }

        public final AnalysisLoadBalancerTarget.Builder getLoadBalancerTarget() {
            return loadBalancerTarget != null ? loadBalancerTarget.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerTarget(AnalysisLoadBalancerTarget loadBalancerTarget) {
            this.loadBalancerTarget = loadBalancerTarget;
            return this;
        }

        public final void setLoadBalancerTarget(AnalysisLoadBalancerTarget.BuilderImpl loadBalancerTarget) {
            this.loadBalancerTarget = loadBalancerTarget != null ? loadBalancerTarget.build() : null;
        }

        public final AnalysisComponent.Builder getLoadBalancerTargetGroup() {
            return loadBalancerTargetGroup != null ? loadBalancerTargetGroup.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerTargetGroup(AnalysisComponent loadBalancerTargetGroup) {
            this.loadBalancerTargetGroup = loadBalancerTargetGroup;
            return this;
        }

        public final void setLoadBalancerTargetGroup(AnalysisComponent.BuilderImpl loadBalancerTargetGroup) {
            this.loadBalancerTargetGroup = loadBalancerTargetGroup != null ? loadBalancerTargetGroup.build() : null;
        }

        public final Collection<AnalysisComponent.Builder> getLoadBalancerTargetGroups() {
            if (loadBalancerTargetGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return loadBalancerTargetGroups != null ? loadBalancerTargetGroups.stream().map(AnalysisComponent::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancerTargetGroups(Collection<AnalysisComponent> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = AnalysisComponentListCopier.copy(loadBalancerTargetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(AnalysisComponent... loadBalancerTargetGroups) {
            loadBalancerTargetGroups(Arrays.asList(loadBalancerTargetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(Consumer<AnalysisComponent.Builder>... loadBalancerTargetGroups) {
            loadBalancerTargetGroups(Stream.of(loadBalancerTargetGroups)
                    .map(c -> AnalysisComponent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancerTargetGroups(Collection<AnalysisComponent.BuilderImpl> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = AnalysisComponentListCopier.copyFromBuilder(loadBalancerTargetGroups);
        }

        public final Integer getLoadBalancerTargetPort() {
            return loadBalancerTargetPort;
        }

        @Override
        public final Builder loadBalancerTargetPort(Integer loadBalancerTargetPort) {
            this.loadBalancerTargetPort = loadBalancerTargetPort;
            return this;
        }

        public final void setLoadBalancerTargetPort(Integer loadBalancerTargetPort) {
            this.loadBalancerTargetPort = loadBalancerTargetPort;
        }

        public final AnalysisComponent.Builder getElasticLoadBalancerListener() {
            return elasticLoadBalancerListener != null ? elasticLoadBalancerListener.toBuilder() : null;
        }

        @Override
        public final Builder elasticLoadBalancerListener(AnalysisComponent elasticLoadBalancerListener) {
            this.elasticLoadBalancerListener = elasticLoadBalancerListener;
            return this;
        }

        public final void setElasticLoadBalancerListener(AnalysisComponent.BuilderImpl elasticLoadBalancerListener) {
            this.elasticLoadBalancerListener = elasticLoadBalancerListener != null ? elasticLoadBalancerListener.build() : null;
        }

        public final String getMissingComponent() {
            return missingComponent;
        }

        @Override
        public final Builder missingComponent(String missingComponent) {
            this.missingComponent = missingComponent;
            return this;
        }

        public final void setMissingComponent(String missingComponent) {
            this.missingComponent = missingComponent;
        }

        public final AnalysisComponent.Builder getNatGateway() {
            return natGateway != null ? natGateway.toBuilder() : null;
        }

        @Override
        public final Builder natGateway(AnalysisComponent natGateway) {
            this.natGateway = natGateway;
            return this;
        }

        public final void setNatGateway(AnalysisComponent.BuilderImpl natGateway) {
            this.natGateway = natGateway != null ? natGateway.build() : null;
        }

        public final AnalysisComponent.Builder getNetworkInterface() {
            return networkInterface != null ? networkInterface.toBuilder() : null;
        }

        @Override
        public final Builder networkInterface(AnalysisComponent networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final void setNetworkInterface(AnalysisComponent.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        public final String getPacketField() {
            return packetField;
        }

        @Override
        public final Builder packetField(String packetField) {
            this.packetField = packetField;
            return this;
        }

        public final void setPacketField(String packetField) {
            this.packetField = packetField;
        }

        public final AnalysisComponent.Builder getVpcPeeringConnection() {
            return vpcPeeringConnection != null ? vpcPeeringConnection.toBuilder() : null;
        }

        @Override
        public final Builder vpcPeeringConnection(AnalysisComponent vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection;
            return this;
        }

        public final void setVpcPeeringConnection(AnalysisComponent.BuilderImpl vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection != null ? vpcPeeringConnection.build() : null;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Collection<PortRange.Builder> getPortRanges() {
            if (portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return portRanges != null ? portRanges.stream().map(PortRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(PortRange... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder>... portRanges) {
            portRanges(Stream.of(portRanges).map(c -> PortRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangeListCopier.copyFromBuilder(portRanges);
        }

        public final AnalysisComponent.Builder getPrefixList() {
            return prefixList != null ? prefixList.toBuilder() : null;
        }

        @Override
        public final Builder prefixList(AnalysisComponent prefixList) {
            this.prefixList = prefixList;
            return this;
        }

        public final void setPrefixList(AnalysisComponent.BuilderImpl prefixList) {
            this.prefixList = prefixList != null ? prefixList.build() : null;
        }

        public final Collection<String> getProtocols() {
            if (protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return protocols;
        }

        @Override
        public final Builder protocols(Collection<String> protocols) {
            this.protocols = StringListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(String... protocols) {
            protocols(Arrays.asList(protocols));
            return this;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = StringListCopier.copy(protocols);
        }

        public final AnalysisRouteTableRoute.Builder getRouteTableRoute() {
            return routeTableRoute != null ? routeTableRoute.toBuilder() : null;
        }

        @Override
        public final Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute) {
            this.routeTableRoute = routeTableRoute;
            return this;
        }

        public final void setRouteTableRoute(AnalysisRouteTableRoute.BuilderImpl routeTableRoute) {
            this.routeTableRoute = routeTableRoute != null ? routeTableRoute.build() : null;
        }

        public final AnalysisComponent.Builder getRouteTable() {
            return routeTable != null ? routeTable.toBuilder() : null;
        }

        @Override
        public final Builder routeTable(AnalysisComponent routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public final void setRouteTable(AnalysisComponent.BuilderImpl routeTable) {
            this.routeTable = routeTable != null ? routeTable.build() : null;
        }

        public final AnalysisComponent.Builder getSecurityGroup() {
            return securityGroup != null ? securityGroup.toBuilder() : null;
        }

        @Override
        public final Builder securityGroup(AnalysisComponent securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final void setSecurityGroup(AnalysisComponent.BuilderImpl securityGroup) {
            this.securityGroup = securityGroup != null ? securityGroup.build() : null;
        }

        public final AnalysisSecurityGroupRule.Builder getSecurityGroupRule() {
            return securityGroupRule != null ? securityGroupRule.toBuilder() : null;
        }

        @Override
        public final Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
            return this;
        }

        public final void setSecurityGroupRule(AnalysisSecurityGroupRule.BuilderImpl securityGroupRule) {
            this.securityGroupRule = securityGroupRule != null ? securityGroupRule.build() : null;
        }

        public final Collection<AnalysisComponent.Builder> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups != null ? securityGroups.stream().map(AnalysisComponent::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<AnalysisComponent> securityGroups) {
            this.securityGroups = AnalysisComponentListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(AnalysisComponent... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<AnalysisComponent.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> AnalysisComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<AnalysisComponent.BuilderImpl> securityGroups) {
            this.securityGroups = AnalysisComponentListCopier.copyFromBuilder(securityGroups);
        }

        public final AnalysisComponent.Builder getSourceVpc() {
            return sourceVpc != null ? sourceVpc.toBuilder() : null;
        }

        @Override
        public final Builder sourceVpc(AnalysisComponent sourceVpc) {
            this.sourceVpc = sourceVpc;
            return this;
        }

        public final void setSourceVpc(AnalysisComponent.BuilderImpl sourceVpc) {
            this.sourceVpc = sourceVpc != null ? sourceVpc.build() : null;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final AnalysisComponent.Builder getSubnet() {
            return subnet != null ? subnet.toBuilder() : null;
        }

        @Override
        public final Builder subnet(AnalysisComponent subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(AnalysisComponent.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        public final AnalysisComponent.Builder getSubnetRouteTable() {
            return subnetRouteTable != null ? subnetRouteTable.toBuilder() : null;
        }

        @Override
        public final Builder subnetRouteTable(AnalysisComponent subnetRouteTable) {
            this.subnetRouteTable = subnetRouteTable;
            return this;
        }

        public final void setSubnetRouteTable(AnalysisComponent.BuilderImpl subnetRouteTable) {
            this.subnetRouteTable = subnetRouteTable != null ? subnetRouteTable.build() : null;
        }

        public final AnalysisComponent.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(AnalysisComponent vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(AnalysisComponent.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public final AnalysisComponent.Builder getVpcEndpoint() {
            return vpcEndpoint != null ? vpcEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder vpcEndpoint(AnalysisComponent vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final void setVpcEndpoint(AnalysisComponent.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        public final AnalysisComponent.Builder getVpnConnection() {
            return vpnConnection != null ? vpnConnection.toBuilder() : null;
        }

        @Override
        public final Builder vpnConnection(AnalysisComponent vpnConnection) {
            this.vpnConnection = vpnConnection;
            return this;
        }

        public final void setVpnConnection(AnalysisComponent.BuilderImpl vpnConnection) {
            this.vpnConnection = vpnConnection != null ? vpnConnection.build() : null;
        }

        public final AnalysisComponent.Builder getVpnGateway() {
            return vpnGateway != null ? vpnGateway.toBuilder() : null;
        }

        @Override
        public final Builder vpnGateway(AnalysisComponent vpnGateway) {
            this.vpnGateway = vpnGateway;
            return this;
        }

        public final void setVpnGateway(AnalysisComponent.BuilderImpl vpnGateway) {
            this.vpnGateway = vpnGateway != null ? vpnGateway.build() : null;
        }

        @Override
        public Explanation build() {
            return new Explanation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
