/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template and overrides.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateConfig.Builder, LaunchTemplateConfig> {
    private static final SdkField<FleetLaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField
            .<FleetLaunchTemplateSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplateSpecification")
            .getter(getter(LaunchTemplateConfig::launchTemplateSpecification))
            .setter(setter(Builder::launchTemplateSpecification))
            .constructor(FleetLaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification")
                    .unmarshallLocationName("launchTemplateSpecification").build()).build();

    private static final SdkField<List<LaunchTemplateOverrides>> OVERRIDES_FIELD = SdkField
            .<List<LaunchTemplateOverrides>> builder(MarshallingType.LIST)
            .memberName("Overrides")
            .getter(getter(LaunchTemplateConfig::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides")
                    .unmarshallLocationName("overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateOverrides> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateOverrides::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_TEMPLATE_SPECIFICATION_FIELD, OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final FleetLaunchTemplateSpecification launchTemplateSpecification;

    private final List<LaunchTemplateOverrides> overrides;

    private LaunchTemplateConfig(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    /**
     * <p>
     * The launch template.
     * </p>
     * 
     * @return The launch template.
     */
    public FleetLaunchTemplateSpecification launchTemplateSpecification() {
        return launchTemplateSpecification;
    }

    /**
     * Returns true if the Overrides property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any parameters that you specify override the same parameters in the launch template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOverrides()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any parameters that you specify override the same parameters in the launch template.
     */
    public List<LaunchTemplateOverrides> overrides() {
        return overrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateConfig)) {
            return false;
        }
        LaunchTemplateConfig other = (LaunchTemplateConfig) obj;
        return Objects.equals(launchTemplateSpecification(), other.launchTemplateSpecification())
                && hasOverrides() == other.hasOverrides() && Objects.equals(overrides(), other.overrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LaunchTemplateConfig").add("LaunchTemplateSpecification", launchTemplateSpecification())
                .add("Overrides", hasOverrides() ? overrides() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateSpecification":
            return Optional.ofNullable(clazz.cast(launchTemplateSpecification()));
        case "Overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateConfig, T> g) {
        return obj -> g.apply((LaunchTemplateConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateConfig> {
        /**
         * <p>
         * The launch template.
         * </p>
         * 
         * @param launchTemplateSpecification
         *        The launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification);

        /**
         * <p>
         * The launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link FleetLaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link FleetLaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link FleetLaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #launchTemplateSpecification(FleetLaunchTemplateSpecification)}.
         * 
         * @param launchTemplateSpecification
         *        a consumer that will call methods on {@link FleetLaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateSpecification(FleetLaunchTemplateSpecification)
         */
        default Builder launchTemplateSpecification(Consumer<FleetLaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return launchTemplateSpecification(FleetLaunchTemplateSpecification.builder()
                    .applyMutation(launchTemplateSpecification).build());
        }

        /**
         * <p>
         * Any parameters that you specify override the same parameters in the launch template.
         * </p>
         * 
         * @param overrides
         *        Any parameters that you specify override the same parameters in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Collection<LaunchTemplateOverrides> overrides);

        /**
         * <p>
         * Any parameters that you specify override the same parameters in the launch template.
         * </p>
         * 
         * @param overrides
         *        Any parameters that you specify override the same parameters in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(LaunchTemplateOverrides... overrides);

        /**
         * <p>
         * Any parameters that you specify override the same parameters in the launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchTemplateOverrides>.Builder} avoiding
         * the need to create one manually via {@link List<LaunchTemplateOverrides>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateOverrides>.Builder#build()} is called
         * immediately and its result is passed to {@link #overrides(List<LaunchTemplateOverrides>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link List<LaunchTemplateOverrides>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(List<LaunchTemplateOverrides>)
         */
        Builder overrides(Consumer<LaunchTemplateOverrides.Builder>... overrides);
    }

    static final class BuilderImpl implements Builder {
        private FleetLaunchTemplateSpecification launchTemplateSpecification;

        private List<LaunchTemplateOverrides> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateConfig model) {
            launchTemplateSpecification(model.launchTemplateSpecification);
            overrides(model.overrides);
        }

        public final FleetLaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return launchTemplateSpecification != null ? launchTemplateSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final void setLaunchTemplateSpecification(FleetLaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        public final Collection<LaunchTemplateOverrides.Builder> getOverrides() {
            if (overrides instanceof SdkAutoConstructList) {
                return null;
            }
            return overrides != null ? overrides.stream().map(LaunchTemplateOverrides::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder overrides(Collection<LaunchTemplateOverrides> overrides) {
            this.overrides = LaunchTemplateOverridesListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(LaunchTemplateOverrides... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<LaunchTemplateOverrides.Builder>... overrides) {
            overrides(Stream.of(overrides).map(c -> LaunchTemplateOverrides.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOverrides(Collection<LaunchTemplateOverrides.BuilderImpl> overrides) {
            this.overrides = LaunchTemplateOverridesListCopier.copyFromBuilder(overrides);
        }

        @Override
        public LaunchTemplateConfig build() {
            return new LaunchTemplateConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
