/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a path component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathComponent implements SdkPojo, Serializable, ToCopyableBuilder<PathComponent.Builder, PathComponent> {
    private static final SdkField<Integer> SEQUENCE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SequenceNumber")
            .getter(getter(PathComponent::sequenceNumber))
            .setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber")
                    .unmarshallLocationName("sequenceNumber").build()).build();

    private static final SdkField<AnalysisAclRule> ACL_RULE_FIELD = SdkField
            .<AnalysisAclRule> builder(MarshallingType.SDK_POJO)
            .memberName("AclRule")
            .getter(getter(PathComponent::aclRule))
            .setter(setter(Builder::aclRule))
            .constructor(AnalysisAclRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclRule")
                    .unmarshallLocationName("aclRule").build()).build();

    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Component")
            .getter(getter(PathComponent::component))
            .setter(setter(Builder::component))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component")
                    .unmarshallLocationName("component").build()).build();

    private static final SdkField<AnalysisComponent> DESTINATION_VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationVpc")
            .getter(getter(PathComponent::destinationVpc))
            .setter(setter(Builder::destinationVpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationVpc")
                    .unmarshallLocationName("destinationVpc").build()).build();

    private static final SdkField<AnalysisPacketHeader> OUTBOUND_HEADER_FIELD = SdkField
            .<AnalysisPacketHeader> builder(MarshallingType.SDK_POJO)
            .memberName("OutboundHeader")
            .getter(getter(PathComponent::outboundHeader))
            .setter(setter(Builder::outboundHeader))
            .constructor(AnalysisPacketHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundHeader")
                    .unmarshallLocationName("outboundHeader").build()).build();

    private static final SdkField<AnalysisPacketHeader> INBOUND_HEADER_FIELD = SdkField
            .<AnalysisPacketHeader> builder(MarshallingType.SDK_POJO)
            .memberName("InboundHeader")
            .getter(getter(PathComponent::inboundHeader))
            .setter(setter(Builder::inboundHeader))
            .constructor(AnalysisPacketHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundHeader")
                    .unmarshallLocationName("inboundHeader").build()).build();

    private static final SdkField<AnalysisRouteTableRoute> ROUTE_TABLE_ROUTE_FIELD = SdkField
            .<AnalysisRouteTableRoute> builder(MarshallingType.SDK_POJO)
            .memberName("RouteTableRoute")
            .getter(getter(PathComponent::routeTableRoute))
            .setter(setter(Builder::routeTableRoute))
            .constructor(AnalysisRouteTableRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableRoute")
                    .unmarshallLocationName("routeTableRoute").build()).build();

    private static final SdkField<AnalysisSecurityGroupRule> SECURITY_GROUP_RULE_FIELD = SdkField
            .<AnalysisSecurityGroupRule> builder(MarshallingType.SDK_POJO)
            .memberName("SecurityGroupRule")
            .getter(getter(PathComponent::securityGroupRule))
            .setter(setter(Builder::securityGroupRule))
            .constructor(AnalysisSecurityGroupRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule")
                    .unmarshallLocationName("securityGroupRule").build()).build();

    private static final SdkField<AnalysisComponent> SOURCE_VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("SourceVpc")
            .getter(getter(PathComponent::sourceVpc))
            .setter(setter(Builder::sourceVpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVpc")
                    .unmarshallLocationName("sourceVpc").build()).build();

    private static final SdkField<AnalysisComponent> SUBNET_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Subnet")
            .getter(getter(PathComponent::subnet))
            .setter(setter(Builder::subnet))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet")
                    .unmarshallLocationName("subnet").build()).build();

    private static final SdkField<AnalysisComponent> VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Vpc")
            .getter(getter(PathComponent::vpc))
            .setter(setter(Builder::vpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").unmarshallLocationName("vpc")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_NUMBER_FIELD,
            ACL_RULE_FIELD, COMPONENT_FIELD, DESTINATION_VPC_FIELD, OUTBOUND_HEADER_FIELD, INBOUND_HEADER_FIELD,
            ROUTE_TABLE_ROUTE_FIELD, SECURITY_GROUP_RULE_FIELD, SOURCE_VPC_FIELD, SUBNET_FIELD, VPC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer sequenceNumber;

    private final AnalysisAclRule aclRule;

    private final AnalysisComponent component;

    private final AnalysisComponent destinationVpc;

    private final AnalysisPacketHeader outboundHeader;

    private final AnalysisPacketHeader inboundHeader;

    private final AnalysisRouteTableRoute routeTableRoute;

    private final AnalysisSecurityGroupRule securityGroupRule;

    private final AnalysisComponent sourceVpc;

    private final AnalysisComponent subnet;

    private final AnalysisComponent vpc;

    private PathComponent(BuilderImpl builder) {
        this.sequenceNumber = builder.sequenceNumber;
        this.aclRule = builder.aclRule;
        this.component = builder.component;
        this.destinationVpc = builder.destinationVpc;
        this.outboundHeader = builder.outboundHeader;
        this.inboundHeader = builder.inboundHeader;
        this.routeTableRoute = builder.routeTableRoute;
        this.securityGroupRule = builder.securityGroupRule;
        this.sourceVpc = builder.sourceVpc;
        this.subnet = builder.subnet;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The sequence number.
     * </p>
     * 
     * @return The sequence number.
     */
    public Integer sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The network ACL rule.
     * </p>
     * 
     * @return The network ACL rule.
     */
    public AnalysisAclRule aclRule() {
        return aclRule;
    }

    /**
     * <p>
     * The component.
     * </p>
     * 
     * @return The component.
     */
    public AnalysisComponent component() {
        return component;
    }

    /**
     * <p>
     * The destination VPC.
     * </p>
     * 
     * @return The destination VPC.
     */
    public AnalysisComponent destinationVpc() {
        return destinationVpc;
    }

    /**
     * <p>
     * The outbound header.
     * </p>
     * 
     * @return The outbound header.
     */
    public AnalysisPacketHeader outboundHeader() {
        return outboundHeader;
    }

    /**
     * <p>
     * The inbound header.
     * </p>
     * 
     * @return The inbound header.
     */
    public AnalysisPacketHeader inboundHeader() {
        return inboundHeader;
    }

    /**
     * <p>
     * The route table route.
     * </p>
     * 
     * @return The route table route.
     */
    public AnalysisRouteTableRoute routeTableRoute() {
        return routeTableRoute;
    }

    /**
     * <p>
     * The security group rule.
     * </p>
     * 
     * @return The security group rule.
     */
    public AnalysisSecurityGroupRule securityGroupRule() {
        return securityGroupRule;
    }

    /**
     * <p>
     * The source VPC.
     * </p>
     * 
     * @return The source VPC.
     */
    public AnalysisComponent sourceVpc() {
        return sourceVpc;
    }

    /**
     * <p>
     * The subnet.
     * </p>
     * 
     * @return The subnet.
     */
    public AnalysisComponent subnet() {
        return subnet;
    }

    /**
     * <p>
     * The component VPC.
     * </p>
     * 
     * @return The component VPC.
     */
    public AnalysisComponent vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(aclRule());
        hashCode = 31 * hashCode + Objects.hashCode(component());
        hashCode = 31 * hashCode + Objects.hashCode(destinationVpc());
        hashCode = 31 * hashCode + Objects.hashCode(outboundHeader());
        hashCode = 31 * hashCode + Objects.hashCode(inboundHeader());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableRoute());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupRule());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVpc());
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathComponent)) {
            return false;
        }
        PathComponent other = (PathComponent) obj;
        return Objects.equals(sequenceNumber(), other.sequenceNumber()) && Objects.equals(aclRule(), other.aclRule())
                && Objects.equals(component(), other.component()) && Objects.equals(destinationVpc(), other.destinationVpc())
                && Objects.equals(outboundHeader(), other.outboundHeader())
                && Objects.equals(inboundHeader(), other.inboundHeader())
                && Objects.equals(routeTableRoute(), other.routeTableRoute())
                && Objects.equals(securityGroupRule(), other.securityGroupRule())
                && Objects.equals(sourceVpc(), other.sourceVpc()) && Objects.equals(subnet(), other.subnet())
                && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PathComponent").add("SequenceNumber", sequenceNumber()).add("AclRule", aclRule())
                .add("Component", component()).add("DestinationVpc", destinationVpc()).add("OutboundHeader", outboundHeader())
                .add("InboundHeader", inboundHeader()).add("RouteTableRoute", routeTableRoute())
                .add("SecurityGroupRule", securityGroupRule()).add("SourceVpc", sourceVpc()).add("Subnet", subnet())
                .add("Vpc", vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        case "AclRule":
            return Optional.ofNullable(clazz.cast(aclRule()));
        case "Component":
            return Optional.ofNullable(clazz.cast(component()));
        case "DestinationVpc":
            return Optional.ofNullable(clazz.cast(destinationVpc()));
        case "OutboundHeader":
            return Optional.ofNullable(clazz.cast(outboundHeader()));
        case "InboundHeader":
            return Optional.ofNullable(clazz.cast(inboundHeader()));
        case "RouteTableRoute":
            return Optional.ofNullable(clazz.cast(routeTableRoute()));
        case "SecurityGroupRule":
            return Optional.ofNullable(clazz.cast(securityGroupRule()));
        case "SourceVpc":
            return Optional.ofNullable(clazz.cast(sourceVpc()));
        case "Subnet":
            return Optional.ofNullable(clazz.cast(subnet()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathComponent, T> g) {
        return obj -> g.apply((PathComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathComponent> {
        /**
         * <p>
         * The sequence number.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(Integer sequenceNumber);

        /**
         * <p>
         * The network ACL rule.
         * </p>
         * 
         * @param aclRule
         *        The network ACL rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aclRule(AnalysisAclRule aclRule);

        /**
         * <p>
         * The network ACL rule.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisAclRule.Builder} avoiding the need to
         * create one manually via {@link AnalysisAclRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisAclRule.Builder#build()} is called immediately and its
         * result is passed to {@link #aclRule(AnalysisAclRule)}.
         * 
         * @param aclRule
         *        a consumer that will call methods on {@link AnalysisAclRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aclRule(AnalysisAclRule)
         */
        default Builder aclRule(Consumer<AnalysisAclRule.Builder> aclRule) {
            return aclRule(AnalysisAclRule.builder().applyMutation(aclRule).build());
        }

        /**
         * <p>
         * The component.
         * </p>
         * 
         * @param component
         *        The component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder component(AnalysisComponent component);

        /**
         * <p>
         * The component.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #component(AnalysisComponent)}.
         * 
         * @param component
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #component(AnalysisComponent)
         */
        default Builder component(Consumer<AnalysisComponent.Builder> component) {
            return component(AnalysisComponent.builder().applyMutation(component).build());
        }

        /**
         * <p>
         * The destination VPC.
         * </p>
         * 
         * @param destinationVpc
         *        The destination VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationVpc(AnalysisComponent destinationVpc);

        /**
         * <p>
         * The destination VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationVpc(AnalysisComponent)}.
         * 
         * @param destinationVpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationVpc(AnalysisComponent)
         */
        default Builder destinationVpc(Consumer<AnalysisComponent.Builder> destinationVpc) {
            return destinationVpc(AnalysisComponent.builder().applyMutation(destinationVpc).build());
        }

        /**
         * <p>
         * The outbound header.
         * </p>
         * 
         * @param outboundHeader
         *        The outbound header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundHeader(AnalysisPacketHeader outboundHeader);

        /**
         * <p>
         * The outbound header.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisPacketHeader.Builder} avoiding the need
         * to create one manually via {@link AnalysisPacketHeader#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisPacketHeader.Builder#build()} is called immediately and
         * its result is passed to {@link #outboundHeader(AnalysisPacketHeader)}.
         * 
         * @param outboundHeader
         *        a consumer that will call methods on {@link AnalysisPacketHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundHeader(AnalysisPacketHeader)
         */
        default Builder outboundHeader(Consumer<AnalysisPacketHeader.Builder> outboundHeader) {
            return outboundHeader(AnalysisPacketHeader.builder().applyMutation(outboundHeader).build());
        }

        /**
         * <p>
         * The inbound header.
         * </p>
         * 
         * @param inboundHeader
         *        The inbound header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundHeader(AnalysisPacketHeader inboundHeader);

        /**
         * <p>
         * The inbound header.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisPacketHeader.Builder} avoiding the need
         * to create one manually via {@link AnalysisPacketHeader#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisPacketHeader.Builder#build()} is called immediately and
         * its result is passed to {@link #inboundHeader(AnalysisPacketHeader)}.
         * 
         * @param inboundHeader
         *        a consumer that will call methods on {@link AnalysisPacketHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundHeader(AnalysisPacketHeader)
         */
        default Builder inboundHeader(Consumer<AnalysisPacketHeader.Builder> inboundHeader) {
            return inboundHeader(AnalysisPacketHeader.builder().applyMutation(inboundHeader).build());
        }

        /**
         * <p>
         * The route table route.
         * </p>
         * 
         * @param routeTableRoute
         *        The route table route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute);

        /**
         * <p>
         * The route table route.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisRouteTableRoute.Builder} avoiding the
         * need to create one manually via {@link AnalysisRouteTableRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisRouteTableRoute.Builder#build()} is called immediately
         * and its result is passed to {@link #routeTableRoute(AnalysisRouteTableRoute)}.
         * 
         * @param routeTableRoute
         *        a consumer that will call methods on {@link AnalysisRouteTableRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTableRoute(AnalysisRouteTableRoute)
         */
        default Builder routeTableRoute(Consumer<AnalysisRouteTableRoute.Builder> routeTableRoute) {
            return routeTableRoute(AnalysisRouteTableRoute.builder().applyMutation(routeTableRoute).build());
        }

        /**
         * <p>
         * The security group rule.
         * </p>
         * 
         * @param securityGroupRule
         *        The security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule);

        /**
         * <p>
         * The security group rule.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisSecurityGroupRule.Builder} avoiding the
         * need to create one manually via {@link AnalysisSecurityGroupRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisSecurityGroupRule.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroupRule(AnalysisSecurityGroupRule)}.
         * 
         * @param securityGroupRule
         *        a consumer that will call methods on {@link AnalysisSecurityGroupRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupRule(AnalysisSecurityGroupRule)
         */
        default Builder securityGroupRule(Consumer<AnalysisSecurityGroupRule.Builder> securityGroupRule) {
            return securityGroupRule(AnalysisSecurityGroupRule.builder().applyMutation(securityGroupRule).build());
        }

        /**
         * <p>
         * The source VPC.
         * </p>
         * 
         * @param sourceVpc
         *        The source VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVpc(AnalysisComponent sourceVpc);

        /**
         * <p>
         * The source VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceVpc(AnalysisComponent)}.
         * 
         * @param sourceVpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceVpc(AnalysisComponent)
         */
        default Builder sourceVpc(Consumer<AnalysisComponent.Builder> sourceVpc) {
            return sourceVpc(AnalysisComponent.builder().applyMutation(sourceVpc).build());
        }

        /**
         * <p>
         * The subnet.
         * </p>
         * 
         * @param subnet
         *        The subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(AnalysisComponent subnet);

        /**
         * <p>
         * The subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #subnet(AnalysisComponent)}.
         * 
         * @param subnet
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnet(AnalysisComponent)
         */
        default Builder subnet(Consumer<AnalysisComponent.Builder> subnet) {
            return subnet(AnalysisComponent.builder().applyMutation(subnet).build());
        }

        /**
         * <p>
         * The component VPC.
         * </p>
         * 
         * @param vpc
         *        The component VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(AnalysisComponent vpc);

        /**
         * <p>
         * The component VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #vpc(AnalysisComponent)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(AnalysisComponent)
         */
        default Builder vpc(Consumer<AnalysisComponent.Builder> vpc) {
            return vpc(AnalysisComponent.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer sequenceNumber;

        private AnalysisAclRule aclRule;

        private AnalysisComponent component;

        private AnalysisComponent destinationVpc;

        private AnalysisPacketHeader outboundHeader;

        private AnalysisPacketHeader inboundHeader;

        private AnalysisRouteTableRoute routeTableRoute;

        private AnalysisSecurityGroupRule securityGroupRule;

        private AnalysisComponent sourceVpc;

        private AnalysisComponent subnet;

        private AnalysisComponent vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(PathComponent model) {
            sequenceNumber(model.sequenceNumber);
            aclRule(model.aclRule);
            component(model.component);
            destinationVpc(model.destinationVpc);
            outboundHeader(model.outboundHeader);
            inboundHeader(model.inboundHeader);
            routeTableRoute(model.routeTableRoute);
            securityGroupRule(model.securityGroupRule);
            sourceVpc(model.sourceVpc);
            subnet(model.subnet);
            vpc(model.vpc);
        }

        public final Integer getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final AnalysisAclRule.Builder getAclRule() {
            return aclRule != null ? aclRule.toBuilder() : null;
        }

        @Override
        public final Builder aclRule(AnalysisAclRule aclRule) {
            this.aclRule = aclRule;
            return this;
        }

        public final void setAclRule(AnalysisAclRule.BuilderImpl aclRule) {
            this.aclRule = aclRule != null ? aclRule.build() : null;
        }

        public final AnalysisComponent.Builder getComponent() {
            return component != null ? component.toBuilder() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        public final AnalysisComponent.Builder getDestinationVpc() {
            return destinationVpc != null ? destinationVpc.toBuilder() : null;
        }

        @Override
        public final Builder destinationVpc(AnalysisComponent destinationVpc) {
            this.destinationVpc = destinationVpc;
            return this;
        }

        public final void setDestinationVpc(AnalysisComponent.BuilderImpl destinationVpc) {
            this.destinationVpc = destinationVpc != null ? destinationVpc.build() : null;
        }

        public final AnalysisPacketHeader.Builder getOutboundHeader() {
            return outboundHeader != null ? outboundHeader.toBuilder() : null;
        }

        @Override
        public final Builder outboundHeader(AnalysisPacketHeader outboundHeader) {
            this.outboundHeader = outboundHeader;
            return this;
        }

        public final void setOutboundHeader(AnalysisPacketHeader.BuilderImpl outboundHeader) {
            this.outboundHeader = outboundHeader != null ? outboundHeader.build() : null;
        }

        public final AnalysisPacketHeader.Builder getInboundHeader() {
            return inboundHeader != null ? inboundHeader.toBuilder() : null;
        }

        @Override
        public final Builder inboundHeader(AnalysisPacketHeader inboundHeader) {
            this.inboundHeader = inboundHeader;
            return this;
        }

        public final void setInboundHeader(AnalysisPacketHeader.BuilderImpl inboundHeader) {
            this.inboundHeader = inboundHeader != null ? inboundHeader.build() : null;
        }

        public final AnalysisRouteTableRoute.Builder getRouteTableRoute() {
            return routeTableRoute != null ? routeTableRoute.toBuilder() : null;
        }

        @Override
        public final Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute) {
            this.routeTableRoute = routeTableRoute;
            return this;
        }

        public final void setRouteTableRoute(AnalysisRouteTableRoute.BuilderImpl routeTableRoute) {
            this.routeTableRoute = routeTableRoute != null ? routeTableRoute.build() : null;
        }

        public final AnalysisSecurityGroupRule.Builder getSecurityGroupRule() {
            return securityGroupRule != null ? securityGroupRule.toBuilder() : null;
        }

        @Override
        public final Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
            return this;
        }

        public final void setSecurityGroupRule(AnalysisSecurityGroupRule.BuilderImpl securityGroupRule) {
            this.securityGroupRule = securityGroupRule != null ? securityGroupRule.build() : null;
        }

        public final AnalysisComponent.Builder getSourceVpc() {
            return sourceVpc != null ? sourceVpc.toBuilder() : null;
        }

        @Override
        public final Builder sourceVpc(AnalysisComponent sourceVpc) {
            this.sourceVpc = sourceVpc;
            return this;
        }

        public final void setSourceVpc(AnalysisComponent.BuilderImpl sourceVpc) {
            this.sourceVpc = sourceVpc != null ? sourceVpc.build() : null;
        }

        public final AnalysisComponent.Builder getSubnet() {
            return subnet != null ? subnet.toBuilder() : null;
        }

        @Override
        public final Builder subnet(AnalysisComponent subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(AnalysisComponent.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        public final AnalysisComponent.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(AnalysisComponent vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(AnalysisComponent.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public PathComponent build() {
            return new PathComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
