/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tunnel options for a single VPN tunnel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpnTunnelOptionsSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<VpnTunnelOptionsSpecification.Builder, VpnTunnelOptionsSpecification> {
    private static final SdkField<String> TUNNEL_INSIDE_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TunnelInsideCidr")
            .getter(getter(VpnTunnelOptionsSpecification::tunnelInsideCidr))
            .setter(setter(Builder::tunnelInsideCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideCidr")
                    .unmarshallLocationName("TunnelInsideCidr").build()).build();

    private static final SdkField<String> TUNNEL_INSIDE_IPV6_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TunnelInsideIpv6Cidr")
            .getter(getter(VpnTunnelOptionsSpecification::tunnelInsideIpv6Cidr))
            .setter(setter(Builder::tunnelInsideIpv6Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideIpv6Cidr")
                    .unmarshallLocationName("TunnelInsideIpv6Cidr").build()).build();

    private static final SdkField<String> PRE_SHARED_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreSharedKey")
            .getter(getter(VpnTunnelOptionsSpecification::preSharedKey))
            .setter(setter(Builder::preSharedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSharedKey")
                    .unmarshallLocationName("PreSharedKey").build()).build();

    private static final SdkField<Integer> PHASE1_LIFETIME_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Phase1LifetimeSeconds")
            .getter(getter(VpnTunnelOptionsSpecification::phase1LifetimeSeconds))
            .setter(setter(Builder::phase1LifetimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1LifetimeSeconds")
                    .unmarshallLocationName("Phase1LifetimeSeconds").build()).build();

    private static final SdkField<Integer> PHASE2_LIFETIME_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Phase2LifetimeSeconds")
            .getter(getter(VpnTunnelOptionsSpecification::phase2LifetimeSeconds))
            .setter(setter(Builder::phase2LifetimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2LifetimeSeconds")
                    .unmarshallLocationName("Phase2LifetimeSeconds").build()).build();

    private static final SdkField<Integer> REKEY_MARGIN_TIME_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RekeyMarginTimeSeconds")
            .getter(getter(VpnTunnelOptionsSpecification::rekeyMarginTimeSeconds))
            .setter(setter(Builder::rekeyMarginTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyMarginTimeSeconds")
                    .unmarshallLocationName("RekeyMarginTimeSeconds").build()).build();

    private static final SdkField<Integer> REKEY_FUZZ_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RekeyFuzzPercentage")
            .getter(getter(VpnTunnelOptionsSpecification::rekeyFuzzPercentage))
            .setter(setter(Builder::rekeyFuzzPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyFuzzPercentage")
                    .unmarshallLocationName("RekeyFuzzPercentage").build()).build();

    private static final SdkField<Integer> REPLAY_WINDOW_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplayWindowSize")
            .getter(getter(VpnTunnelOptionsSpecification::replayWindowSize))
            .setter(setter(Builder::replayWindowSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayWindowSize")
                    .unmarshallLocationName("ReplayWindowSize").build()).build();

    private static final SdkField<Integer> DPD_TIMEOUT_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DPDTimeoutSeconds")
            .getter(getter(VpnTunnelOptionsSpecification::dpdTimeoutSeconds))
            .setter(setter(Builder::dpdTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPDTimeoutSeconds")
                    .unmarshallLocationName("DPDTimeoutSeconds").build()).build();

    private static final SdkField<String> DPD_TIMEOUT_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DPDTimeoutAction")
            .getter(getter(VpnTunnelOptionsSpecification::dpdTimeoutAction))
            .setter(setter(Builder::dpdTimeoutAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPDTimeoutAction")
                    .unmarshallLocationName("DPDTimeoutAction").build()).build();

    private static final SdkField<List<Phase1EncryptionAlgorithmsRequestListValue>> PHASE1_ENCRYPTION_ALGORITHMS_FIELD = SdkField
            .<List<Phase1EncryptionAlgorithmsRequestListValue>> builder(MarshallingType.LIST)
            .memberName("Phase1EncryptionAlgorithms")
            .getter(getter(VpnTunnelOptionsSpecification::phase1EncryptionAlgorithms))
            .setter(setter(Builder::phase1EncryptionAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1EncryptionAlgorithm")
                    .unmarshallLocationName("Phase1EncryptionAlgorithm").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase1EncryptionAlgorithmsRequestListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase1EncryptionAlgorithmsRequestListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase2EncryptionAlgorithmsRequestListValue>> PHASE2_ENCRYPTION_ALGORITHMS_FIELD = SdkField
            .<List<Phase2EncryptionAlgorithmsRequestListValue>> builder(MarshallingType.LIST)
            .memberName("Phase2EncryptionAlgorithms")
            .getter(getter(VpnTunnelOptionsSpecification::phase2EncryptionAlgorithms))
            .setter(setter(Builder::phase2EncryptionAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2EncryptionAlgorithm")
                    .unmarshallLocationName("Phase2EncryptionAlgorithm").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase2EncryptionAlgorithmsRequestListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase2EncryptionAlgorithmsRequestListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase1IntegrityAlgorithmsRequestListValue>> PHASE1_INTEGRITY_ALGORITHMS_FIELD = SdkField
            .<List<Phase1IntegrityAlgorithmsRequestListValue>> builder(MarshallingType.LIST)
            .memberName("Phase1IntegrityAlgorithms")
            .getter(getter(VpnTunnelOptionsSpecification::phase1IntegrityAlgorithms))
            .setter(setter(Builder::phase1IntegrityAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1IntegrityAlgorithm")
                    .unmarshallLocationName("Phase1IntegrityAlgorithm").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase1IntegrityAlgorithmsRequestListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase1IntegrityAlgorithmsRequestListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase2IntegrityAlgorithmsRequestListValue>> PHASE2_INTEGRITY_ALGORITHMS_FIELD = SdkField
            .<List<Phase2IntegrityAlgorithmsRequestListValue>> builder(MarshallingType.LIST)
            .memberName("Phase2IntegrityAlgorithms")
            .getter(getter(VpnTunnelOptionsSpecification::phase2IntegrityAlgorithms))
            .setter(setter(Builder::phase2IntegrityAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2IntegrityAlgorithm")
                    .unmarshallLocationName("Phase2IntegrityAlgorithm").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase2IntegrityAlgorithmsRequestListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase2IntegrityAlgorithmsRequestListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase1DHGroupNumbersRequestListValue>> PHASE1_DH_GROUP_NUMBERS_FIELD = SdkField
            .<List<Phase1DHGroupNumbersRequestListValue>> builder(MarshallingType.LIST)
            .memberName("Phase1DHGroupNumbers")
            .getter(getter(VpnTunnelOptionsSpecification::phase1DHGroupNumbers))
            .setter(setter(Builder::phase1DHGroupNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1DHGroupNumber")
                    .unmarshallLocationName("Phase1DHGroupNumber").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase1DHGroupNumbersRequestListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase1DHGroupNumbersRequestListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase2DHGroupNumbersRequestListValue>> PHASE2_DH_GROUP_NUMBERS_FIELD = SdkField
            .<List<Phase2DHGroupNumbersRequestListValue>> builder(MarshallingType.LIST)
            .memberName("Phase2DHGroupNumbers")
            .getter(getter(VpnTunnelOptionsSpecification::phase2DHGroupNumbers))
            .setter(setter(Builder::phase2DHGroupNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2DHGroupNumber")
                    .unmarshallLocationName("Phase2DHGroupNumber").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase2DHGroupNumbersRequestListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase2DHGroupNumbersRequestListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<IKEVersionsRequestListValue>> IKE_VERSIONS_FIELD = SdkField
            .<List<IKEVersionsRequestListValue>> builder(MarshallingType.LIST)
            .memberName("IKEVersions")
            .getter(getter(VpnTunnelOptionsSpecification::ikeVersions))
            .setter(setter(Builder::ikeVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IKEVersion")
                    .unmarshallLocationName("IKEVersion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IKEVersionsRequestListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(IKEVersionsRequestListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STARTUP_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartupAction")
            .getter(getter(VpnTunnelOptionsSpecification::startupAction))
            .setter(setter(Builder::startupAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupAction")
                    .unmarshallLocationName("StartupAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_INSIDE_CIDR_FIELD,
            TUNNEL_INSIDE_IPV6_CIDR_FIELD, PRE_SHARED_KEY_FIELD, PHASE1_LIFETIME_SECONDS_FIELD, PHASE2_LIFETIME_SECONDS_FIELD,
            REKEY_MARGIN_TIME_SECONDS_FIELD, REKEY_FUZZ_PERCENTAGE_FIELD, REPLAY_WINDOW_SIZE_FIELD, DPD_TIMEOUT_SECONDS_FIELD,
            DPD_TIMEOUT_ACTION_FIELD, PHASE1_ENCRYPTION_ALGORITHMS_FIELD, PHASE2_ENCRYPTION_ALGORITHMS_FIELD,
            PHASE1_INTEGRITY_ALGORITHMS_FIELD, PHASE2_INTEGRITY_ALGORITHMS_FIELD, PHASE1_DH_GROUP_NUMBERS_FIELD,
            PHASE2_DH_GROUP_NUMBERS_FIELD, IKE_VERSIONS_FIELD, STARTUP_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tunnelInsideCidr;

    private final String tunnelInsideIpv6Cidr;

    private final String preSharedKey;

    private final Integer phase1LifetimeSeconds;

    private final Integer phase2LifetimeSeconds;

    private final Integer rekeyMarginTimeSeconds;

    private final Integer rekeyFuzzPercentage;

    private final Integer replayWindowSize;

    private final Integer dpdTimeoutSeconds;

    private final String dpdTimeoutAction;

    private final List<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms;

    private final List<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms;

    private final List<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms;

    private final List<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms;

    private final List<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers;

    private final List<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers;

    private final List<IKEVersionsRequestListValue> ikeVersions;

    private final String startupAction;

    private VpnTunnelOptionsSpecification(BuilderImpl builder) {
        this.tunnelInsideCidr = builder.tunnelInsideCidr;
        this.tunnelInsideIpv6Cidr = builder.tunnelInsideIpv6Cidr;
        this.preSharedKey = builder.preSharedKey;
        this.phase1LifetimeSeconds = builder.phase1LifetimeSeconds;
        this.phase2LifetimeSeconds = builder.phase2LifetimeSeconds;
        this.rekeyMarginTimeSeconds = builder.rekeyMarginTimeSeconds;
        this.rekeyFuzzPercentage = builder.rekeyFuzzPercentage;
        this.replayWindowSize = builder.replayWindowSize;
        this.dpdTimeoutSeconds = builder.dpdTimeoutSeconds;
        this.dpdTimeoutAction = builder.dpdTimeoutAction;
        this.phase1EncryptionAlgorithms = builder.phase1EncryptionAlgorithms;
        this.phase2EncryptionAlgorithms = builder.phase2EncryptionAlgorithms;
        this.phase1IntegrityAlgorithms = builder.phase1IntegrityAlgorithms;
        this.phase2IntegrityAlgorithms = builder.phase2IntegrityAlgorithms;
        this.phase1DHGroupNumbers = builder.phase1DHGroupNumbers;
        this.phase2DHGroupNumbers = builder.phase2DHGroupNumbers;
        this.ikeVersions = builder.ikeVersions;
        this.startupAction = builder.startupAction;
    }

    /**
     * <p>
     * The range of inside IPv4 addresses for the tunnel. Any specified CIDR blocks must be unique across all VPN
     * connections that use the same virtual private gateway.
     * </p>
     * <p>
     * Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks are
     * reserved and cannot be used:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>169.254.0.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.1.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.2.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.3.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.4.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.5.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.169.252/30</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The range of inside IPv4 addresses for the tunnel. Any specified CIDR blocks must be unique across all
     *         VPN connections that use the same virtual private gateway. </p>
     *         <p>
     *         Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks
     *         are reserved and cannot be used:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>169.254.0.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.1.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.2.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.3.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.4.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.5.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.169.252/30</code>
     *         </p>
     *         </li>
     */
    public String tunnelInsideCidr() {
        return tunnelInsideCidr;
    }

    /**
     * <p>
     * The range of inside IPv6 addresses for the tunnel. Any specified CIDR blocks must be unique across all VPN
     * connections that use the same transit gateway.
     * </p>
     * <p>
     * Constraints: A size /126 CIDR block from the local <code>fd00::/8</code> range.
     * </p>
     * 
     * @return The range of inside IPv6 addresses for the tunnel. Any specified CIDR blocks must be unique across all
     *         VPN connections that use the same transit gateway.</p>
     *         <p>
     *         Constraints: A size /126 CIDR block from the local <code>fd00::/8</code> range.
     */
    public String tunnelInsideIpv6Cidr() {
        return tunnelInsideIpv6Cidr;
    }

    /**
     * <p>
     * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer
     * gateway.
     * </p>
     * <p>
     * Constraints: Allowed characters are alphanumeric characters, periods (.), and underscores (_). Must be between 8
     * and 64 characters in length and cannot start with zero (0).
     * </p>
     * 
     * @return The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and
     *         customer gateway.</p>
     *         <p>
     *         Constraints: Allowed characters are alphanumeric characters, periods (.), and underscores (_). Must be
     *         between 8 and 64 characters in length and cannot start with zero (0).
     */
    public String preSharedKey() {
        return preSharedKey;
    }

    /**
     * <p>
     * The lifetime for phase 1 of the IKE negotiation, in seconds.
     * </p>
     * <p>
     * Constraints: A value between 900 and 28,800.
     * </p>
     * <p>
     * Default: <code>28800</code>
     * </p>
     * 
     * @return The lifetime for phase 1 of the IKE negotiation, in seconds.</p>
     *         <p>
     *         Constraints: A value between 900 and 28,800.
     *         </p>
     *         <p>
     *         Default: <code>28800</code>
     */
    public Integer phase1LifetimeSeconds() {
        return phase1LifetimeSeconds;
    }

    /**
     * <p>
     * The lifetime for phase 2 of the IKE negotiation, in seconds.
     * </p>
     * <p>
     * Constraints: A value between 900 and 3,600. The value must be less than the value for
     * <code>Phase1LifetimeSeconds</code>.
     * </p>
     * <p>
     * Default: <code>3600</code>
     * </p>
     * 
     * @return The lifetime for phase 2 of the IKE negotiation, in seconds.</p>
     *         <p>
     *         Constraints: A value between 900 and 3,600. The value must be less than the value for
     *         <code>Phase1LifetimeSeconds</code>.
     *         </p>
     *         <p>
     *         Default: <code>3600</code>
     */
    public Integer phase2LifetimeSeconds() {
        return phase2LifetimeSeconds;
    }

    /**
     * <p>
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN connection
     * performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for
     * <code>RekeyFuzzPercentage</code>.
     * </p>
     * <p>
     * Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code>.
     * </p>
     * <p>
     * Default: <code>540</code>
     * </p>
     * 
     * @return The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN
     *         connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for
     *         <code>RekeyFuzzPercentage</code>.</p>
     *         <p>
     *         Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code>.
     *         </p>
     *         <p>
     *         Default: <code>540</code>
     */
    public Integer rekeyMarginTimeSeconds() {
        return rekeyMarginTimeSeconds;
    }

    /**
     * <p>
     * The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code>) during which the rekey
     * time is randomly selected.
     * </p>
     * <p>
     * Constraints: A value between 0 and 100.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * 
     * @return The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code>) during which the
     *         rekey time is randomly selected.</p>
     *         <p>
     *         Constraints: A value between 0 and 100.
     *         </p>
     *         <p>
     *         Default: <code>100</code>
     */
    public Integer rekeyFuzzPercentage() {
        return rekeyFuzzPercentage;
    }

    /**
     * <p>
     * The number of packets in an IKE replay window.
     * </p>
     * <p>
     * Constraints: A value between 64 and 2048.
     * </p>
     * <p>
     * Default: <code>1024</code>
     * </p>
     * 
     * @return The number of packets in an IKE replay window.</p>
     *         <p>
     *         Constraints: A value between 64 and 2048.
     *         </p>
     *         <p>
     *         Default: <code>1024</code>
     */
    public Integer replayWindowSize() {
        return replayWindowSize;
    }

    /**
     * <p>
     * The number of seconds after which a DPD timeout occurs.
     * </p>
     * <p>
     * Constraints: A value between 0 and 30.
     * </p>
     * <p>
     * Default: <code>30</code>
     * </p>
     * 
     * @return The number of seconds after which a DPD timeout occurs.</p>
     *         <p>
     *         Constraints: A value between 0 and 30.
     *         </p>
     *         <p>
     *         Default: <code>30</code>
     */
    public Integer dpdTimeoutSeconds() {
        return dpdTimeoutSeconds;
    }

    /**
     * <p>
     * The action to take after DPD timeout occurs. Specify <code>restart</code> to restart the IKE initiation. Specify
     * <code>clear</code> to end the IKE session.
     * </p>
     * <p>
     * Valid Values: <code>clear</code> | <code>none</code> | <code>restart</code>
     * </p>
     * <p>
     * Default: <code>clear</code>
     * </p>
     * 
     * @return The action to take after DPD timeout occurs. Specify <code>restart</code> to restart the IKE initiation.
     *         Specify <code>clear</code> to end the IKE session.</p>
     *         <p>
     *         Valid Values: <code>clear</code> | <code>none</code> | <code>restart</code>
     *         </p>
     *         <p>
     *         Default: <code>clear</code>
     */
    public String dpdTimeoutAction() {
        return dpdTimeoutAction;
    }

    /**
     * Returns true if the Phase1EncryptionAlgorithms property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPhase1EncryptionAlgorithms() {
        return phase1EncryptionAlgorithms != null && !(phase1EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> | <code>AES256-GCM-16</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhase1EncryptionAlgorithms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.</p>
     *         <p>
     *         Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
     *         <code>AES256-GCM-16</code>
     */
    public List<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms() {
        return phase1EncryptionAlgorithms;
    }

    /**
     * Returns true if the Phase2EncryptionAlgorithms property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPhase2EncryptionAlgorithms() {
        return phase2EncryptionAlgorithms != null && !(phase2EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> | <code>AES256-GCM-16</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhase2EncryptionAlgorithms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.</p>
     *         <p>
     *         Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
     *         <code>AES256-GCM-16</code>
     */
    public List<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms() {
        return phase2EncryptionAlgorithms;
    }

    /**
     * Returns true if the Phase1IntegrityAlgorithms property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPhase1IntegrityAlgorithms() {
        return phase1IntegrityAlgorithms != null && !(phase1IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhase1IntegrityAlgorithms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.</p>
     *         <p>
     *         Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
     */
    public List<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms() {
        return phase1IntegrityAlgorithms;
    }

    /**
     * Returns true if the Phase2IntegrityAlgorithms property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPhase2IntegrityAlgorithms() {
        return phase2IntegrityAlgorithms != null && !(phase2IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhase2IntegrityAlgorithms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.</p>
     *         <p>
     *         Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
     */
    public List<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms() {
        return phase2IntegrityAlgorithms;
    }

    /**
     * Returns true if the Phase1DHGroupNumbers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPhase1DHGroupNumbers() {
        return phase1DHGroupNumbers != null && !(phase1DHGroupNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> |
     * <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> |
     * <code>24</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhase1DHGroupNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE
     *         negotiations.</p>
     *         <p>
     *         Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> |
     *         <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code>
     *         | <code>24</code>
     */
    public List<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers() {
        return phase1DHGroupNumbers;
    }

    /**
     * Returns true if the Phase2DHGroupNumbers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPhase2DHGroupNumbers() {
        return phase2DHGroupNumbers != null && !(phase2DHGroupNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> |
     * <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> |
     * <code>23</code> | <code>24</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhase2DHGroupNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE
     *         negotiations.</p>
     *         <p>
     *         Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> |
     *         <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code>
     *         | <code>23</code> | <code>24</code>
     */
    public List<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers() {
        return phase2DHGroupNumbers;
    }

    /**
     * Returns true if the IKEVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIkeVersions() {
        return ikeVersions != null && !(ikeVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IKE versions that are permitted for the VPN tunnel.
     * </p>
     * <p>
     * Valid values: <code>ikev1</code> | <code>ikev2</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIkeVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IKE versions that are permitted for the VPN tunnel.</p>
     *         <p>
     *         Valid values: <code>ikev1</code> | <code>ikev2</code>
     */
    public List<IKEVersionsRequestListValue> ikeVersions() {
        return ikeVersions;
    }

    /**
     * <p>
     * The action to take when the establishing the tunnel for the VPN connection. By default, your customer gateway
     * device must initiate the IKE negotiation and bring up the tunnel. Specify <code>start</code> for AWS to initiate
     * the IKE negotiation.
     * </p>
     * <p>
     * Valid Values: <code>add</code> | <code>start</code>
     * </p>
     * <p>
     * Default: <code>add</code>
     * </p>
     * 
     * @return The action to take when the establishing the tunnel for the VPN connection. By default, your customer
     *         gateway device must initiate the IKE negotiation and bring up the tunnel. Specify <code>start</code> for
     *         AWS to initiate the IKE negotiation.</p>
     *         <p>
     *         Valid Values: <code>add</code> | <code>start</code>
     *         </p>
     *         <p>
     *         Default: <code>add</code>
     */
    public String startupAction() {
        return startupAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tunnelInsideCidr());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelInsideIpv6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(preSharedKey());
        hashCode = 31 * hashCode + Objects.hashCode(phase1LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(phase2LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(rekeyMarginTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(rekeyFuzzPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(replayWindowSize());
        hashCode = 31 * hashCode + Objects.hashCode(dpdTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(dpdTimeoutAction());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1EncryptionAlgorithms() ? phase1EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2EncryptionAlgorithms() ? phase2EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1IntegrityAlgorithms() ? phase1IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2IntegrityAlgorithms() ? phase2IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1DHGroupNumbers() ? phase1DHGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2DHGroupNumbers() ? phase2DHGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIkeVersions() ? ikeVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startupAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnTunnelOptionsSpecification)) {
            return false;
        }
        VpnTunnelOptionsSpecification other = (VpnTunnelOptionsSpecification) obj;
        return Objects.equals(tunnelInsideCidr(), other.tunnelInsideCidr())
                && Objects.equals(tunnelInsideIpv6Cidr(), other.tunnelInsideIpv6Cidr())
                && Objects.equals(preSharedKey(), other.preSharedKey())
                && Objects.equals(phase1LifetimeSeconds(), other.phase1LifetimeSeconds())
                && Objects.equals(phase2LifetimeSeconds(), other.phase2LifetimeSeconds())
                && Objects.equals(rekeyMarginTimeSeconds(), other.rekeyMarginTimeSeconds())
                && Objects.equals(rekeyFuzzPercentage(), other.rekeyFuzzPercentage())
                && Objects.equals(replayWindowSize(), other.replayWindowSize())
                && Objects.equals(dpdTimeoutSeconds(), other.dpdTimeoutSeconds())
                && Objects.equals(dpdTimeoutAction(), other.dpdTimeoutAction())
                && hasPhase1EncryptionAlgorithms() == other.hasPhase1EncryptionAlgorithms()
                && Objects.equals(phase1EncryptionAlgorithms(), other.phase1EncryptionAlgorithms())
                && hasPhase2EncryptionAlgorithms() == other.hasPhase2EncryptionAlgorithms()
                && Objects.equals(phase2EncryptionAlgorithms(), other.phase2EncryptionAlgorithms())
                && hasPhase1IntegrityAlgorithms() == other.hasPhase1IntegrityAlgorithms()
                && Objects.equals(phase1IntegrityAlgorithms(), other.phase1IntegrityAlgorithms())
                && hasPhase2IntegrityAlgorithms() == other.hasPhase2IntegrityAlgorithms()
                && Objects.equals(phase2IntegrityAlgorithms(), other.phase2IntegrityAlgorithms())
                && hasPhase1DHGroupNumbers() == other.hasPhase1DHGroupNumbers()
                && Objects.equals(phase1DHGroupNumbers(), other.phase1DHGroupNumbers())
                && hasPhase2DHGroupNumbers() == other.hasPhase2DHGroupNumbers()
                && Objects.equals(phase2DHGroupNumbers(), other.phase2DHGroupNumbers())
                && hasIkeVersions() == other.hasIkeVersions() && Objects.equals(ikeVersions(), other.ikeVersions())
                && Objects.equals(startupAction(), other.startupAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VpnTunnelOptionsSpecification").add("TunnelInsideCidr", tunnelInsideCidr())
                .add("TunnelInsideIpv6Cidr", tunnelInsideIpv6Cidr()).add("PreSharedKey", preSharedKey())
                .add("Phase1LifetimeSeconds", phase1LifetimeSeconds()).add("Phase2LifetimeSeconds", phase2LifetimeSeconds())
                .add("RekeyMarginTimeSeconds", rekeyMarginTimeSeconds()).add("RekeyFuzzPercentage", rekeyFuzzPercentage())
                .add("ReplayWindowSize", replayWindowSize()).add("DPDTimeoutSeconds", dpdTimeoutSeconds())
                .add("DPDTimeoutAction", dpdTimeoutAction())
                .add("Phase1EncryptionAlgorithms", hasPhase1EncryptionAlgorithms() ? phase1EncryptionAlgorithms() : null)
                .add("Phase2EncryptionAlgorithms", hasPhase2EncryptionAlgorithms() ? phase2EncryptionAlgorithms() : null)
                .add("Phase1IntegrityAlgorithms", hasPhase1IntegrityAlgorithms() ? phase1IntegrityAlgorithms() : null)
                .add("Phase2IntegrityAlgorithms", hasPhase2IntegrityAlgorithms() ? phase2IntegrityAlgorithms() : null)
                .add("Phase1DHGroupNumbers", hasPhase1DHGroupNumbers() ? phase1DHGroupNumbers() : null)
                .add("Phase2DHGroupNumbers", hasPhase2DHGroupNumbers() ? phase2DHGroupNumbers() : null)
                .add("IKEVersions", hasIkeVersions() ? ikeVersions() : null).add("StartupAction", startupAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TunnelInsideCidr":
            return Optional.ofNullable(clazz.cast(tunnelInsideCidr()));
        case "TunnelInsideIpv6Cidr":
            return Optional.ofNullable(clazz.cast(tunnelInsideIpv6Cidr()));
        case "PreSharedKey":
            return Optional.ofNullable(clazz.cast(preSharedKey()));
        case "Phase1LifetimeSeconds":
            return Optional.ofNullable(clazz.cast(phase1LifetimeSeconds()));
        case "Phase2LifetimeSeconds":
            return Optional.ofNullable(clazz.cast(phase2LifetimeSeconds()));
        case "RekeyMarginTimeSeconds":
            return Optional.ofNullable(clazz.cast(rekeyMarginTimeSeconds()));
        case "RekeyFuzzPercentage":
            return Optional.ofNullable(clazz.cast(rekeyFuzzPercentage()));
        case "ReplayWindowSize":
            return Optional.ofNullable(clazz.cast(replayWindowSize()));
        case "DPDTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(dpdTimeoutSeconds()));
        case "DPDTimeoutAction":
            return Optional.ofNullable(clazz.cast(dpdTimeoutAction()));
        case "Phase1EncryptionAlgorithms":
            return Optional.ofNullable(clazz.cast(phase1EncryptionAlgorithms()));
        case "Phase2EncryptionAlgorithms":
            return Optional.ofNullable(clazz.cast(phase2EncryptionAlgorithms()));
        case "Phase1IntegrityAlgorithms":
            return Optional.ofNullable(clazz.cast(phase1IntegrityAlgorithms()));
        case "Phase2IntegrityAlgorithms":
            return Optional.ofNullable(clazz.cast(phase2IntegrityAlgorithms()));
        case "Phase1DHGroupNumbers":
            return Optional.ofNullable(clazz.cast(phase1DHGroupNumbers()));
        case "Phase2DHGroupNumbers":
            return Optional.ofNullable(clazz.cast(phase2DHGroupNumbers()));
        case "IKEVersions":
            return Optional.ofNullable(clazz.cast(ikeVersions()));
        case "StartupAction":
            return Optional.ofNullable(clazz.cast(startupAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnTunnelOptionsSpecification, T> g) {
        return obj -> g.apply((VpnTunnelOptionsSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpnTunnelOptionsSpecification> {
        /**
         * <p>
         * The range of inside IPv4 addresses for the tunnel. Any specified CIDR blocks must be unique across all VPN
         * connections that use the same virtual private gateway.
         * </p>
         * <p>
         * Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks are
         * reserved and cannot be used:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>169.254.0.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.1.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.2.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.3.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.4.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.5.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.169.252/30</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param tunnelInsideCidr
         *        The range of inside IPv4 addresses for the tunnel. Any specified CIDR blocks must be unique across all
         *        VPN connections that use the same virtual private gateway. </p>
         *        <p>
         *        Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR
         *        blocks are reserved and cannot be used:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>169.254.0.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.1.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.2.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.3.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.4.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.5.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.169.252/30</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelInsideCidr(String tunnelInsideCidr);

        /**
         * <p>
         * The range of inside IPv6 addresses for the tunnel. Any specified CIDR blocks must be unique across all VPN
         * connections that use the same transit gateway.
         * </p>
         * <p>
         * Constraints: A size /126 CIDR block from the local <code>fd00::/8</code> range.
         * </p>
         * 
         * @param tunnelInsideIpv6Cidr
         *        The range of inside IPv6 addresses for the tunnel. Any specified CIDR blocks must be unique across all
         *        VPN connections that use the same transit gateway.</p>
         *        <p>
         *        Constraints: A size /126 CIDR block from the local <code>fd00::/8</code> range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr);

        /**
         * <p>
         * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer
         * gateway.
         * </p>
         * <p>
         * Constraints: Allowed characters are alphanumeric characters, periods (.), and underscores (_). Must be
         * between 8 and 64 characters in length and cannot start with zero (0).
         * </p>
         * 
         * @param preSharedKey
         *        The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and
         *        customer gateway.</p>
         *        <p>
         *        Constraints: Allowed characters are alphanumeric characters, periods (.), and underscores (_). Must be
         *        between 8 and 64 characters in length and cannot start with zero (0).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSharedKey(String preSharedKey);

        /**
         * <p>
         * The lifetime for phase 1 of the IKE negotiation, in seconds.
         * </p>
         * <p>
         * Constraints: A value between 900 and 28,800.
         * </p>
         * <p>
         * Default: <code>28800</code>
         * </p>
         * 
         * @param phase1LifetimeSeconds
         *        The lifetime for phase 1 of the IKE negotiation, in seconds.</p>
         *        <p>
         *        Constraints: A value between 900 and 28,800.
         *        </p>
         *        <p>
         *        Default: <code>28800</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds);

        /**
         * <p>
         * The lifetime for phase 2 of the IKE negotiation, in seconds.
         * </p>
         * <p>
         * Constraints: A value between 900 and 3,600. The value must be less than the value for
         * <code>Phase1LifetimeSeconds</code>.
         * </p>
         * <p>
         * Default: <code>3600</code>
         * </p>
         * 
         * @param phase2LifetimeSeconds
         *        The lifetime for phase 2 of the IKE negotiation, in seconds.</p>
         *        <p>
         *        Constraints: A value between 900 and 3,600. The value must be less than the value for
         *        <code>Phase1LifetimeSeconds</code>.
         *        </p>
         *        <p>
         *        Default: <code>3600</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds);

        /**
         * <p>
         * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN
         * connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for
         * <code>RekeyFuzzPercentage</code>.
         * </p>
         * <p>
         * Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code>.
         * </p>
         * <p>
         * Default: <code>540</code>
         * </p>
         * 
         * @param rekeyMarginTimeSeconds
         *        The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN
         *        connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value
         *        for <code>RekeyFuzzPercentage</code>.</p>
         *        <p>
         *        Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code>.
         *        </p>
         *        <p>
         *        Default: <code>540</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds);

        /**
         * <p>
         * The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code>) during which the rekey
         * time is randomly selected.
         * </p>
         * <p>
         * Constraints: A value between 0 and 100.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * 
         * @param rekeyFuzzPercentage
         *        The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code>) during which
         *        the rekey time is randomly selected.</p>
         *        <p>
         *        Constraints: A value between 0 and 100.
         *        </p>
         *        <p>
         *        Default: <code>100</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage);

        /**
         * <p>
         * The number of packets in an IKE replay window.
         * </p>
         * <p>
         * Constraints: A value between 64 and 2048.
         * </p>
         * <p>
         * Default: <code>1024</code>
         * </p>
         * 
         * @param replayWindowSize
         *        The number of packets in an IKE replay window.</p>
         *        <p>
         *        Constraints: A value between 64 and 2048.
         *        </p>
         *        <p>
         *        Default: <code>1024</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayWindowSize(Integer replayWindowSize);

        /**
         * <p>
         * The number of seconds after which a DPD timeout occurs.
         * </p>
         * <p>
         * Constraints: A value between 0 and 30.
         * </p>
         * <p>
         * Default: <code>30</code>
         * </p>
         * 
         * @param dpdTimeoutSeconds
         *        The number of seconds after which a DPD timeout occurs.</p>
         *        <p>
         *        Constraints: A value between 0 and 30.
         *        </p>
         *        <p>
         *        Default: <code>30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds);

        /**
         * <p>
         * The action to take after DPD timeout occurs. Specify <code>restart</code> to restart the IKE initiation.
         * Specify <code>clear</code> to end the IKE session.
         * </p>
         * <p>
         * Valid Values: <code>clear</code> | <code>none</code> | <code>restart</code>
         * </p>
         * <p>
         * Default: <code>clear</code>
         * </p>
         * 
         * @param dpdTimeoutAction
         *        The action to take after DPD timeout occurs. Specify <code>restart</code> to restart the IKE
         *        initiation. Specify <code>clear</code> to end the IKE session.</p>
         *        <p>
         *        Valid Values: <code>clear</code> | <code>none</code> | <code>restart</code>
         *        </p>
         *        <p>
         *        Default: <code>clear</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpdTimeoutAction(String dpdTimeoutAction);

        /**
         * <p>
         * One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         * <code>AES256-GCM-16</code>
         * </p>
         * 
         * @param phase1EncryptionAlgorithms
         *        One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         *        <code>AES256-GCM-16</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms);

        /**
         * <p>
         * One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         * <code>AES256-GCM-16</code>
         * </p>
         * 
         * @param phase1EncryptionAlgorithms
         *        One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         *        <code>AES256-GCM-16</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsRequestListValue... phase1EncryptionAlgorithms);

        /**
         * <p>
         * One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         * <code>AES256-GCM-16</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <Phase1EncryptionAlgorithmsRequestListValue>.Builder} avoiding the need to create one manually via
         * {@link List<Phase1EncryptionAlgorithmsRequestListValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Phase1EncryptionAlgorithmsRequestListValue>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #phase1EncryptionAlgorithms(List<Phase1EncryptionAlgorithmsRequestListValue>)}.
         * 
         * @param phase1EncryptionAlgorithms
         *        a consumer that will call methods on {@link List<Phase1EncryptionAlgorithmsRequestListValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase1EncryptionAlgorithms(List<Phase1EncryptionAlgorithmsRequestListValue>)
         */
        Builder phase1EncryptionAlgorithms(
                Consumer<Phase1EncryptionAlgorithmsRequestListValue.Builder>... phase1EncryptionAlgorithms);

        /**
         * <p>
         * One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         * <code>AES256-GCM-16</code>
         * </p>
         * 
         * @param phase2EncryptionAlgorithms
         *        One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         *        <code>AES256-GCM-16</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms);

        /**
         * <p>
         * One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         * <code>AES256-GCM-16</code>
         * </p>
         * 
         * @param phase2EncryptionAlgorithms
         *        One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         *        <code>AES256-GCM-16</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsRequestListValue... phase2EncryptionAlgorithms);

        /**
         * <p>
         * One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
         * <code>AES256-GCM-16</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <Phase2EncryptionAlgorithmsRequestListValue>.Builder} avoiding the need to create one manually via
         * {@link List<Phase2EncryptionAlgorithmsRequestListValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Phase2EncryptionAlgorithmsRequestListValue>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #phase2EncryptionAlgorithms(List<Phase2EncryptionAlgorithmsRequestListValue>)}.
         * 
         * @param phase2EncryptionAlgorithms
         *        a consumer that will call methods on {@link List<Phase2EncryptionAlgorithmsRequestListValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase2EncryptionAlgorithms(List<Phase2EncryptionAlgorithmsRequestListValue>)
         */
        Builder phase2EncryptionAlgorithms(
                Consumer<Phase2EncryptionAlgorithmsRequestListValue.Builder>... phase2EncryptionAlgorithms);

        /**
         * <p>
         * One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
         * </p>
         * 
         * @param phase1IntegrityAlgorithms
         *        One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> |
         *        <code>SHA2-512</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms);

        /**
         * <p>
         * One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
         * </p>
         * 
         * @param phase1IntegrityAlgorithms
         *        One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> |
         *        <code>SHA2-512</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsRequestListValue... phase1IntegrityAlgorithms);

        /**
         * <p>
         * One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <Phase1IntegrityAlgorithmsRequestListValue>.Builder} avoiding the need to create one manually via
         * {@link List<Phase1IntegrityAlgorithmsRequestListValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Phase1IntegrityAlgorithmsRequestListValue>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #phase1IntegrityAlgorithms(List<Phase1IntegrityAlgorithmsRequestListValue>)}.
         * 
         * @param phase1IntegrityAlgorithms
         *        a consumer that will call methods on {@link List<Phase1IntegrityAlgorithmsRequestListValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase1IntegrityAlgorithms(List<Phase1IntegrityAlgorithmsRequestListValue>)
         */
        Builder phase1IntegrityAlgorithms(
                Consumer<Phase1IntegrityAlgorithmsRequestListValue.Builder>... phase1IntegrityAlgorithms);

        /**
         * <p>
         * One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
         * </p>
         * 
         * @param phase2IntegrityAlgorithms
         *        One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> |
         *        <code>SHA2-512</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms);

        /**
         * <p>
         * One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
         * </p>
         * 
         * @param phase2IntegrityAlgorithms
         *        One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> |
         *        <code>SHA2-512</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsRequestListValue... phase2IntegrityAlgorithms);

        /**
         * <p>
         * One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <Phase2IntegrityAlgorithmsRequestListValue>.Builder} avoiding the need to create one manually via
         * {@link List<Phase2IntegrityAlgorithmsRequestListValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Phase2IntegrityAlgorithmsRequestListValue>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #phase2IntegrityAlgorithms(List<Phase2IntegrityAlgorithmsRequestListValue>)}.
         * 
         * @param phase2IntegrityAlgorithms
         *        a consumer that will call methods on {@link List<Phase2IntegrityAlgorithmsRequestListValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase2IntegrityAlgorithms(List<Phase2IntegrityAlgorithmsRequestListValue>)
         */
        Builder phase2IntegrityAlgorithms(
                Consumer<Phase2IntegrityAlgorithmsRequestListValue.Builder>... phase2IntegrityAlgorithms);

        /**
         * <p>
         * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> |
         * <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> |
         * <code>24</code>
         * </p>
         * 
         * @param phase1DHGroupNumbers
         *        One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> |
         *        <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> |
         *        <code>23</code> | <code>24</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1DHGroupNumbers(Collection<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers);

        /**
         * <p>
         * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> |
         * <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> |
         * <code>24</code>
         * </p>
         * 
         * @param phase1DHGroupNumbers
         *        One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> |
         *        <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> |
         *        <code>23</code> | <code>24</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1DHGroupNumbers(Phase1DHGroupNumbersRequestListValue... phase1DHGroupNumbers);

        /**
         * <p>
         * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> |
         * <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> |
         * <code>24</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <Phase1DHGroupNumbersRequestListValue>.Builder} avoiding the need to create one manually via {@link List
         * <Phase1DHGroupNumbersRequestListValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Phase1DHGroupNumbersRequestListValue>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #phase1DHGroupNumbers(List<Phase1DHGroupNumbersRequestListValue>)}.
         * 
         * @param phase1DHGroupNumbers
         *        a consumer that will call methods on {@link List<Phase1DHGroupNumbersRequestListValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase1DHGroupNumbers(List<Phase1DHGroupNumbersRequestListValue>)
         */
        Builder phase1DHGroupNumbers(Consumer<Phase1DHGroupNumbersRequestListValue.Builder>... phase1DHGroupNumbers);

        /**
         * <p>
         * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> |
         * <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> |
         * <code>23</code> | <code>24</code>
         * </p>
         * 
         * @param phase2DHGroupNumbers
         *        One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> |
         *        <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> |
         *        <code>22</code> | <code>23</code> | <code>24</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2DHGroupNumbers(Collection<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers);

        /**
         * <p>
         * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> |
         * <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> |
         * <code>23</code> | <code>24</code>
         * </p>
         * 
         * @param phase2DHGroupNumbers
         *        One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE
         *        negotiations.</p>
         *        <p>
         *        Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> |
         *        <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> |
         *        <code>22</code> | <code>23</code> | <code>24</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2DHGroupNumbers(Phase2DHGroupNumbersRequestListValue... phase2DHGroupNumbers);

        /**
         * <p>
         * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * <p>
         * Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> |
         * <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> |
         * <code>23</code> | <code>24</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <Phase2DHGroupNumbersRequestListValue>.Builder} avoiding the need to create one manually via {@link List
         * <Phase2DHGroupNumbersRequestListValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Phase2DHGroupNumbersRequestListValue>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #phase2DHGroupNumbers(List<Phase2DHGroupNumbersRequestListValue>)}.
         * 
         * @param phase2DHGroupNumbers
         *        a consumer that will call methods on {@link List<Phase2DHGroupNumbersRequestListValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase2DHGroupNumbers(List<Phase2DHGroupNumbersRequestListValue>)
         */
        Builder phase2DHGroupNumbers(Consumer<Phase2DHGroupNumbersRequestListValue.Builder>... phase2DHGroupNumbers);

        /**
         * <p>
         * The IKE versions that are permitted for the VPN tunnel.
         * </p>
         * <p>
         * Valid values: <code>ikev1</code> | <code>ikev2</code>
         * </p>
         * 
         * @param ikeVersions
         *        The IKE versions that are permitted for the VPN tunnel.</p>
         *        <p>
         *        Valid values: <code>ikev1</code> | <code>ikev2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ikeVersions(Collection<IKEVersionsRequestListValue> ikeVersions);

        /**
         * <p>
         * The IKE versions that are permitted for the VPN tunnel.
         * </p>
         * <p>
         * Valid values: <code>ikev1</code> | <code>ikev2</code>
         * </p>
         * 
         * @param ikeVersions
         *        The IKE versions that are permitted for the VPN tunnel.</p>
         *        <p>
         *        Valid values: <code>ikev1</code> | <code>ikev2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ikeVersions(IKEVersionsRequestListValue... ikeVersions);

        /**
         * <p>
         * The IKE versions that are permitted for the VPN tunnel.
         * </p>
         * <p>
         * Valid values: <code>ikev1</code> | <code>ikev2</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List<IKEVersionsRequestListValue>.Builder}
         * avoiding the need to create one manually via {@link List<IKEVersionsRequestListValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IKEVersionsRequestListValue>.Builder#build()} is called
         * immediately and its result is passed to {@link #ikeVersions(List<IKEVersionsRequestListValue>)}.
         * 
         * @param ikeVersions
         *        a consumer that will call methods on {@link List<IKEVersionsRequestListValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ikeVersions(List<IKEVersionsRequestListValue>)
         */
        Builder ikeVersions(Consumer<IKEVersionsRequestListValue.Builder>... ikeVersions);

        /**
         * <p>
         * The action to take when the establishing the tunnel for the VPN connection. By default, your customer gateway
         * device must initiate the IKE negotiation and bring up the tunnel. Specify <code>start</code> for AWS to
         * initiate the IKE negotiation.
         * </p>
         * <p>
         * Valid Values: <code>add</code> | <code>start</code>
         * </p>
         * <p>
         * Default: <code>add</code>
         * </p>
         * 
         * @param startupAction
         *        The action to take when the establishing the tunnel for the VPN connection. By default, your customer
         *        gateway device must initiate the IKE negotiation and bring up the tunnel. Specify <code>start</code>
         *        for AWS to initiate the IKE negotiation.</p>
         *        <p>
         *        Valid Values: <code>add</code> | <code>start</code>
         *        </p>
         *        <p>
         *        Default: <code>add</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startupAction(String startupAction);
    }

    static final class BuilderImpl implements Builder {
        private String tunnelInsideCidr;

        private String tunnelInsideIpv6Cidr;

        private String preSharedKey;

        private Integer phase1LifetimeSeconds;

        private Integer phase2LifetimeSeconds;

        private Integer rekeyMarginTimeSeconds;

        private Integer rekeyFuzzPercentage;

        private Integer replayWindowSize;

        private Integer dpdTimeoutSeconds;

        private String dpdTimeoutAction;

        private List<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms = DefaultSdkAutoConstructList
                .getInstance();

        private List<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms = DefaultSdkAutoConstructList
                .getInstance();

        private List<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms = DefaultSdkAutoConstructList
                .getInstance();

        private List<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms = DefaultSdkAutoConstructList
                .getInstance();

        private List<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<IKEVersionsRequestListValue> ikeVersions = DefaultSdkAutoConstructList.getInstance();

        private String startupAction;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnTunnelOptionsSpecification model) {
            tunnelInsideCidr(model.tunnelInsideCidr);
            tunnelInsideIpv6Cidr(model.tunnelInsideIpv6Cidr);
            preSharedKey(model.preSharedKey);
            phase1LifetimeSeconds(model.phase1LifetimeSeconds);
            phase2LifetimeSeconds(model.phase2LifetimeSeconds);
            rekeyMarginTimeSeconds(model.rekeyMarginTimeSeconds);
            rekeyFuzzPercentage(model.rekeyFuzzPercentage);
            replayWindowSize(model.replayWindowSize);
            dpdTimeoutSeconds(model.dpdTimeoutSeconds);
            dpdTimeoutAction(model.dpdTimeoutAction);
            phase1EncryptionAlgorithms(model.phase1EncryptionAlgorithms);
            phase2EncryptionAlgorithms(model.phase2EncryptionAlgorithms);
            phase1IntegrityAlgorithms(model.phase1IntegrityAlgorithms);
            phase2IntegrityAlgorithms(model.phase2IntegrityAlgorithms);
            phase1DHGroupNumbers(model.phase1DHGroupNumbers);
            phase2DHGroupNumbers(model.phase2DHGroupNumbers);
            ikeVersions(model.ikeVersions);
            startupAction(model.startupAction);
        }

        public final String getTunnelInsideCidr() {
            return tunnelInsideCidr;
        }

        @Override
        public final Builder tunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        public final void setTunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        public final String getTunnelInsideIpv6Cidr() {
            return tunnelInsideIpv6Cidr;
        }

        @Override
        public final Builder tunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr) {
            this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
            return this;
        }

        public final void setTunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr) {
            this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
        }

        public final String getPreSharedKey() {
            return preSharedKey;
        }

        @Override
        public final Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        public final void setPreSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
        }

        public final Integer getPhase1LifetimeSeconds() {
            return phase1LifetimeSeconds;
        }

        @Override
        public final Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
            return this;
        }

        public final void setPhase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
        }

        public final Integer getPhase2LifetimeSeconds() {
            return phase2LifetimeSeconds;
        }

        @Override
        public final Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
            return this;
        }

        public final void setPhase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
        }

        public final Integer getRekeyMarginTimeSeconds() {
            return rekeyMarginTimeSeconds;
        }

        @Override
        public final Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
            return this;
        }

        public final void setRekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
        }

        public final Integer getRekeyFuzzPercentage() {
            return rekeyFuzzPercentage;
        }

        @Override
        public final Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
            return this;
        }

        public final void setRekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
        }

        public final Integer getReplayWindowSize() {
            return replayWindowSize;
        }

        @Override
        public final Builder replayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
            return this;
        }

        public final void setReplayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
        }

        public final Integer getDpdTimeoutSeconds() {
            return dpdTimeoutSeconds;
        }

        @Override
        public final Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
            return this;
        }

        public final void setDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        }

        public final String getDpdTimeoutAction() {
            return dpdTimeoutAction;
        }

        @Override
        public final Builder dpdTimeoutAction(String dpdTimeoutAction) {
            this.dpdTimeoutAction = dpdTimeoutAction;
            return this;
        }

        public final void setDpdTimeoutAction(String dpdTimeoutAction) {
            this.dpdTimeoutAction = dpdTimeoutAction;
        }

        public final Collection<Phase1EncryptionAlgorithmsRequestListValue.Builder> getPhase1EncryptionAlgorithms() {
            if (phase1EncryptionAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return phase1EncryptionAlgorithms != null ? phase1EncryptionAlgorithms.stream()
                    .map(Phase1EncryptionAlgorithmsRequestListValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phase1EncryptionAlgorithms(
                Collection<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = Phase1EncryptionAlgorithmsRequestListCopier.copy(phase1EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsRequestListValue... phase1EncryptionAlgorithms) {
            phase1EncryptionAlgorithms(Arrays.asList(phase1EncryptionAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(
                Consumer<Phase1EncryptionAlgorithmsRequestListValue.Builder>... phase1EncryptionAlgorithms) {
            phase1EncryptionAlgorithms(Stream.of(phase1EncryptionAlgorithms)
                    .map(c -> Phase1EncryptionAlgorithmsRequestListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhase1EncryptionAlgorithms(
                Collection<Phase1EncryptionAlgorithmsRequestListValue.BuilderImpl> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = Phase1EncryptionAlgorithmsRequestListCopier
                    .copyFromBuilder(phase1EncryptionAlgorithms);
        }

        public final Collection<Phase2EncryptionAlgorithmsRequestListValue.Builder> getPhase2EncryptionAlgorithms() {
            if (phase2EncryptionAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return phase2EncryptionAlgorithms != null ? phase2EncryptionAlgorithms.stream()
                    .map(Phase2EncryptionAlgorithmsRequestListValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phase2EncryptionAlgorithms(
                Collection<Phase2EncryptionAlgorithmsRequestListValue> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = Phase2EncryptionAlgorithmsRequestListCopier.copy(phase2EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsRequestListValue... phase2EncryptionAlgorithms) {
            phase2EncryptionAlgorithms(Arrays.asList(phase2EncryptionAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(
                Consumer<Phase2EncryptionAlgorithmsRequestListValue.Builder>... phase2EncryptionAlgorithms) {
            phase2EncryptionAlgorithms(Stream.of(phase2EncryptionAlgorithms)
                    .map(c -> Phase2EncryptionAlgorithmsRequestListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhase2EncryptionAlgorithms(
                Collection<Phase2EncryptionAlgorithmsRequestListValue.BuilderImpl> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = Phase2EncryptionAlgorithmsRequestListCopier
                    .copyFromBuilder(phase2EncryptionAlgorithms);
        }

        public final Collection<Phase1IntegrityAlgorithmsRequestListValue.Builder> getPhase1IntegrityAlgorithms() {
            if (phase1IntegrityAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return phase1IntegrityAlgorithms != null ? phase1IntegrityAlgorithms.stream()
                    .map(Phase1IntegrityAlgorithmsRequestListValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phase1IntegrityAlgorithms(
                Collection<Phase1IntegrityAlgorithmsRequestListValue> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = Phase1IntegrityAlgorithmsRequestListCopier.copy(phase1IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsRequestListValue... phase1IntegrityAlgorithms) {
            phase1IntegrityAlgorithms(Arrays.asList(phase1IntegrityAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(
                Consumer<Phase1IntegrityAlgorithmsRequestListValue.Builder>... phase1IntegrityAlgorithms) {
            phase1IntegrityAlgorithms(Stream.of(phase1IntegrityAlgorithms)
                    .map(c -> Phase1IntegrityAlgorithmsRequestListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhase1IntegrityAlgorithms(
                Collection<Phase1IntegrityAlgorithmsRequestListValue.BuilderImpl> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = Phase1IntegrityAlgorithmsRequestListCopier
                    .copyFromBuilder(phase1IntegrityAlgorithms);
        }

        public final Collection<Phase2IntegrityAlgorithmsRequestListValue.Builder> getPhase2IntegrityAlgorithms() {
            if (phase2IntegrityAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return phase2IntegrityAlgorithms != null ? phase2IntegrityAlgorithms.stream()
                    .map(Phase2IntegrityAlgorithmsRequestListValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phase2IntegrityAlgorithms(
                Collection<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = Phase2IntegrityAlgorithmsRequestListCopier.copy(phase2IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsRequestListValue... phase2IntegrityAlgorithms) {
            phase2IntegrityAlgorithms(Arrays.asList(phase2IntegrityAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(
                Consumer<Phase2IntegrityAlgorithmsRequestListValue.Builder>... phase2IntegrityAlgorithms) {
            phase2IntegrityAlgorithms(Stream.of(phase2IntegrityAlgorithms)
                    .map(c -> Phase2IntegrityAlgorithmsRequestListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhase2IntegrityAlgorithms(
                Collection<Phase2IntegrityAlgorithmsRequestListValue.BuilderImpl> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = Phase2IntegrityAlgorithmsRequestListCopier
                    .copyFromBuilder(phase2IntegrityAlgorithms);
        }

        public final Collection<Phase1DHGroupNumbersRequestListValue.Builder> getPhase1DHGroupNumbers() {
            if (phase1DHGroupNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return phase1DHGroupNumbers != null ? phase1DHGroupNumbers.stream()
                    .map(Phase1DHGroupNumbersRequestListValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phase1DHGroupNumbers(Collection<Phase1DHGroupNumbersRequestListValue> phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers = Phase1DHGroupNumbersRequestListCopier.copy(phase1DHGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DHGroupNumbers(Phase1DHGroupNumbersRequestListValue... phase1DHGroupNumbers) {
            phase1DHGroupNumbers(Arrays.asList(phase1DHGroupNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DHGroupNumbers(Consumer<Phase1DHGroupNumbersRequestListValue.Builder>... phase1DHGroupNumbers) {
            phase1DHGroupNumbers(Stream.of(phase1DHGroupNumbers)
                    .map(c -> Phase1DHGroupNumbersRequestListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhase1DHGroupNumbers(
                Collection<Phase1DHGroupNumbersRequestListValue.BuilderImpl> phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers = Phase1DHGroupNumbersRequestListCopier.copyFromBuilder(phase1DHGroupNumbers);
        }

        public final Collection<Phase2DHGroupNumbersRequestListValue.Builder> getPhase2DHGroupNumbers() {
            if (phase2DHGroupNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return phase2DHGroupNumbers != null ? phase2DHGroupNumbers.stream()
                    .map(Phase2DHGroupNumbersRequestListValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phase2DHGroupNumbers(Collection<Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers = Phase2DHGroupNumbersRequestListCopier.copy(phase2DHGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DHGroupNumbers(Phase2DHGroupNumbersRequestListValue... phase2DHGroupNumbers) {
            phase2DHGroupNumbers(Arrays.asList(phase2DHGroupNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DHGroupNumbers(Consumer<Phase2DHGroupNumbersRequestListValue.Builder>... phase2DHGroupNumbers) {
            phase2DHGroupNumbers(Stream.of(phase2DHGroupNumbers)
                    .map(c -> Phase2DHGroupNumbersRequestListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhase2DHGroupNumbers(
                Collection<Phase2DHGroupNumbersRequestListValue.BuilderImpl> phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers = Phase2DHGroupNumbersRequestListCopier.copyFromBuilder(phase2DHGroupNumbers);
        }

        public final Collection<IKEVersionsRequestListValue.Builder> getIkeVersions() {
            if (ikeVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return ikeVersions != null ? ikeVersions.stream().map(IKEVersionsRequestListValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ikeVersions(Collection<IKEVersionsRequestListValue> ikeVersions) {
            this.ikeVersions = IKEVersionsRequestListCopier.copy(ikeVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(IKEVersionsRequestListValue... ikeVersions) {
            ikeVersions(Arrays.asList(ikeVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(Consumer<IKEVersionsRequestListValue.Builder>... ikeVersions) {
            ikeVersions(Stream.of(ikeVersions).map(c -> IKEVersionsRequestListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIkeVersions(Collection<IKEVersionsRequestListValue.BuilderImpl> ikeVersions) {
            this.ikeVersions = IKEVersionsRequestListCopier.copyFromBuilder(ikeVersions);
        }

        public final String getStartupAction() {
            return startupAction;
        }

        @Override
        public final Builder startupAction(String startupAction) {
            this.startupAction = startupAction;
            return this;
        }

        public final void setStartupAction(String startupAction) {
            this.startupAction = startupAction;
        }

        @Override
        public VpnTunnelOptionsSpecification build() {
            return new VpnTunnelOptionsSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
