/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartNetworkInsightsAnalysisRequest extends Ec2Request implements
        ToCopyableBuilder<StartNetworkInsightsAnalysisRequest.Builder, StartNetworkInsightsAnalysisRequest> {
    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsPathId")
            .getter(getter(StartNetworkInsightsAnalysisRequest::networkInsightsPathId))
            .setter(setter(Builder::networkInsightsPathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathId")
                    .unmarshallLocationName("NetworkInsightsPathId").build()).build();

    private static final SdkField<List<String>> FILTER_IN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterInArns")
            .getter(getter(StartNetworkInsightsAnalysisRequest::filterInArns))
            .setter(setter(Builder::filterInArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterInArn")
                    .unmarshallLocationName("FilterInArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(StartNetworkInsightsAnalysisRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartNetworkInsightsAnalysisRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_PATH_ID_FIELD, FILTER_IN_ARNS_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private final String networkInsightsPathId;

    private final List<String> filterInArns;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private StartNetworkInsightsAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.networkInsightsPathId = builder.networkInsightsPathId;
        this.filterInArns = builder.filterInArns;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the path.
     * </p>
     * 
     * @return The ID of the path.
     */
    public String networkInsightsPathId() {
        return networkInsightsPathId;
    }

    /**
     * Returns true if the FilterInArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilterInArns() {
        return filterInArns != null && !(filterInArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the resources that the path must traverse.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterInArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the resources that the path must traverse.
     */
    public List<String> filterInArns() {
        return filterInArns;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to apply.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsPathId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterInArns() ? filterInArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNetworkInsightsAnalysisRequest)) {
            return false;
        }
        StartNetworkInsightsAnalysisRequest other = (StartNetworkInsightsAnalysisRequest) obj;
        return Objects.equals(networkInsightsPathId(), other.networkInsightsPathId())
                && hasFilterInArns() == other.hasFilterInArns() && Objects.equals(filterInArns(), other.filterInArns())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartNetworkInsightsAnalysisRequest").add("NetworkInsightsPathId", networkInsightsPathId())
                .add("FilterInArns", hasFilterInArns() ? filterInArns() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("ClientToken", clientToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsPathId":
            return Optional.ofNullable(clazz.cast(networkInsightsPathId()));
        case "FilterInArns":
            return Optional.ofNullable(clazz.cast(filterInArns()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartNetworkInsightsAnalysisRequest, T> g) {
        return obj -> g.apply((StartNetworkInsightsAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, StartNetworkInsightsAnalysisRequest> {
        /**
         * <p>
         * The ID of the path.
         * </p>
         * 
         * @param networkInsightsPathId
         *        The ID of the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsPathId(String networkInsightsPathId);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * </p>
         * 
         * @param filterInArns
         *        The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterInArns(Collection<String> filterInArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * </p>
         * 
         * @param filterInArns
         *        The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterInArns(String... filterInArns);

        /**
         * <p>
         * The tags to apply.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String networkInsightsPathId;

        private List<String> filterInArns = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartNetworkInsightsAnalysisRequest model) {
            super(model);
            networkInsightsPathId(model.networkInsightsPathId);
            filterInArns(model.filterInArns);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
        }

        public final String getNetworkInsightsPathId() {
            return networkInsightsPathId;
        }

        @Override
        public final Builder networkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        public final void setNetworkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
        }

        public final Collection<String> getFilterInArns() {
            if (filterInArns instanceof SdkAutoConstructList) {
                return null;
            }
            return filterInArns;
        }

        @Override
        public final Builder filterInArns(Collection<String> filterInArns) {
            this.filterInArns = ArnListCopier.copy(filterInArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterInArns(String... filterInArns) {
            filterInArns(Arrays.asList(filterInArns));
            return this;
        }

        public final void setFilterInArns(Collection<String> filterInArns) {
            this.filterInArns = ArnListCopier.copy(filterInArns);
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            if (tagSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNetworkInsightsAnalysisRequest build() {
            return new StartNetworkInsightsAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
