/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.EnaSupport;
import software.amazon.awssdk.services.ec2.model.NetworkCardInfo;
import software.amazon.awssdk.services.ec2.model.NetworkCardInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInfo> {
    private static final SdkField<String> NETWORK_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkPerformance").getter(NetworkInfo.getter(NetworkInfo::networkPerformance)).setter(NetworkInfo.setter(Builder::networkPerformance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformance").unmarshallLocationName("networkPerformance").build()}).build();
    private static final SdkField<Integer> MAXIMUM_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumNetworkInterfaces").getter(NetworkInfo.getter(NetworkInfo::maximumNetworkInterfaces)).setter(NetworkInfo.setter(Builder::maximumNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkInterfaces").unmarshallLocationName("maximumNetworkInterfaces").build()}).build();
    private static final SdkField<Integer> MAXIMUM_NETWORK_CARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumNetworkCards").getter(NetworkInfo.getter(NetworkInfo::maximumNetworkCards)).setter(NetworkInfo.setter(Builder::maximumNetworkCards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkCards").unmarshallLocationName("maximumNetworkCards").build()}).build();
    private static final SdkField<Integer> DEFAULT_NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultNetworkCardIndex").getter(NetworkInfo.getter(NetworkInfo::defaultNetworkCardIndex)).setter(NetworkInfo.setter(Builder::defaultNetworkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultNetworkCardIndex").unmarshallLocationName("defaultNetworkCardIndex").build()}).build();
    private static final SdkField<List<NetworkCardInfo>> NETWORK_CARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkCards").getter(NetworkInfo.getter(NetworkInfo::networkCards)).setter(NetworkInfo.setter(Builder::networkCards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCards").unmarshallLocationName("networkCards").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkCardInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV4_ADDRESSES_PER_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv4AddressesPerInterface").getter(NetworkInfo.getter(NetworkInfo::ipv4AddressesPerInterface)).setter(NetworkInfo.setter(Builder::ipv4AddressesPerInterface)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4AddressesPerInterface").unmarshallLocationName("ipv4AddressesPerInterface").build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESSES_PER_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressesPerInterface").getter(NetworkInfo.getter(NetworkInfo::ipv6AddressesPerInterface)).setter(NetworkInfo.setter(Builder::ipv6AddressesPerInterface)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesPerInterface").unmarshallLocationName("ipv6AddressesPerInterface").build()}).build();
    private static final SdkField<Boolean> IPV6_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ipv6Supported").getter(NetworkInfo.getter(NetworkInfo::ipv6Supported)).setter(NetworkInfo.setter(Builder::ipv6Supported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Supported").unmarshallLocationName("ipv6Supported").build()}).build();
    private static final SdkField<String> ENA_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnaSupport").getter(NetworkInfo.getter(NetworkInfo::enaSupportAsString)).setter(NetworkInfo.setter(Builder::enaSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport").unmarshallLocationName("enaSupport").build()}).build();
    private static final SdkField<Boolean> EFA_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EfaSupported").getter(NetworkInfo.getter(NetworkInfo::efaSupported)).setter(NetworkInfo.setter(Builder::efaSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfaSupported").unmarshallLocationName("efaSupported").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PERFORMANCE_FIELD, MAXIMUM_NETWORK_INTERFACES_FIELD, MAXIMUM_NETWORK_CARDS_FIELD, DEFAULT_NETWORK_CARD_INDEX_FIELD, NETWORK_CARDS_FIELD, IPV4_ADDRESSES_PER_INTERFACE_FIELD, IPV6_ADDRESSES_PER_INTERFACE_FIELD, IPV6_SUPPORTED_FIELD, ENA_SUPPORT_FIELD, EFA_SUPPORTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkPerformance;
    private final Integer maximumNetworkInterfaces;
    private final Integer maximumNetworkCards;
    private final Integer defaultNetworkCardIndex;
    private final List<NetworkCardInfo> networkCards;
    private final Integer ipv4AddressesPerInterface;
    private final Integer ipv6AddressesPerInterface;
    private final Boolean ipv6Supported;
    private final String enaSupport;
    private final Boolean efaSupported;

    private NetworkInfo(BuilderImpl builder) {
        this.networkPerformance = builder.networkPerformance;
        this.maximumNetworkInterfaces = builder.maximumNetworkInterfaces;
        this.maximumNetworkCards = builder.maximumNetworkCards;
        this.defaultNetworkCardIndex = builder.defaultNetworkCardIndex;
        this.networkCards = builder.networkCards;
        this.ipv4AddressesPerInterface = builder.ipv4AddressesPerInterface;
        this.ipv6AddressesPerInterface = builder.ipv6AddressesPerInterface;
        this.ipv6Supported = builder.ipv6Supported;
        this.enaSupport = builder.enaSupport;
        this.efaSupported = builder.efaSupported;
    }

    public String networkPerformance() {
        return this.networkPerformance;
    }

    public Integer maximumNetworkInterfaces() {
        return this.maximumNetworkInterfaces;
    }

    public Integer maximumNetworkCards() {
        return this.maximumNetworkCards;
    }

    public Integer defaultNetworkCardIndex() {
        return this.defaultNetworkCardIndex;
    }

    public boolean hasNetworkCards() {
        return this.networkCards != null && !(this.networkCards instanceof SdkAutoConstructList);
    }

    public List<NetworkCardInfo> networkCards() {
        return this.networkCards;
    }

    public Integer ipv4AddressesPerInterface() {
        return this.ipv4AddressesPerInterface;
    }

    public Integer ipv6AddressesPerInterface() {
        return this.ipv6AddressesPerInterface;
    }

    public Boolean ipv6Supported() {
        return this.ipv6Supported;
    }

    public EnaSupport enaSupport() {
        return EnaSupport.fromValue(this.enaSupport);
    }

    public String enaSupportAsString() {
        return this.enaSupport;
    }

    public Boolean efaSupported() {
        return this.efaSupported;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNetworkCards());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultNetworkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkCards() ? this.networkCards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4AddressesPerInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressesPerInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Supported());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.efaSupported());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInfo)) {
            return false;
        }
        NetworkInfo other = (NetworkInfo)obj;
        return Objects.equals(this.networkPerformance(), other.networkPerformance()) && Objects.equals(this.maximumNetworkInterfaces(), other.maximumNetworkInterfaces()) && Objects.equals(this.maximumNetworkCards(), other.maximumNetworkCards()) && Objects.equals(this.defaultNetworkCardIndex(), other.defaultNetworkCardIndex()) && this.hasNetworkCards() == other.hasNetworkCards() && Objects.equals(this.networkCards(), other.networkCards()) && Objects.equals(this.ipv4AddressesPerInterface(), other.ipv4AddressesPerInterface()) && Objects.equals(this.ipv6AddressesPerInterface(), other.ipv6AddressesPerInterface()) && Objects.equals(this.ipv6Supported(), other.ipv6Supported()) && Objects.equals(this.enaSupportAsString(), other.enaSupportAsString()) && Objects.equals(this.efaSupported(), other.efaSupported());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInfo").add("NetworkPerformance", (Object)this.networkPerformance()).add("MaximumNetworkInterfaces", (Object)this.maximumNetworkInterfaces()).add("MaximumNetworkCards", (Object)this.maximumNetworkCards()).add("DefaultNetworkCardIndex", (Object)this.defaultNetworkCardIndex()).add("NetworkCards", this.hasNetworkCards() ? this.networkCards() : null).add("Ipv4AddressesPerInterface", (Object)this.ipv4AddressesPerInterface()).add("Ipv6AddressesPerInterface", (Object)this.ipv6AddressesPerInterface()).add("Ipv6Supported", (Object)this.ipv6Supported()).add("EnaSupport", (Object)this.enaSupportAsString()).add("EfaSupported", (Object)this.efaSupported()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkPerformance": {
                return Optional.ofNullable(clazz.cast(this.networkPerformance()));
            }
            case "MaximumNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.maximumNetworkInterfaces()));
            }
            case "MaximumNetworkCards": {
                return Optional.ofNullable(clazz.cast(this.maximumNetworkCards()));
            }
            case "DefaultNetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.defaultNetworkCardIndex()));
            }
            case "NetworkCards": {
                return Optional.ofNullable(clazz.cast(this.networkCards()));
            }
            case "Ipv4AddressesPerInterface": {
                return Optional.ofNullable(clazz.cast(this.ipv4AddressesPerInterface()));
            }
            case "Ipv6AddressesPerInterface": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressesPerInterface()));
            }
            case "Ipv6Supported": {
                return Optional.ofNullable(clazz.cast(this.ipv6Supported()));
            }
            case "EnaSupport": {
                return Optional.ofNullable(clazz.cast(this.enaSupportAsString()));
            }
            case "EfaSupported": {
                return Optional.ofNullable(clazz.cast(this.efaSupported()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInfo, T> g) {
        return obj -> g.apply((NetworkInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkPerformance;
        private Integer maximumNetworkInterfaces;
        private Integer maximumNetworkCards;
        private Integer defaultNetworkCardIndex;
        private List<NetworkCardInfo> networkCards = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv4AddressesPerInterface;
        private Integer ipv6AddressesPerInterface;
        private Boolean ipv6Supported;
        private String enaSupport;
        private Boolean efaSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInfo model) {
            this.networkPerformance(model.networkPerformance);
            this.maximumNetworkInterfaces(model.maximumNetworkInterfaces);
            this.maximumNetworkCards(model.maximumNetworkCards);
            this.defaultNetworkCardIndex(model.defaultNetworkCardIndex);
            this.networkCards(model.networkCards);
            this.ipv4AddressesPerInterface(model.ipv4AddressesPerInterface);
            this.ipv6AddressesPerInterface(model.ipv6AddressesPerInterface);
            this.ipv6Supported(model.ipv6Supported);
            this.enaSupport(model.enaSupport);
            this.efaSupported(model.efaSupported);
        }

        public final String getNetworkPerformance() {
            return this.networkPerformance;
        }

        @Override
        public final Builder networkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
            return this;
        }

        public final void setNetworkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
        }

        public final Integer getMaximumNetworkInterfaces() {
            return this.maximumNetworkInterfaces;
        }

        @Override
        public final Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
            return this;
        }

        public final void setMaximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
        }

        public final Integer getMaximumNetworkCards() {
            return this.maximumNetworkCards;
        }

        @Override
        public final Builder maximumNetworkCards(Integer maximumNetworkCards) {
            this.maximumNetworkCards = maximumNetworkCards;
            return this;
        }

        public final void setMaximumNetworkCards(Integer maximumNetworkCards) {
            this.maximumNetworkCards = maximumNetworkCards;
        }

        public final Integer getDefaultNetworkCardIndex() {
            return this.defaultNetworkCardIndex;
        }

        @Override
        public final Builder defaultNetworkCardIndex(Integer defaultNetworkCardIndex) {
            this.defaultNetworkCardIndex = defaultNetworkCardIndex;
            return this;
        }

        public final void setDefaultNetworkCardIndex(Integer defaultNetworkCardIndex) {
            this.defaultNetworkCardIndex = defaultNetworkCardIndex;
        }

        public final Collection<NetworkCardInfo.Builder> getNetworkCards() {
            if (this.networkCards instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkCards != null ? (Collection)this.networkCards.stream().map(NetworkCardInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkCards(Collection<NetworkCardInfo> networkCards) {
            this.networkCards = NetworkCardInfoListCopier.copy(networkCards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkCards(NetworkCardInfo ... networkCards) {
            this.networkCards(Arrays.asList(networkCards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkCards(Consumer<NetworkCardInfo.Builder> ... networkCards) {
            this.networkCards(Stream.of(networkCards).map(c -> (NetworkCardInfo)((NetworkCardInfo.Builder)NetworkCardInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkCards(Collection<NetworkCardInfo.BuilderImpl> networkCards) {
            this.networkCards = NetworkCardInfoListCopier.copyFromBuilder(networkCards);
        }

        public final Integer getIpv4AddressesPerInterface() {
            return this.ipv4AddressesPerInterface;
        }

        @Override
        public final Builder ipv4AddressesPerInterface(Integer ipv4AddressesPerInterface) {
            this.ipv4AddressesPerInterface = ipv4AddressesPerInterface;
            return this;
        }

        public final void setIpv4AddressesPerInterface(Integer ipv4AddressesPerInterface) {
            this.ipv4AddressesPerInterface = ipv4AddressesPerInterface;
        }

        public final Integer getIpv6AddressesPerInterface() {
            return this.ipv6AddressesPerInterface;
        }

        @Override
        public final Builder ipv6AddressesPerInterface(Integer ipv6AddressesPerInterface) {
            this.ipv6AddressesPerInterface = ipv6AddressesPerInterface;
            return this;
        }

        public final void setIpv6AddressesPerInterface(Integer ipv6AddressesPerInterface) {
            this.ipv6AddressesPerInterface = ipv6AddressesPerInterface;
        }

        public final Boolean getIpv6Supported() {
            return this.ipv6Supported;
        }

        @Override
        public final Builder ipv6Supported(Boolean ipv6Supported) {
            this.ipv6Supported = ipv6Supported;
            return this;
        }

        public final void setIpv6Supported(Boolean ipv6Supported) {
            this.ipv6Supported = ipv6Supported;
        }

        public final String getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(String enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        @Override
        public final Builder enaSupport(EnaSupport enaSupport) {
            this.enaSupport(enaSupport == null ? null : enaSupport.toString());
            return this;
        }

        public final void setEnaSupport(String enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Boolean getEfaSupported() {
            return this.efaSupported;
        }

        @Override
        public final Builder efaSupported(Boolean efaSupported) {
            this.efaSupported = efaSupported;
            return this;
        }

        public final void setEfaSupported(Boolean efaSupported) {
            this.efaSupported = efaSupported;
        }

        public NetworkInfo build() {
            return new NetworkInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInfo> {
        public Builder networkPerformance(String var1);

        public Builder maximumNetworkInterfaces(Integer var1);

        public Builder maximumNetworkCards(Integer var1);

        public Builder defaultNetworkCardIndex(Integer var1);

        public Builder networkCards(Collection<NetworkCardInfo> var1);

        public Builder networkCards(NetworkCardInfo ... var1);

        public Builder networkCards(Consumer<NetworkCardInfo.Builder> ... var1);

        public Builder ipv4AddressesPerInterface(Integer var1);

        public Builder ipv6AddressesPerInterface(Integer var1);

        public Builder ipv6Supported(Boolean var1);

        public Builder enaSupport(String var1);

        public Builder enaSupport(EnaSupport var1);

        public Builder efaSupported(Boolean var1);
    }
}

