/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway Connect peer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayConnectPeer implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayConnectPeer.Builder, TransitGatewayConnectPeer> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(TransitGatewayConnectPeer::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_CONNECT_PEER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayConnectPeerId")
            .getter(getter(TransitGatewayConnectPeer::transitGatewayConnectPeerId))
            .setter(setter(Builder::transitGatewayConnectPeerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectPeerId")
                    .unmarshallLocationName("transitGatewayConnectPeerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayConnectPeer::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(TransitGatewayConnectPeer::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<TransitGatewayConnectPeerConfiguration> CONNECT_PEER_CONFIGURATION_FIELD = SdkField
            .<TransitGatewayConnectPeerConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectPeerConfiguration")
            .getter(getter(TransitGatewayConnectPeer::connectPeerConfiguration))
            .setter(setter(Builder::connectPeerConfiguration))
            .constructor(TransitGatewayConnectPeerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerConfiguration")
                    .unmarshallLocationName("connectPeerConfiguration").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TransitGatewayConnectPeer::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_CONNECT_PEER_ID_FIELD, STATE_FIELD, CREATION_TIME_FIELD,
            CONNECT_PEER_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentId;

    private final String transitGatewayConnectPeerId;

    private final String state;

    private final Instant creationTime;

    private final TransitGatewayConnectPeerConfiguration connectPeerConfiguration;

    private final List<Tag> tags;

    private TransitGatewayConnectPeer(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transitGatewayConnectPeerId = builder.transitGatewayConnectPeerId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.connectPeerConfiguration = builder.connectPeerConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Connect attachment.
     * </p>
     * 
     * @return The ID of the Connect attachment.
     */
    public String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the Connect peer.
     * </p>
     * 
     * @return The ID of the Connect peer.
     */
    public String transitGatewayConnectPeerId() {
        return transitGatewayConnectPeerId;
    }

    /**
     * <p>
     * The state of the Connect peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayConnectPeerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Connect peer.
     * @see TransitGatewayConnectPeerState
     */
    public TransitGatewayConnectPeerState state() {
        return TransitGatewayConnectPeerState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Connect peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayConnectPeerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Connect peer.
     * @see TransitGatewayConnectPeerState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Connect peer details.
     * </p>
     * 
     * @return The Connect peer details.
     */
    public TransitGatewayConnectPeerConfiguration connectPeerConfiguration() {
        return connectPeerConfiguration;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the Connect peer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the Connect peer.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayConnectPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(connectPeerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConnectPeer)) {
            return false;
        }
        TransitGatewayConnectPeer other = (TransitGatewayConnectPeer) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(transitGatewayConnectPeerId(), other.transitGatewayConnectPeerId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(connectPeerConfiguration(), other.connectPeerConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayConnectPeer").add("TransitGatewayAttachmentId", transitGatewayAttachmentId())
                .add("TransitGatewayConnectPeerId", transitGatewayConnectPeerId()).add("State", stateAsString())
                .add("CreationTime", creationTime()).add("ConnectPeerConfiguration", connectPeerConfiguration())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "TransitGatewayConnectPeerId":
            return Optional.ofNullable(clazz.cast(transitGatewayConnectPeerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ConnectPeerConfiguration":
            return Optional.ofNullable(clazz.cast(connectPeerConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConnectPeer, T> g) {
        return obj -> g.apply((TransitGatewayConnectPeer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayConnectPeer> {
        /**
         * <p>
         * The ID of the Connect attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the Connect attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the Connect peer.
         * </p>
         * 
         * @param transitGatewayConnectPeerId
         *        The ID of the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnectPeerId(String transitGatewayConnectPeerId);

        /**
         * <p>
         * The state of the Connect peer.
         * </p>
         * 
         * @param state
         *        The state of the Connect peer.
         * @see TransitGatewayConnectPeerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayConnectPeerState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Connect peer.
         * </p>
         * 
         * @param state
         *        The state of the Connect peer.
         * @see TransitGatewayConnectPeerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayConnectPeerState
         */
        Builder state(TransitGatewayConnectPeerState state);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Connect peer details.
         * </p>
         * 
         * @param connectPeerConfiguration
         *        The Connect peer details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectPeerConfiguration(TransitGatewayConnectPeerConfiguration connectPeerConfiguration);

        /**
         * <p>
         * The Connect peer details.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayConnectPeerConfiguration.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayConnectPeerConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayConnectPeerConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #connectPeerConfiguration(TransitGatewayConnectPeerConfiguration)}.
         * 
         * @param connectPeerConfiguration
         *        a consumer that will call methods on {@link TransitGatewayConnectPeerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectPeerConfiguration(TransitGatewayConnectPeerConfiguration)
         */
        default Builder connectPeerConfiguration(Consumer<TransitGatewayConnectPeerConfiguration.Builder> connectPeerConfiguration) {
            return connectPeerConfiguration(TransitGatewayConnectPeerConfiguration.builder()
                    .applyMutation(connectPeerConfiguration).build());
        }

        /**
         * <p>
         * The tags for the Connect peer.
         * </p>
         * 
         * @param tags
         *        The tags for the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the Connect peer.
         * </p>
         * 
         * @param tags
         *        The tags for the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the Connect peer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String transitGatewayConnectPeerId;

        private String state;

        private Instant creationTime;

        private TransitGatewayConnectPeerConfiguration connectPeerConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConnectPeer model) {
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            transitGatewayConnectPeerId(model.transitGatewayConnectPeerId);
            state(model.state);
            creationTime(model.creationTime);
            connectPeerConfiguration(model.connectPeerConfiguration);
            tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getTransitGatewayConnectPeerId() {
            return transitGatewayConnectPeerId;
        }

        @Override
        public final Builder transitGatewayConnectPeerId(String transitGatewayConnectPeerId) {
            this.transitGatewayConnectPeerId = transitGatewayConnectPeerId;
            return this;
        }

        public final void setTransitGatewayConnectPeerId(String transitGatewayConnectPeerId) {
            this.transitGatewayConnectPeerId = transitGatewayConnectPeerId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayConnectPeerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final TransitGatewayConnectPeerConfiguration.Builder getConnectPeerConfiguration() {
            return connectPeerConfiguration != null ? connectPeerConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder connectPeerConfiguration(TransitGatewayConnectPeerConfiguration connectPeerConfiguration) {
            this.connectPeerConfiguration = connectPeerConfiguration;
            return this;
        }

        public final void setConnectPeerConfiguration(TransitGatewayConnectPeerConfiguration.BuilderImpl connectPeerConfiguration) {
            this.connectPeerConfiguration = connectPeerConfiguration != null ? connectPeerConfiguration.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public TransitGatewayConnectPeer build() {
            return new TransitGatewayConnectPeer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
