/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform;
import software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.EndDateType;
import software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapacityReservationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateCapacityReservationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::clientToken)).setter(CreateCapacityReservationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::instanceType)).setter(CreateCapacityReservationRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstancePlatform").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::instancePlatformAsString)).setter(CreateCapacityReservationRequest.setter(Builder::instancePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform").unmarshallLocationName("InstancePlatform").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::availabilityZone)).setter(CreateCapacityReservationRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::availabilityZoneId)).setter(CreateCapacityReservationRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::tenancyAsString)).setter(CreateCapacityReservationRequest.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("Tenancy").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::instanceCount)).setter(CreateCapacityReservationRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("InstanceCount").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::ebsOptimized)).setter(CreateCapacityReservationRequest.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("EbsOptimized").build()}).build();
    private static final SdkField<Boolean> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EphemeralStorage").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::ephemeralStorage)).setter(CreateCapacityReservationRequest.setter(Builder::ephemeralStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage").unmarshallLocationName("EphemeralStorage").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::endDate)).setter(CreateCapacityReservationRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("EndDate").build()}).build();
    private static final SdkField<String> END_DATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDateType").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::endDateTypeAsString)).setter(CreateCapacityReservationRequest.setter(Builder::endDateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateType").unmarshallLocationName("EndDateType").build()}).build();
    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMatchCriteria").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::instanceMatchCriteriaAsString)).setter(CreateCapacityReservationRequest.setter(Builder::instanceMatchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria").unmarshallLocationName("InstanceMatchCriteria").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateCapacityReservationRequest.getter(CreateCapacityReservationRequest::tagSpecifications)).setter(CreateCapacityReservationRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecifications").unmarshallLocationName("TagSpecifications").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_PLATFORM_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, TENANCY_FIELD, INSTANCE_COUNT_FIELD, EBS_OPTIMIZED_FIELD, EPHEMERAL_STORAGE_FIELD, END_DATE_FIELD, END_DATE_TYPE_FIELD, INSTANCE_MATCH_CRITERIA_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final String clientToken;
    private final String instanceType;
    private final String instancePlatform;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final String tenancy;
    private final Integer instanceCount;
    private final Boolean ebsOptimized;
    private final Boolean ephemeralStorage;
    private final Instant endDate;
    private final String endDateType;
    private final String instanceMatchCriteria;
    private final List<TagSpecification> tagSpecifications;

    private CreateCapacityReservationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tenancy = builder.tenancy;
        this.instanceCount = builder.instanceCount;
        this.ebsOptimized = builder.ebsOptimized;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.endDate = builder.endDate;
        this.endDateType = builder.endDateType;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(this.instancePlatform);
    }

    public String instancePlatformAsString() {
        return this.instancePlatform;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(this.tenancy);
    }

    public String tenancyAsString() {
        return this.tenancy;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Boolean ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public Instant endDate() {
        return this.endDate;
    }

    public EndDateType endDateType() {
        return EndDateType.fromValue(this.endDateType);
    }

    public String endDateTypeAsString() {
        return this.endDateType;
    }

    public InstanceMatchCriteria instanceMatchCriteria() {
        return InstanceMatchCriteria.fromValue(this.instanceMatchCriteria);
    }

    public String instanceMatchCriteriaAsString() {
        return this.instanceMatchCriteria;
    }

    public boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMatchCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityReservationRequest)) {
            return false;
        }
        CreateCapacityReservationRequest other = (CreateCapacityReservationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instancePlatformAsString(), other.instancePlatformAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.endDateTypeAsString(), other.endDateTypeAsString()) && Objects.equals(this.instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"CreateCapacityReservationRequest").add("ClientToken", (Object)this.clientToken()).add("InstanceType", (Object)this.instanceType()).add("InstancePlatform", (Object)this.instancePlatformAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Tenancy", (Object)this.tenancyAsString()).add("InstanceCount", (Object)this.instanceCount()).add("EbsOptimized", (Object)this.ebsOptimized()).add("EphemeralStorage", (Object)this.ephemeralStorage()).add("EndDate", (Object)this.endDate()).add("EndDateType", (Object)this.endDateTypeAsString()).add("InstanceMatchCriteria", (Object)this.instanceMatchCriteriaAsString()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstancePlatform": {
                return Optional.ofNullable(clazz.cast(this.instancePlatformAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "EphemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "EndDateType": {
                return Optional.ofNullable(clazz.cast(this.endDateTypeAsString()));
            }
            case "InstanceMatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.instanceMatchCriteriaAsString()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityReservationRequest, T> g) {
        return obj -> g.apply((CreateCapacityReservationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private String instanceType;
        private String instancePlatform;
        private String availabilityZone;
        private String availabilityZoneId;
        private String tenancy;
        private Integer instanceCount;
        private Boolean ebsOptimized;
        private Boolean ephemeralStorage;
        private Instant endDate;
        private String endDateType;
        private String instanceMatchCriteria;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityReservationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.instanceType(model.instanceType);
            this.instancePlatform(model.instancePlatform);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.tenancy(model.tenancy);
            this.instanceCount(model.instanceCount);
            this.ebsOptimized(model.ebsOptimized);
            this.ephemeralStorage(model.ephemeralStorage);
            this.endDate(model.endDate);
            this.endDateType(model.endDateType);
            this.instanceMatchCriteria(model.instanceMatchCriteria);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getInstancePlatform() {
            return this.instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEphemeralStorage() {
            return this.ephemeralStorage;
        }

        @Override
        public final Builder ephemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final void setEphemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final String getEndDateType() {
            return this.endDateType;
        }

        @Override
        public final Builder endDateType(String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        @Override
        public final Builder endDateType(EndDateType endDateType) {
            this.endDateType(endDateType == null ? null : endDateType.toString());
            return this;
        }

        public final void setEndDateType(String endDateType) {
            this.endDateType = endDateType;
        }

        public final String getInstanceMatchCriteria() {
            return this.instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            if (this.tagSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(TagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapacityReservationRequest build() {
            return new CreateCapacityReservationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapacityReservationRequest> {
        public Builder clientToken(String var1);

        public Builder instanceType(String var1);

        public Builder instancePlatform(String var1);

        public Builder instancePlatform(CapacityReservationInstancePlatform var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(CapacityReservationTenancy var1);

        public Builder instanceCount(Integer var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder ephemeralStorage(Boolean var1);

        public Builder endDate(Instant var1);

        public Builder endDateType(String var1);

        public Builder endDateType(EndDateType var1);

        public Builder instanceMatchCriteria(String var1);

        public Builder instanceMatchCriteria(InstanceMatchCriteria var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

