/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignPrivateIpAddressesResponse extends Ec2Response implements
        ToCopyableBuilder<AssignPrivateIpAddressesResponse.Builder, AssignPrivateIpAddressesResponse> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AssignPrivateIpAddressesResponse::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<List<AssignedPrivateIpAddress>> ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<AssignedPrivateIpAddress>> builder(MarshallingType.LIST)
            .memberName("AssignedPrivateIpAddresses")
            .getter(getter(AssignPrivateIpAddressesResponse::assignedPrivateIpAddresses))
            .setter(setter(Builder::assignedPrivateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedPrivateIpAddressesSet")
                    .unmarshallLocationName("assignedPrivateIpAddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AssignedPrivateIpAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssignedPrivateIpAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD,
            ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD));

    private final String networkInterfaceId;

    private final List<AssignedPrivateIpAddress> assignedPrivateIpAddresses;

    private AssignPrivateIpAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.assignedPrivateIpAddresses = builder.assignedPrivateIpAddresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * Returns true if the AssignedPrivateIpAddresses property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasAssignedPrivateIpAddresses() {
        return assignedPrivateIpAddresses != null && !(assignedPrivateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private IP addresses assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssignedPrivateIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The private IP addresses assigned to the network interface.
     */
    public final List<AssignedPrivateIpAddress> assignedPrivateIpAddresses() {
        return assignedPrivateIpAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssignedPrivateIpAddresses() ? assignedPrivateIpAddresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesResponse)) {
            return false;
        }
        AssignPrivateIpAddressesResponse other = (AssignPrivateIpAddressesResponse) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && hasAssignedPrivateIpAddresses() == other.hasAssignedPrivateIpAddresses()
                && Objects.equals(assignedPrivateIpAddresses(), other.assignedPrivateIpAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignPrivateIpAddressesResponse").add("NetworkInterfaceId", networkInterfaceId())
                .add("AssignedPrivateIpAddresses", hasAssignedPrivateIpAddresses() ? assignedPrivateIpAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "AssignedPrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(assignedPrivateIpAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignPrivateIpAddressesResponse, T> g) {
        return obj -> g.apply((AssignPrivateIpAddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AssignPrivateIpAddressesResponse> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The private IP addresses assigned to the network interface.
         * </p>
         * 
         * @param assignedPrivateIpAddresses
         *        The private IP addresses assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress> assignedPrivateIpAddresses);

        /**
         * <p>
         * The private IP addresses assigned to the network interface.
         * </p>
         * 
         * @param assignedPrivateIpAddresses
         *        The private IP addresses assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedPrivateIpAddresses(AssignedPrivateIpAddress... assignedPrivateIpAddresses);

        /**
         * <p>
         * The private IP addresses assigned to the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssignedPrivateIpAddress>.Builder} avoiding
         * the need to create one manually via {@link List<AssignedPrivateIpAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssignedPrivateIpAddress>.Builder#build()} is called
         * immediately and its result is passed to {@link #assignedPrivateIpAddresses(List<AssignedPrivateIpAddress>)}.
         * 
         * @param assignedPrivateIpAddresses
         *        a consumer that will call methods on {@link List<AssignedPrivateIpAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignedPrivateIpAddresses(List<AssignedPrivateIpAddress>)
         */
        Builder assignedPrivateIpAddresses(Consumer<AssignedPrivateIpAddress.Builder>... assignedPrivateIpAddresses);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String networkInterfaceId;

        private List<AssignedPrivateIpAddress> assignedPrivateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesResponse model) {
            super(model);
            networkInterfaceId(model.networkInterfaceId);
            assignedPrivateIpAddresses(model.assignedPrivateIpAddresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<AssignedPrivateIpAddress.Builder> getAssignedPrivateIpAddresses() {
            if (assignedPrivateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return assignedPrivateIpAddresses != null ? assignedPrivateIpAddresses.stream()
                    .map(AssignedPrivateIpAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress> assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses = AssignedPrivateIpAddressListCopier.copy(assignedPrivateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedPrivateIpAddresses(AssignedPrivateIpAddress... assignedPrivateIpAddresses) {
            assignedPrivateIpAddresses(Arrays.asList(assignedPrivateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedPrivateIpAddresses(Consumer<AssignedPrivateIpAddress.Builder>... assignedPrivateIpAddresses) {
            assignedPrivateIpAddresses(Stream.of(assignedPrivateIpAddresses)
                    .map(c -> AssignedPrivateIpAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssignedPrivateIpAddresses(
                Collection<AssignedPrivateIpAddress.BuilderImpl> assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses = AssignedPrivateIpAddressListCopier.copyFromBuilder(assignedPrivateIpAddresses);
        }

        @Override
        public AssignPrivateIpAddressesResponse build() {
            return new AssignPrivateIpAddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
