/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceTypeOfferingsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeInstanceTypeOfferingsRequest.Builder, DescribeInstanceTypeOfferingsRequest> {
    private static final SdkField<String> LOCATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocationType")
            .getter(getter(DescribeInstanceTypeOfferingsRequest::locationTypeAsString))
            .setter(setter(Builder::locationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationType")
                    .unmarshallLocationName("LocationType").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeInstanceTypeOfferingsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeInstanceTypeOfferingsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeInstanceTypeOfferingsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_TYPE_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String locationType;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeInstanceTypeOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.locationType = builder.locationType;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The location type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationType} will
     * return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationTypeAsString}.
     * </p>
     * 
     * @return The location type.
     * @see LocationType
     */
    public final LocationType locationType() {
        return LocationType.fromValue(locationType);
    }

    /**
     * <p>
     * The location type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationType} will
     * return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationTypeAsString}.
     * </p>
     * 
     * @return The location type.
     * @see LocationType
     */
    public final String locationTypeAsString() {
        return locationType;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>location</code> - This depends on the location type. For example, if the location type is
     * <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters. Filter names and values are case-sensitive.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>location</code> - This depends on the location type. For example, if the location type is
     *         <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the next token value.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the next token value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceTypeOfferingsRequest)) {
            return false;
        }
        DescribeInstanceTypeOfferingsRequest other = (DescribeInstanceTypeOfferingsRequest) obj;
        return Objects.equals(locationTypeAsString(), other.locationTypeAsString()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceTypeOfferingsRequest").add("LocationType", locationTypeAsString())
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationType":
            return Optional.ofNullable(clazz.cast(locationTypeAsString()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceTypeOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeInstanceTypeOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceTypeOfferingsRequest> {
        /**
         * <p>
         * The location type.
         * </p>
         * 
         * @param locationType
         *        The location type.
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder locationType(String locationType);

        /**
         * <p>
         * The location type.
         * </p>
         * 
         * @param locationType
         *        The location type.
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder locationType(LocationType locationType);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>location</code> - This depends on the location type. For example, if the location type is
         * <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>location</code> - This depends on the location type. For example, if the location type is
         *        <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>location</code> - This depends on the location type. For example, if the location type is
         * <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>location</code> - This depends on the location type. For example, if the location type is
         *        <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>location</code> - This depends on the location type. For example, if the location type is
         * <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the next token value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the next token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String locationType;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceTypeOfferingsRequest model) {
            super(model);
            locationType(model.locationType);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getLocationType() {
            return locationType;
        }

        @Override
        public final Builder locationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        @Override
        public final Builder locationType(LocationType locationType) {
            this.locationType(locationType == null ? null : locationType.toString());
            return this;
        }

        public final void setLocationType(String locationType) {
            this.locationType = locationType;
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstanceTypeOfferingsRequest build() {
            return new DescribeInstanceTypeOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
