/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for PurchaseScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseScheduledInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<PurchaseScheduledInstancesRequest.Builder, PurchaseScheduledInstancesRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(PurchaseScheduledInstancesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<PurchaseRequest>> PURCHASE_REQUESTS_FIELD = SdkField
            .<List<PurchaseRequest>> builder(MarshallingType.LIST)
            .memberName("PurchaseRequests")
            .getter(getter(PurchaseScheduledInstancesRequest::purchaseRequests))
            .setter(setter(Builder::purchaseRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseRequest")
                    .unmarshallLocationName("PurchaseRequest").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PurchaseRequest")
                            .memberFieldInfo(
                                    SdkField.<PurchaseRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PurchaseRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PurchaseRequest").unmarshallLocationName("PurchaseRequest")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            PURCHASE_REQUESTS_FIELD));

    private final String clientToken;

    private final List<PurchaseRequest> purchaseRequests;

    private PurchaseScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.purchaseRequests = builder.purchaseRequests;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the PurchaseRequests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPurchaseRequests() {
        return purchaseRequests != null && !(purchaseRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The purchase requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPurchaseRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The purchase requests.
     */
    public final List<PurchaseRequest> purchaseRequests() {
        return purchaseRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPurchaseRequests() ? purchaseRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && hasPurchaseRequests() == other.hasPurchaseRequests()
                && Objects.equals(purchaseRequests(), other.purchaseRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseScheduledInstancesRequest").add("ClientToken", clientToken())
                .add("PurchaseRequests", hasPurchaseRequests() ? purchaseRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "PurchaseRequests":
            return Optional.ofNullable(clazz.cast(purchaseRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseScheduledInstancesRequest, T> g) {
        return obj -> g.apply((PurchaseScheduledInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that ensures the idempotency of the request. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The purchase requests.
         * </p>
         * 
         * @param purchaseRequests
         *        The purchase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests);

        /**
         * <p>
         * The purchase requests.
         * </p>
         * 
         * @param purchaseRequests
         *        The purchase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseRequests(PurchaseRequest... purchaseRequests);

        /**
         * <p>
         * The purchase requests.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PurchaseRequest>.Builder} avoiding the need
         * to create one manually via {@link List<PurchaseRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PurchaseRequest>.Builder#build()} is called immediately and
         * its result is passed to {@link #purchaseRequests(List<PurchaseRequest>)}.
         * 
         * @param purchaseRequests
         *        a consumer that will call methods on {@link List<PurchaseRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #purchaseRequests(List<PurchaseRequest>)
         */
        Builder purchaseRequests(Consumer<PurchaseRequest.Builder>... purchaseRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private List<PurchaseRequest> purchaseRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesRequest model) {
            super(model);
            clientToken(model.clientToken);
            purchaseRequests(model.purchaseRequests);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<PurchaseRequest.Builder> getPurchaseRequests() {
            if (purchaseRequests instanceof SdkAutoConstructList) {
                return null;
            }
            return purchaseRequests != null ? purchaseRequests.stream().map(PurchaseRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copy(purchaseRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(PurchaseRequest... purchaseRequests) {
            purchaseRequests(Arrays.asList(purchaseRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(Consumer<PurchaseRequest.Builder>... purchaseRequests) {
            purchaseRequests(Stream.of(purchaseRequests).map(c -> PurchaseRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPurchaseRequests(Collection<PurchaseRequest.BuilderImpl> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copyFromBuilder(purchaseRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseScheduledInstancesRequest build() {
            return new PurchaseScheduledInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
