/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.UserBucket;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageDiskContainer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageDiskContainer> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImageDiskContainer.getter(ImageDiskContainer::description)).setter(ImageDiskContainer.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(ImageDiskContainer.getter(ImageDiskContainer::deviceName)).setter(ImageDiskContainer.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").unmarshallLocationName("DeviceName").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(ImageDiskContainer.getter(ImageDiskContainer::format)).setter(ImageDiskContainer.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("Format").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(ImageDiskContainer.getter(ImageDiskContainer::snapshotId)).setter(ImageDiskContainer.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(ImageDiskContainer.getter(ImageDiskContainer::url)).setter(ImageDiskContainer.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").unmarshallLocationName("Url").build()}).build();
    private static final SdkField<UserBucket> USER_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserBucket").getter(ImageDiskContainer.getter(ImageDiskContainer::userBucket)).setter(ImageDiskContainer.setter(Builder::userBucket)).constructor(UserBucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBucket").unmarshallLocationName("UserBucket").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DEVICE_NAME_FIELD, FORMAT_FIELD, SNAPSHOT_ID_FIELD, URL_FIELD, USER_BUCKET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String deviceName;
    private final String format;
    private final String snapshotId;
    private final String url;
    private final UserBucket userBucket;

    private ImageDiskContainer(BuilderImpl builder) {
        this.description = builder.description;
        this.deviceName = builder.deviceName;
        this.format = builder.format;
        this.snapshotId = builder.snapshotId;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    public final String description() {
        return this.description;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final String format() {
        return this.format;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String url() {
        return this.url;
    }

    public final UserBucket userBucket() {
        return this.userBucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.userBucket());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDiskContainer)) {
            return false;
        }
        ImageDiskContainer other = (ImageDiskContainer)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.userBucket(), other.userBucket());
    }

    public final String toString() {
        return ToString.builder((String)"ImageDiskContainer").add("Description", (Object)this.description()).add("DeviceName", (Object)this.deviceName()).add("Format", (Object)this.format()).add("SnapshotId", (Object)this.snapshotId()).add("Url", (Object)this.url()).add("UserBucket", (Object)this.userBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "UserBucket": {
                return Optional.ofNullable(clazz.cast(this.userBucket()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageDiskContainer, T> g) {
        return obj -> g.apply((ImageDiskContainer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String deviceName;
        private String format;
        private String snapshotId;
        private String url;
        private UserBucket userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDiskContainer model) {
            this.description(model.description);
            this.deviceName(model.deviceName);
            this.format(model.format);
            this.snapshotId(model.snapshotId);
            this.url(model.url);
            this.userBucket(model.userBucket);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucket.Builder getUserBucket() {
            return this.userBucket != null ? this.userBucket.toBuilder() : null;
        }

        @Override
        public final Builder userBucket(UserBucket userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucket.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        public ImageDiskContainer build() {
            return new ImageDiskContainer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageDiskContainer> {
        public Builder description(String var1);

        public Builder deviceName(String var1);

        public Builder format(String var1);

        public Builder snapshotId(String var1);

        public Builder url(String var1);

        public Builder userBucket(UserBucket var1);

        default public Builder userBucket(Consumer<UserBucket.Builder> userBucket) {
            return this.userBucket((UserBucket)((UserBucket.Builder)UserBucket.builder().applyMutation(userBucket)).build());
        }
    }
}

