/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion;
import software.amazon.awssdk.services.ec2.model.VpnTunnelOptionsSpecification;
import software.amazon.awssdk.services.ec2.model.VpnTunnelOptionsSpecificationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpnConnectionOptionsSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
    private static final SdkField<Boolean> ENABLE_ACCELERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableAcceleration").getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::enableAcceleration)).setter(VpnConnectionOptionsSpecification.setter(Builder::enableAcceleration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAcceleration").unmarshallLocationName("EnableAcceleration").build()}).build();
    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StaticRoutesOnly").getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::staticRoutesOnly)).setter(VpnConnectionOptionsSpecification.setter(Builder::staticRoutesOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly").unmarshallLocationName("staticRoutesOnly").build()}).build();
    private static final SdkField<String> TUNNEL_INSIDE_IP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelInsideIpVersion").getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::tunnelInsideIpVersionAsString)).setter(VpnConnectionOptionsSpecification.setter(Builder::tunnelInsideIpVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideIpVersion").unmarshallLocationName("TunnelInsideIpVersion").build()}).build();
    private static final SdkField<List<VpnTunnelOptionsSpecification>> TUNNEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TunnelOptions").getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::tunnelOptions)).setter(VpnConnectionOptionsSpecification.setter(Builder::tunnelOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptions").unmarshallLocationName("TunnelOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpnTunnelOptionsSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCAL_IPV4_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalIpv4NetworkCidr").getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::localIpv4NetworkCidr)).setter(VpnConnectionOptionsSpecification.setter(Builder::localIpv4NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv4NetworkCidr").unmarshallLocationName("LocalIpv4NetworkCidr").build()}).build();
    private static final SdkField<String> REMOTE_IPV4_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteIpv4NetworkCidr").getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::remoteIpv4NetworkCidr)).setter(VpnConnectionOptionsSpecification.setter(Builder::remoteIpv4NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv4NetworkCidr").unmarshallLocationName("RemoteIpv4NetworkCidr").build()}).build();
    private static final SdkField<String> LOCAL_IPV6_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalIpv6NetworkCidr").getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::localIpv6NetworkCidr)).setter(VpnConnectionOptionsSpecification.setter(Builder::localIpv6NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv6NetworkCidr").unmarshallLocationName("LocalIpv6NetworkCidr").build()}).build();
    private static final SdkField<String> REMOTE_IPV6_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteIpv6NetworkCidr").getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::remoteIpv6NetworkCidr)).setter(VpnConnectionOptionsSpecification.setter(Builder::remoteIpv6NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv6NetworkCidr").unmarshallLocationName("RemoteIpv6NetworkCidr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ACCELERATION_FIELD, STATIC_ROUTES_ONLY_FIELD, TUNNEL_INSIDE_IP_VERSION_FIELD, TUNNEL_OPTIONS_FIELD, LOCAL_IPV4_NETWORK_CIDR_FIELD, REMOTE_IPV4_NETWORK_CIDR_FIELD, LOCAL_IPV6_NETWORK_CIDR_FIELD, REMOTE_IPV6_NETWORK_CIDR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enableAcceleration;
    private final Boolean staticRoutesOnly;
    private final String tunnelInsideIpVersion;
    private final List<VpnTunnelOptionsSpecification> tunnelOptions;
    private final String localIpv4NetworkCidr;
    private final String remoteIpv4NetworkCidr;
    private final String localIpv6NetworkCidr;
    private final String remoteIpv6NetworkCidr;

    private VpnConnectionOptionsSpecification(BuilderImpl builder) {
        this.enableAcceleration = builder.enableAcceleration;
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelInsideIpVersion = builder.tunnelInsideIpVersion;
        this.tunnelOptions = builder.tunnelOptions;
        this.localIpv4NetworkCidr = builder.localIpv4NetworkCidr;
        this.remoteIpv4NetworkCidr = builder.remoteIpv4NetworkCidr;
        this.localIpv6NetworkCidr = builder.localIpv6NetworkCidr;
        this.remoteIpv6NetworkCidr = builder.remoteIpv6NetworkCidr;
    }

    public final Boolean enableAcceleration() {
        return this.enableAcceleration;
    }

    public final Boolean staticRoutesOnly() {
        return this.staticRoutesOnly;
    }

    public final TunnelInsideIpVersion tunnelInsideIpVersion() {
        return TunnelInsideIpVersion.fromValue(this.tunnelInsideIpVersion);
    }

    public final String tunnelInsideIpVersionAsString() {
        return this.tunnelInsideIpVersion;
    }

    public final boolean hasTunnelOptions() {
        return this.tunnelOptions != null && !(this.tunnelOptions instanceof SdkAutoConstructList);
    }

    public final List<VpnTunnelOptionsSpecification> tunnelOptions() {
        return this.tunnelOptions;
    }

    public final String localIpv4NetworkCidr() {
        return this.localIpv4NetworkCidr;
    }

    public final String remoteIpv4NetworkCidr() {
        return this.remoteIpv4NetworkCidr;
    }

    public final String localIpv6NetworkCidr() {
        return this.localIpv6NetworkCidr;
    }

    public final String remoteIpv6NetworkCidr() {
        return this.remoteIpv6NetworkCidr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAcceleration());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelInsideIpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTunnelOptions() ? this.tunnelOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.localIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.localIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpv6NetworkCidr());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptionsSpecification)) {
            return false;
        }
        VpnConnectionOptionsSpecification other = (VpnConnectionOptionsSpecification)obj;
        return Objects.equals(this.enableAcceleration(), other.enableAcceleration()) && Objects.equals(this.staticRoutesOnly(), other.staticRoutesOnly()) && Objects.equals(this.tunnelInsideIpVersionAsString(), other.tunnelInsideIpVersionAsString()) && this.hasTunnelOptions() == other.hasTunnelOptions() && Objects.equals(this.tunnelOptions(), other.tunnelOptions()) && Objects.equals(this.localIpv4NetworkCidr(), other.localIpv4NetworkCidr()) && Objects.equals(this.remoteIpv4NetworkCidr(), other.remoteIpv4NetworkCidr()) && Objects.equals(this.localIpv6NetworkCidr(), other.localIpv6NetworkCidr()) && Objects.equals(this.remoteIpv6NetworkCidr(), other.remoteIpv6NetworkCidr());
    }

    public final String toString() {
        return ToString.builder((String)"VpnConnectionOptionsSpecification").add("EnableAcceleration", (Object)this.enableAcceleration()).add("StaticRoutesOnly", (Object)this.staticRoutesOnly()).add("TunnelInsideIpVersion", (Object)this.tunnelInsideIpVersionAsString()).add("TunnelOptions", this.hasTunnelOptions() ? this.tunnelOptions() : null).add("LocalIpv4NetworkCidr", (Object)this.localIpv4NetworkCidr()).add("RemoteIpv4NetworkCidr", (Object)this.remoteIpv4NetworkCidr()).add("LocalIpv6NetworkCidr", (Object)this.localIpv6NetworkCidr()).add("RemoteIpv6NetworkCidr", (Object)this.remoteIpv6NetworkCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableAcceleration": {
                return Optional.ofNullable(clazz.cast(this.enableAcceleration()));
            }
            case "StaticRoutesOnly": {
                return Optional.ofNullable(clazz.cast(this.staticRoutesOnly()));
            }
            case "TunnelInsideIpVersion": {
                return Optional.ofNullable(clazz.cast(this.tunnelInsideIpVersionAsString()));
            }
            case "TunnelOptions": {
                return Optional.ofNullable(clazz.cast(this.tunnelOptions()));
            }
            case "LocalIpv4NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.localIpv4NetworkCidr()));
            }
            case "RemoteIpv4NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.remoteIpv4NetworkCidr()));
            }
            case "LocalIpv6NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.localIpv6NetworkCidr()));
            }
            case "RemoteIpv6NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.remoteIpv6NetworkCidr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnConnectionOptionsSpecification, T> g) {
        return obj -> g.apply((VpnConnectionOptionsSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableAcceleration;
        private Boolean staticRoutesOnly;
        private String tunnelInsideIpVersion;
        private List<VpnTunnelOptionsSpecification> tunnelOptions = DefaultSdkAutoConstructList.getInstance();
        private String localIpv4NetworkCidr;
        private String remoteIpv4NetworkCidr;
        private String localIpv6NetworkCidr;
        private String remoteIpv6NetworkCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptionsSpecification model) {
            this.enableAcceleration(model.enableAcceleration);
            this.staticRoutesOnly(model.staticRoutesOnly);
            this.tunnelInsideIpVersion(model.tunnelInsideIpVersion);
            this.tunnelOptions(model.tunnelOptions);
            this.localIpv4NetworkCidr(model.localIpv4NetworkCidr);
            this.remoteIpv4NetworkCidr(model.remoteIpv4NetworkCidr);
            this.localIpv6NetworkCidr(model.localIpv6NetworkCidr);
            this.remoteIpv6NetworkCidr(model.remoteIpv6NetworkCidr);
        }

        public final Boolean getEnableAcceleration() {
            return this.enableAcceleration;
        }

        @Override
        public final Builder enableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
            return this;
        }

        public final void setEnableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
        }

        public final Boolean getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        public final String getTunnelInsideIpVersion() {
            return this.tunnelInsideIpVersion;
        }

        @Override
        public final Builder tunnelInsideIpVersion(String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
            return this;
        }

        @Override
        public final Builder tunnelInsideIpVersion(TunnelInsideIpVersion tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion(tunnelInsideIpVersion == null ? null : tunnelInsideIpVersion.toString());
            return this;
        }

        public final void setTunnelInsideIpVersion(String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
        }

        public final Collection<VpnTunnelOptionsSpecification.Builder> getTunnelOptions() {
            if (this.tunnelOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tunnelOptions != null ? (Collection)this.tunnelOptions.stream().map(VpnTunnelOptionsSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions) {
            this.tunnelOptions = VpnTunnelOptionsSpecificationsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(VpnTunnelOptionsSpecification ... tunnelOptions) {
            this.tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<VpnTunnelOptionsSpecification.Builder> ... tunnelOptions) {
            this.tunnelOptions(Stream.of(tunnelOptions).map(c -> (VpnTunnelOptionsSpecification)((VpnTunnelOptionsSpecification.Builder)VpnTunnelOptionsSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTunnelOptions(Collection<VpnTunnelOptionsSpecification.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = VpnTunnelOptionsSpecificationsListCopier.copyFromBuilder(tunnelOptions);
        }

        public final String getLocalIpv4NetworkCidr() {
            return this.localIpv4NetworkCidr;
        }

        @Override
        public final Builder localIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
            return this;
        }

        public final void setLocalIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
        }

        public final String getRemoteIpv4NetworkCidr() {
            return this.remoteIpv4NetworkCidr;
        }

        @Override
        public final Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
            return this;
        }

        public final void setRemoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
        }

        public final String getLocalIpv6NetworkCidr() {
            return this.localIpv6NetworkCidr;
        }

        @Override
        public final Builder localIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
            return this;
        }

        public final void setLocalIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
        }

        public final String getRemoteIpv6NetworkCidr() {
            return this.remoteIpv6NetworkCidr;
        }

        @Override
        public final Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
            return this;
        }

        public final void setRemoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
        }

        public VpnConnectionOptionsSpecification build() {
            return new VpnConnectionOptionsSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
        public Builder enableAcceleration(Boolean var1);

        public Builder staticRoutesOnly(Boolean var1);

        public Builder tunnelInsideIpVersion(String var1);

        public Builder tunnelInsideIpVersion(TunnelInsideIpVersion var1);

        public Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> var1);

        public Builder tunnelOptions(VpnTunnelOptionsSpecification ... var1);

        public Builder tunnelOptions(Consumer<VpnTunnelOptionsSpecification.Builder> ... var1);

        public Builder localIpv4NetworkCidr(String var1);

        public Builder remoteIpv4NetworkCidr(String var1);

        public Builder localIpv6NetworkCidr(String var1);

        public Builder remoteIpv6NetworkCidr(String var1);
    }
}

