/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecurityGroupsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeSecurityGroupsRequest.Builder, DescribeSecurityGroupsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeSecurityGroupsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupIds")
            .getter(getter(DescribeSecurityGroupsRequest::groupIds))
            .setter(setter(Builder::groupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("GroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("groupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GroupId").unmarshallLocationName("groupId").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupNames")
            .getter(getter(DescribeSecurityGroupsRequest::groupNames))
            .setter(setter(Builder::groupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("GroupName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GroupName").unmarshallLocationName("GroupName").build())
                                            .build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSecurityGroupsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeSecurityGroupsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            GROUP_IDS_FIELD, GROUP_NAMES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<Filter> filters;

    private final List<String> groupIds;

    private final List<String> groupNames;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeSecurityGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.groupIds = builder.groupIds;
        this.groupNames = builder.groupNames;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters. If using multiple filters for rules, the results include security groups for which any combination
     * of rules - not necessarily a single rule - match all filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>description</code> - The description of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and UDP
     * protocols, or an ICMP type number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an outbound
     * security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in an
     * outbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule allows
     * outbound access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
     * <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP
     * protocols, or an ICMP code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an outbound
     * security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-name</code> - The name of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
     * protocols, or an ICMP type number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound security
     * group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an inbound
     * security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule allows
     * inbound access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> |
     * <code>udp</code> | <code>icmp</code> or a protocol number).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP protocols, or
     * an ICMP code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound security
     * group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the owner of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters. If using multiple filters for rules, the results include security groups for which any
     *         combination of rules - not necessarily a single rule - match all filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>description</code> - The description of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP
     *         and UDP protocols, or an ICMP type number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
     *         outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in
     *         an outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule
     *         allows outbound access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
     *         <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and
     *         UDP protocols, or an ICMP code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an
     *         outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
     *         protocols, or an ICMP type number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound
     *         security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an
     *         inbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule
     *         allows inbound access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (
     *         <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
     *         protocols, or an ICMP code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound
     *         security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the owner of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * Returns true if the GroupIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroupIds() {
        return groupIds != null && !(groupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups. Required for security groups in a nondefault VPC.
     * </p>
     * <p>
     * Default: Describes all your security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the security groups. Required for security groups in a nondefault VPC.</p>
     *         <p>
     *         Default: Describes all your security groups.
     */
    public final List<String> groupIds() {
        return groupIds;
    }

    /**
     * Returns true if the GroupNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroupNames() {
        return groupNames != null && !(groupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [EC2-Classic and default VPC only] The names of the security groups. You can specify either the security group
     * name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code> filter to
     * describe security groups by name.
     * </p>
     * <p>
     * Default: Describes all your security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [EC2-Classic and default VPC only] The names of the security groups. You can specify either the security
     *         group name or the security group ID. For security groups in a nondefault VPC, use the
     *         <code>group-name</code> filter to describe security groups by name.</p>
     *         <p>
     *         Default: Describes all your security groups.
     */
    public final List<String> groupNames() {
        return groupNames;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another request
     * with the returned <code>NextToken</code> value. This value can be between 5 and 1000. If this parameter is not
     * specified, then all results are returned.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         request with the returned <code>NextToken</code> value. This value can be between 5 and 1000. If this
     *         parameter is not specified, then all results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupIds() ? groupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupNames() ? groupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsRequest)) {
            return false;
        }
        DescribeSecurityGroupsRequest other = (DescribeSecurityGroupsRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasGroupIds() == other.hasGroupIds() && Objects.equals(groupIds(), other.groupIds())
                && hasGroupNames() == other.hasGroupNames() && Objects.equals(groupNames(), other.groupNames())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSecurityGroupsRequest").add("Filters", hasFilters() ? filters() : null)
                .add("GroupIds", hasGroupIds() ? groupIds() : null).add("GroupNames", hasGroupNames() ? groupNames() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "GroupIds":
            return Optional.ofNullable(clazz.cast(groupIds()));
        case "GroupNames":
            return Optional.ofNullable(clazz.cast(groupNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityGroupsRequest, T> g) {
        return obj -> g.apply((DescribeSecurityGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSecurityGroupsRequest> {
        /**
         * <p>
         * The filters. If using multiple filters for rules, the results include security groups for which any
         * combination of rules - not necessarily a single rule - match all filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - The description of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and
         * UDP protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule
         * allows outbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         * <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an outbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
         * protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule allows
         * inbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> |
         * <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound security
         * group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the owner of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters. If using multiple filters for rules, the results include security groups for which any
         *        combination of rules - not necessarily a single rule - match all filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the
         *        TCP and UDP protocols, or an ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         *        outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced
         *        in an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group
         *        rule allows outbound access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         *        <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP
         *        and UDP protocols, or an ICMP code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an
         *        outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and
         *        UDP protocols, or an ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         *        inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an
         *        inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule
         *        allows inbound access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (
         *        <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         *        protocols, or an ICMP code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound
         *        security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the owner of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters. If using multiple filters for rules, the results include security groups for which any
         * combination of rules - not necessarily a single rule - match all filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - The description of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and
         * UDP protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule
         * allows outbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         * <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an outbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
         * protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule allows
         * inbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> |
         * <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound security
         * group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the owner of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters. If using multiple filters for rules, the results include security groups for which any
         *        combination of rules - not necessarily a single rule - match all filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the
         *        TCP and UDP protocols, or an ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         *        outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced
         *        in an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group
         *        rule allows outbound access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         *        <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP
         *        and UDP protocols, or an ICMP code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an
         *        outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and
         *        UDP protocols, or an ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         *        inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an
         *        inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule
         *        allows inbound access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (
         *        <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         *        protocols, or an ICMP code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound
         *        security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the owner of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters. If using multiple filters for rules, the results include security groups for which any
         * combination of rules - not necessarily a single rule - match all filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - The description of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and
         * UDP protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule
         * allows outbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         * <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an outbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
         * protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule allows
         * inbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> |
         * <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound security
         * group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the owner of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The IDs of the security groups. Required for security groups in a nondefault VPC.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupIds
         *        The IDs of the security groups. Required for security groups in a nondefault VPC.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(Collection<String> groupIds);

        /**
         * <p>
         * The IDs of the security groups. Required for security groups in a nondefault VPC.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupIds
         *        The IDs of the security groups. Required for security groups in a nondefault VPC.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(String... groupIds);

        /**
         * <p>
         * [EC2-Classic and default VPC only] The names of the security groups. You can specify either the security
         * group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code>
         * filter to describe security groups by name.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupNames
         *        [EC2-Classic and default VPC only] The names of the security groups. You can specify either the
         *        security group name or the security group ID. For security groups in a nondefault VPC, use the
         *        <code>group-name</code> filter to describe security groups by name.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * [EC2-Classic and default VPC only] The names of the security groups. You can specify either the security
         * group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code>
         * filter to describe security groups by name.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupNames
         *        [EC2-Classic and default VPC only] The names of the security groups. You can specify either the
         *        security group name or the security group ID. For security groups in a nondefault VPC, use the
         *        <code>group-name</code> filter to describe security groups by name.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * request with the returned <code>NextToken</code> value. This value can be between 5 and 1000. If this
         * parameter is not specified, then all results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         *        If this parameter is not specified, then all results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> groupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> groupNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupsRequest model) {
            super(model);
            filters(model.filters);
            groupIds(model.groupIds);
            groupNames(model.groupNames);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getGroupIds() {
            if (groupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String... groupIds) {
            groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdStringListCopier.copy(groupIds);
        }

        public final Collection<String> getGroupNames() {
            if (groupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSecurityGroupsRequest build() {
            return new DescribeSecurityGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
