/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceStatusSummary.Builder, InstanceStatusSummary> {
    private static final SdkField<List<InstanceStatusDetails>> DETAILS_FIELD = SdkField
            .<List<InstanceStatusDetails>> builder(MarshallingType.LIST)
            .memberName("Details")
            .getter(getter(InstanceStatusSummary::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details")
                    .unmarshallLocationName("details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStatusDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStatusDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(InstanceStatusSummary::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InstanceStatusDetails> details;

    private final String status;

    private InstanceStatusSummary(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    /**
     * Returns true if the Details property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The system instance health or application instance health.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The system instance health or application instance health.
     */
    public final List<InstanceStatusDetails> details() {
        return details;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SummaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see SummaryStatus
     */
    public final SummaryStatus status() {
        return SummaryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SummaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see SummaryStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusSummary)) {
            return false;
        }
        InstanceStatusSummary other = (InstanceStatusSummary) obj;
        return hasDetails() == other.hasDetails() && Objects.equals(details(), other.details())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceStatusSummary").add("Details", hasDetails() ? details() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatusSummary, T> g) {
        return obj -> g.apply((InstanceStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceStatusSummary> {
        /**
         * <p>
         * The system instance health or application instance health.
         * </p>
         * 
         * @param details
         *        The system instance health or application instance health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<InstanceStatusDetails> details);

        /**
         * <p>
         * The system instance health or application instance health.
         * </p>
         * 
         * @param details
         *        The system instance health or application instance health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(InstanceStatusDetails... details);

        /**
         * <p>
         * The system instance health or application instance health.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStatusDetails>.Builder} avoiding
         * the need to create one manually via {@link List<InstanceStatusDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStatusDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link #details(List<InstanceStatusDetails>)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link List<InstanceStatusDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(List<InstanceStatusDetails>)
         */
        Builder details(Consumer<InstanceStatusDetails.Builder>... details);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryStatus
         */
        Builder status(SummaryStatus status);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceStatusDetails> details = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusSummary model) {
            details(model.details);
            status(model.status);
        }

        public final Collection<InstanceStatusDetails.Builder> getDetails() {
            if (details instanceof SdkAutoConstructList) {
                return null;
            }
            return details != null ? details.stream().map(InstanceStatusDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<InstanceStatusDetails> details) {
            this.details = InstanceStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(InstanceStatusDetails... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<InstanceStatusDetails.Builder>... details) {
            details(Stream.of(details).map(c -> InstanceStatusDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDetails(Collection<InstanceStatusDetails.BuilderImpl> details) {
            this.details = InstanceStatusDetailsListCopier.copyFromBuilder(details);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SummaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public InstanceStatusSummary build() {
            return new InstanceStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
