/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayPropagation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayPropagation> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayPropagation.getter(TransitGatewayPropagation::transitGatewayAttachmentId)).setter(TransitGatewayPropagation.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(TransitGatewayPropagation.getter(TransitGatewayPropagation::resourceId)).setter(TransitGatewayPropagation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TransitGatewayPropagation.getter(TransitGatewayPropagation::resourceTypeAsString)).setter(TransitGatewayPropagation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableId").getter(TransitGatewayPropagation.getter(TransitGatewayPropagation::transitGatewayRouteTableId)).setter(TransitGatewayPropagation.setter(Builder::transitGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId").unmarshallLocationName("transitGatewayRouteTableId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayPropagation.getter(TransitGatewayPropagation::stateAsString)).setter(TransitGatewayPropagation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAttachmentId;
    private final String resourceId;
    private final String resourceType;
    private final String transitGatewayRouteTableId;
    private final String state;

    private TransitGatewayPropagation(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.state = builder.state;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    public final TransitGatewayPropagationState state() {
        return TransitGatewayPropagationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPropagation)) {
            return false;
        }
        TransitGatewayPropagation other = (TransitGatewayPropagation)obj;
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.transitGatewayRouteTableId(), other.transitGatewayRouteTableId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayPropagation").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("TransitGatewayRouteTableId", (Object)this.transitGatewayRouteTableId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "TransitGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPropagation, T> g) {
        return obj -> g.apply((TransitGatewayPropagation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private String resourceId;
        private String resourceType;
        private String transitGatewayRouteTableId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPropagation model) {
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            this.state(model.state);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getTransitGatewayRouteTableId() {
            return this.transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayPropagationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public TransitGatewayPropagation build() {
            return new TransitGatewayPropagation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayPropagation> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TransitGatewayAttachmentResourceType var1);

        public Builder transitGatewayRouteTableId(String var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayPropagationState var1);
    }
}

