/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVolumeStatusRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeVolumeStatusRequest.Builder, DescribeVolumeStatusRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeVolumeStatusRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeVolumeStatusRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVolumeStatusRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<String>> VOLUME_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VolumeIds")
            .getter(getter(DescribeVolumeStatusRequest::volumeIds))
            .setter(setter(Builder::volumeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("VolumeId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VolumeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VolumeId").unmarshallLocationName("VolumeId").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, VOLUME_IDS_FIELD));

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> volumeIds;

    private DescribeVolumeStatusRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.volumeIds = builder.volumeIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>action.description</code> - A description of the action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>action.event-id</code> - The event ID associated with the action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.description</code> - A description of the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.event-id</code> - The event ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
     * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
     * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.not-after</code> - The latest end time for the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.not-before</code> - The earliest start time for the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
     * <code>io-enabled</code> | <code>io-performance</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
     * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
     * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
     * <code>warning</code> | <code>insufficient-data</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>action.description</code> - A description of the action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>action.event-id</code> - The event ID associated with the action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.description</code> - A description of the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.event-id</code> - The event ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
     *         <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
     *         <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.not-after</code> - The latest end time for the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.not-before</code> - The earliest start time for the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
     *         <code>io-enabled</code> | <code>io-performance</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
     *         <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
     *         <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
     *         <code>warning</code> | <code>insufficient-data</code>).
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output. When this
     * parameter is used, the request only returns <code>MaxResults</code> results in a single page along with a
     * <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another request with the returned <code>NextToken</code> value. This value can be between 5 and 1,000; if
     * <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are returned. If this parameter is
     * not used, then <code>DescribeVolumeStatus</code> returns all results. You cannot specify this parameter and the
     * volume IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output.
     *         When this parameter is used, the request only returns <code>MaxResults</code> results in a single page
     *         along with a <code>NextToken</code> response element. The remaining results of the initial request can be
     *         seen by sending another request with the returned <code>NextToken</code> value. This value can be between
     *         5 and 1,000; if <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are
     *         returned. If this parameter is not used, then <code>DescribeVolumeStatus</code> returns all results. You
     *         cannot specify this parameter and the volume IDs parameter in the same request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request. When the
     * results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of
     * results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request. When
     *         the results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the next
     *         page of results. This value is <code>null</code> when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the VolumeIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVolumeIds() {
        return volumeIds != null && !(volumeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the volumes.
     * </p>
     * <p>
     * Default: Describes all your volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVolumeIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the volumes.</p>
     *         <p>
     *         Default: Describes all your volumes.
     */
    public final List<String> volumeIds() {
        return volumeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeIds() ? volumeIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusRequest)) {
            return false;
        }
        DescribeVolumeStatusRequest other = (DescribeVolumeStatusRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasVolumeIds() == other.hasVolumeIds() && Objects.equals(volumeIds(), other.volumeIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVolumeStatusRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("VolumeIds", hasVolumeIds() ? volumeIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VolumeIds":
            return Optional.ofNullable(clazz.cast(volumeIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumeStatusRequest, T> g) {
        return obj -> g.apply((DescribeVolumeStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVolumeStatusRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.description</code> - A description of the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.event-id</code> - The event ID associated with the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-id</code> - The event ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         * <code>io-enabled</code> | <code>io-performance</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
         * <code>warning</code> | <code>insufficient-data</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.description</code> - A description of the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.event-id</code> - The event ID associated with the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.description</code> - A description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-id</code> - The event ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         *        <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         *        <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-after</code> - The latest end time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-before</code> - The earliest start time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         *        <code>io-enabled</code> | <code>io-performance</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         *        <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         *        <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code>
         *        | <code>warning</code> | <code>insufficient-data</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.description</code> - A description of the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.event-id</code> - The event ID associated with the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-id</code> - The event ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         * <code>io-enabled</code> | <code>io-performance</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
         * <code>warning</code> | <code>insufficient-data</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.description</code> - A description of the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.event-id</code> - The event ID associated with the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.description</code> - A description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-id</code> - The event ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         *        <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         *        <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-after</code> - The latest end time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-before</code> - The earliest start time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         *        <code>io-enabled</code> | <code>io-performance</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         *        <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         *        <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code>
         *        | <code>warning</code> | <code>insufficient-data</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.description</code> - A description of the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.event-id</code> - The event ID associated with the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-id</code> - The event ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         * <code>io-enabled</code> | <code>io-performance</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
         * <code>warning</code> | <code>insufficient-data</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output. When
         * this parameter is used, the request only returns <code>MaxResults</code> results in a single page along with
         * a <code>NextToken</code> response element. The remaining results of the initial request can be seen by
         * sending another request with the returned <code>NextToken</code> value. This value can be between 5 and
         * 1,000; if <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are returned. If
         * this parameter is not used, then <code>DescribeVolumeStatus</code> returns all results. You cannot specify
         * this parameter and the volume IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated
         *        output. When this parameter is used, the request only returns <code>MaxResults</code> results in a
         *        single page along with a <code>NextToken</code> response element. The remaining results of the initial
         *        request can be seen by sending another request with the returned <code>NextToken</code> value. This
         *        value can be between 5 and 1,000; if <code>MaxResults</code> is given a value larger than 1,000, only
         *        1,000 results are returned. If this parameter is not used, then <code>DescribeVolumeStatus</code>
         *        returns all results. You cannot specify this parameter and the volume IDs parameter in the same
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request. When the
         * results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of
         * results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request.
         *        When the results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the
         *        next page of results. This value is <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The IDs of the volumes.
         * </p>
         * <p>
         * Default: Describes all your volumes.
         * </p>
         * 
         * @param volumeIds
         *        The IDs of the volumes.</p>
         *        <p>
         *        Default: Describes all your volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * The IDs of the volumes.
         * </p>
         * <p>
         * Default: Describes all your volumes.
         * </p>
         * 
         * @param volumeIds
         *        The IDs of the volumes.</p>
         *        <p>
         *        Default: Describes all your volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private List<String> volumeIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            volumeIds(model.volumeIds);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getVolumeIds() {
            if (volumeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumeStatusRequest build() {
            return new DescribeVolumeStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
