/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for managing connection authorization for new client connections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientConnectResponseOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientConnectResponseOptions.Builder, ClientConnectResponseOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(ClientConnectResponseOptions::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("enabled").build()).build();

    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LambdaFunctionArn")
            .getter(getter(ClientConnectResponseOptions::lambdaFunctionArn))
            .setter(setter(Builder::lambdaFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn")
                    .unmarshallLocationName("lambdaFunctionArn").build()).build();

    private static final SdkField<ClientVpnEndpointAttributeStatus> STATUS_FIELD = SdkField
            .<ClientVpnEndpointAttributeStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status")
            .getter(getter(ClientConnectResponseOptions::status))
            .setter(setter(Builder::status))
            .constructor(ClientVpnEndpointAttributeStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            LAMBDA_FUNCTION_ARN_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String lambdaFunctionArn;

    private final ClientVpnEndpointAttributeStatus status;

    private ClientConnectResponseOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * Indicates whether client connect options are enabled.
     * </p>
     * 
     * @return Indicates whether client connect options are enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Lambda function used for connection authorization.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Lambda function used for connection authorization.
     */
    public final String lambdaFunctionArn() {
        return lambdaFunctionArn;
    }

    /**
     * <p>
     * The status of any updates to the client connect options.
     * </p>
     * 
     * @return The status of any updates to the client connect options.
     */
    public final ClientVpnEndpointAttributeStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientConnectResponseOptions)) {
            return false;
        }
        ClientConnectResponseOptions other = (ClientConnectResponseOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(lambdaFunctionArn(), other.lambdaFunctionArn())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientConnectResponseOptions").add("Enabled", enabled())
                .add("LambdaFunctionArn", lambdaFunctionArn()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "LambdaFunctionArn":
            return Optional.ofNullable(clazz.cast(lambdaFunctionArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientConnectResponseOptions, T> g) {
        return obj -> g.apply((ClientConnectResponseOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientConnectResponseOptions> {
        /**
         * <p>
         * Indicates whether client connect options are enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether client connect options are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Lambda function used for connection authorization.
         * </p>
         * 
         * @param lambdaFunctionArn
         *        The Amazon Resource Name (ARN) of the AWS Lambda function used for connection authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionArn(String lambdaFunctionArn);

        /**
         * <p>
         * The status of any updates to the client connect options.
         * </p>
         * 
         * @param status
         *        The status of any updates to the client connect options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClientVpnEndpointAttributeStatus status);

        /**
         * <p>
         * The status of any updates to the client connect options.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientVpnEndpointAttributeStatus.Builder}
         * avoiding the need to create one manually via {@link ClientVpnEndpointAttributeStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientVpnEndpointAttributeStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(ClientVpnEndpointAttributeStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClientVpnEndpointAttributeStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClientVpnEndpointAttributeStatus)
         */
        default Builder status(Consumer<ClientVpnEndpointAttributeStatus.Builder> status) {
            return status(ClientVpnEndpointAttributeStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String lambdaFunctionArn;

        private ClientVpnEndpointAttributeStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientConnectResponseOptions model) {
            enabled(model.enabled);
            lambdaFunctionArn(model.lambdaFunctionArn);
            status(model.status);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLambdaFunctionArn() {
            return lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        public final ClientVpnEndpointAttributeStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClientVpnEndpointAttributeStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClientVpnEndpointAttributeStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public ClientConnectResponseOptions build() {
            return new ClientConnectResponseOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
