/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroup implements SdkPojo, Serializable, ToCopyableBuilder<SecurityGroup.Builder, SecurityGroup> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(SecurityGroup::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDescription")
                    .unmarshallLocationName("groupDescription").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(SecurityGroup::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("IpPermissions")
            .getter(getter(SecurityGroup::ipPermissions))
            .setter(setter(Builder::ipPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions")
                    .unmarshallLocationName("ipPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(SecurityGroup::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(SecurityGroup::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_EGRESS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("IpPermissionsEgress")
            .getter(getter(SecurityGroup::ipPermissionsEgress))
            .setter(setter(Builder::ipPermissionsEgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissionsEgress")
                    .unmarshallLocationName("ipPermissionsEgress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(SecurityGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(SecurityGroup::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            GROUP_NAME_FIELD, IP_PERMISSIONS_FIELD, OWNER_ID_FIELD, GROUP_ID_FIELD, IP_PERMISSIONS_EGRESS_FIELD, TAGS_FIELD,
            VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String groupName;

    private final List<IpPermission> ipPermissions;

    private final String ownerId;

    private final String groupId;

    private final List<IpPermission> ipPermissionsEgress;

    private final List<Tag> tags;

    private final String vpcId;

    private SecurityGroup(BuilderImpl builder) {
        this.description = builder.description;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
        this.ownerId = builder.ownerId;
        this.groupId = builder.groupId;
        this.ipPermissionsEgress = builder.ipPermissionsEgress;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * A description of the security group.
     * </p>
     * 
     * @return A description of the security group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * Returns true if the IpPermissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpPermissions() {
        return ipPermissions != null && !(ipPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inbound rules associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The inbound rules associated with the security group.
     */
    public final List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the security group.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the security group.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * Returns true if the IpPermissionsEgress property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasIpPermissionsEgress() {
        return ipPermissionsEgress != null && !(ipPermissionsEgress instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [VPC only] The outbound rules associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpPermissionsEgress()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [VPC only] The outbound rules associated with the security group.
     */
    public final List<IpPermission> ipPermissionsEgress() {
        return ipPermissionsEgress;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the security group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * [VPC only] The ID of the VPC for the security group.
     * </p>
     * 
     * @return [VPC only] The ID of the VPC for the security group.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPermissions() ? ipPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPermissionsEgress() ? ipPermissionsEgress() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroup)) {
            return false;
        }
        SecurityGroup other = (SecurityGroup) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(groupName(), other.groupName())
                && hasIpPermissions() == other.hasIpPermissions() && Objects.equals(ipPermissions(), other.ipPermissions())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(groupId(), other.groupId())
                && hasIpPermissionsEgress() == other.hasIpPermissionsEgress()
                && Objects.equals(ipPermissionsEgress(), other.ipPermissionsEgress()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityGroup").add("Description", description()).add("GroupName", groupName())
                .add("IpPermissions", hasIpPermissions() ? ipPermissions() : null).add("OwnerId", ownerId())
                .add("GroupId", groupId()).add("IpPermissionsEgress", hasIpPermissionsEgress() ? ipPermissionsEgress() : null)
                .add("Tags", hasTags() ? tags() : null).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "IpPermissions":
            return Optional.ofNullable(clazz.cast(ipPermissions()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "IpPermissionsEgress":
            return Optional.ofNullable(clazz.cast(ipPermissionsEgress()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroup, T> g) {
        return obj -> g.apply((SecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroup> {
        /**
         * <p>
         * A description of the security group.
         * </p>
         * 
         * @param description
         *        A description of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissions
         *        The inbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissions
         *        The inbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissions(List<IpPermission>)}.
         * 
         * @param ipPermissions
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissions(List<IpPermission>)
         */
        Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the security group.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account ID of the owner of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * [VPC only] The outbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissionsEgress
         *        [VPC only] The outbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissionsEgress(Collection<IpPermission> ipPermissionsEgress);

        /**
         * <p>
         * [VPC only] The outbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissionsEgress
         *        [VPC only] The outbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissionsEgress(IpPermission... ipPermissionsEgress);

        /**
         * <p>
         * [VPC only] The outbound rules associated with the security group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissionsEgress(List<IpPermission>)}.
         * 
         * @param ipPermissionsEgress
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissionsEgress(List<IpPermission>)
         */
        Builder ipPermissionsEgress(Consumer<IpPermission.Builder>... ipPermissionsEgress);

        /**
         * <p>
         * Any tags assigned to the security group.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the security group.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the security group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * [VPC only] The ID of the VPC for the security group.
         * </p>
         * 
         * @param vpcId
         *        [VPC only] The ID of the VPC for the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String groupName;

        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private String ownerId;

        private String groupId;

        private List<IpPermission> ipPermissionsEgress = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroup model) {
            description(model.description);
            groupName(model.groupName);
            ipPermissions(model.ipPermissions);
            ownerId(model.ownerId);
            groupId(model.groupId);
            ipPermissionsEgress(model.ipPermissionsEgress);
            tags(model.tags);
            vpcId(model.vpcId);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final List<IpPermission.Builder> getIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions) {
            ipPermissions(Stream.of(ipPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final List<IpPermission.Builder> getIpPermissionsEgress() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissionsEgress);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copy(ipPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(IpPermission... ipPermissionsEgress) {
            ipPermissionsEgress(Arrays.asList(ipPermissionsEgress));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(Consumer<IpPermission.Builder>... ipPermissionsEgress) {
            ipPermissionsEgress(Stream.of(ipPermissionsEgress).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissionsEgress(Collection<IpPermission.BuilderImpl> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copyFromBuilder(ipPermissionsEgress);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public SecurityGroup build() {
            return new SecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
