/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpnGateway;
import software.amazon.awssdk.services.ec2.model.VpnGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpnGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpnGatewaysResponse> {
    private static final SdkField<List<VpnGateway>> VPN_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpnGateways").getter(DescribeVpnGatewaysResponse.getter(DescribeVpnGatewaysResponse::vpnGateways)).setter(DescribeVpnGatewaysResponse.setter(Builder::vpnGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewaySet").unmarshallLocationName("vpnGatewaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpnGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_GATEWAYS_FIELD));
    private final List<VpnGateway> vpnGateways;

    private DescribeVpnGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.vpnGateways = builder.vpnGateways;
    }

    public final boolean hasVpnGateways() {
        return this.vpnGateways != null && !(this.vpnGateways instanceof SdkAutoConstructList);
    }

    public final List<VpnGateway> vpnGateways() {
        return this.vpnGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpnGateways() ? this.vpnGateways() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnGatewaysResponse)) {
            return false;
        }
        DescribeVpnGatewaysResponse other = (DescribeVpnGatewaysResponse)((Object)obj);
        return this.hasVpnGateways() == other.hasVpnGateways() && Objects.equals(this.vpnGateways(), other.vpnGateways());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpnGatewaysResponse").add("VpnGateways", this.hasVpnGateways() ? this.vpnGateways() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnGateways": {
                return Optional.ofNullable(clazz.cast(this.vpnGateways()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpnGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeVpnGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpnGateway> vpnGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnGatewaysResponse model) {
            super(model);
            this.vpnGateways(model.vpnGateways);
        }

        public final List<VpnGateway.Builder> getVpnGateways() {
            List<VpnGateway.Builder> result = VpnGatewayListCopier.copyToBuilder(this.vpnGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vpnGateways(Collection<VpnGateway> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copy(vpnGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGateways(VpnGateway ... vpnGateways) {
            this.vpnGateways(Arrays.asList(vpnGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGateways(Consumer<VpnGateway.Builder> ... vpnGateways) {
            this.vpnGateways(Stream.of(vpnGateways).map(c -> (VpnGateway)((VpnGateway.Builder)VpnGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpnGateways(Collection<VpnGateway.BuilderImpl> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copyFromBuilder(vpnGateways);
        }

        @Override
        public DescribeVpnGatewaysResponse build() {
            return new DescribeVpnGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpnGatewaysResponse> {
        public Builder vpnGateways(Collection<VpnGateway> var1);

        public Builder vpnGateways(VpnGateway ... var1);

        public Builder vpnGateways(Consumer<VpnGateway.Builder> ... var1);
    }
}

