/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the user data for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserData implements SdkPojo, Serializable, ToCopyableBuilder<UserData.Builder, UserData> {
    private static final SdkField<String> DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Data")
            .getter(getter(UserData::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data")
                    .unmarshallLocationName("data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String data;

    private UserData(BuilderImpl builder) {
        this.data = builder.data;
    }

    /**
     * <p>
     * The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you
     * can load the text from a file. Otherwise, you must provide Base64-encoded text.
     * </p>
     * 
     * @return The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you,
     *         and you can load the text from a file. Otherwise, you must provide Base64-encoded text.
     */
    public final String data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserData)) {
            return false;
        }
        UserData other = (UserData) obj;
        return Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserData").add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserData, T> g) {
        return obj -> g.apply((UserData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserData> {
        /**
         * <p>
         * The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and
         * you can load the text from a file. Otherwise, you must provide Base64-encoded text.
         * </p>
         * 
         * @param data
         *        The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you,
         *        and you can load the text from a file. Otherwise, you must provide Base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);
    }

    static final class BuilderImpl implements Builder {
        private String data;

        private BuilderImpl() {
        }

        private BuilderImpl(UserData model) {
            data(model.data);
        }

        public final String getData() {
            return data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public UserData build() {
            return new UserData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
