/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PrivateDnsNameConfiguration;
import software.amazon.awssdk.services.ec2.model.ServiceState;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetail;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceConfiguration> {
    private static final SdkField<List<ServiceTypeDetail>> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceType").getter(ServiceConfiguration.getter(ServiceConfiguration::serviceType)).setter(ServiceConfiguration.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").unmarshallLocationName("serviceType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceTypeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(ServiceConfiguration.getter(ServiceConfiguration::serviceId)).setter(ServiceConfiguration.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("serviceId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(ServiceConfiguration.getter(ServiceConfiguration::serviceName)).setter(ServiceConfiguration.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").unmarshallLocationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceState").getter(ServiceConfiguration.getter(ServiceConfiguration::serviceStateAsString)).setter(ServiceConfiguration.setter(Builder::serviceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceState").unmarshallLocationName("serviceState").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(ServiceConfiguration.getter(ServiceConfiguration::availabilityZones)).setter(ServiceConfiguration.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneSet").unmarshallLocationName("availabilityZoneSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptanceRequired").getter(ServiceConfiguration.getter(ServiceConfiguration::acceptanceRequired)).setter(ServiceConfiguration.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").unmarshallLocationName("acceptanceRequired").build()}).build();
    private static final SdkField<Boolean> MANAGES_VPC_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManagesVpcEndpoints").getter(ServiceConfiguration.getter(ServiceConfiguration::managesVpcEndpoints)).setter(ServiceConfiguration.setter(Builder::managesVpcEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagesVpcEndpoints").unmarshallLocationName("managesVpcEndpoints").build()}).build();
    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkLoadBalancerArns").getter(ServiceConfiguration.getter(ServiceConfiguration::networkLoadBalancerArns)).setter(ServiceConfiguration.setter(Builder::networkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArnSet").unmarshallLocationName("networkLoadBalancerArnSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatewayLoadBalancerArns").getter(ServiceConfiguration.getter(ServiceConfiguration::gatewayLoadBalancerArns)).setter(ServiceConfiguration.setter(Builder::gatewayLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayLoadBalancerArnSet").unmarshallLocationName("gatewayLoadBalancerArnSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BASE_ENDPOINT_DNS_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaseEndpointDnsNames").getter(ServiceConfiguration.getter(ServiceConfiguration::baseEndpointDnsNames)).setter(ServiceConfiguration.setter(Builder::baseEndpointDnsNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpointDnsNameSet").unmarshallLocationName("baseEndpointDnsNameSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(ServiceConfiguration.getter(ServiceConfiguration::privateDnsName)).setter(ServiceConfiguration.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<PrivateDnsNameConfiguration> PRIVATE_DNS_NAME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateDnsNameConfiguration").getter(ServiceConfiguration.getter(ServiceConfiguration::privateDnsNameConfiguration)).setter(ServiceConfiguration.setter(Builder::privateDnsNameConfiguration)).constructor(PrivateDnsNameConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameConfiguration").unmarshallLocationName("privateDnsNameConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ServiceConfiguration.getter(ServiceConfiguration::tags)).setter(ServiceConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, SERVICE_ID_FIELD, SERVICE_NAME_FIELD, SERVICE_STATE_FIELD, AVAILABILITY_ZONES_FIELD, ACCEPTANCE_REQUIRED_FIELD, MANAGES_VPC_ENDPOINTS_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD, GATEWAY_LOAD_BALANCER_ARNS_FIELD, BASE_ENDPOINT_DNS_NAMES_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_DNS_NAME_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ServiceTypeDetail> serviceType;
    private final String serviceId;
    private final String serviceName;
    private final String serviceState;
    private final List<String> availabilityZones;
    private final Boolean acceptanceRequired;
    private final Boolean managesVpcEndpoints;
    private final List<String> networkLoadBalancerArns;
    private final List<String> gatewayLoadBalancerArns;
    private final List<String> baseEndpointDnsNames;
    private final String privateDnsName;
    private final PrivateDnsNameConfiguration privateDnsNameConfiguration;
    private final List<Tag> tags;

    private ServiceConfiguration(BuilderImpl builder) {
        this.serviceType = builder.serviceType;
        this.serviceId = builder.serviceId;
        this.serviceName = builder.serviceName;
        this.serviceState = builder.serviceState;
        this.availabilityZones = builder.availabilityZones;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.managesVpcEndpoints = builder.managesVpcEndpoints;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
        this.gatewayLoadBalancerArns = builder.gatewayLoadBalancerArns;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.privateDnsName = builder.privateDnsName;
        this.privateDnsNameConfiguration = builder.privateDnsNameConfiguration;
        this.tags = builder.tags;
    }

    public final boolean hasServiceType() {
        return this.serviceType != null && !(this.serviceType instanceof SdkAutoConstructList);
    }

    public final List<ServiceTypeDetail> serviceType() {
        return this.serviceType;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final ServiceState serviceState() {
        return ServiceState.fromValue(this.serviceState);
    }

    public final String serviceStateAsString() {
        return this.serviceState;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public final Boolean managesVpcEndpoints() {
        return this.managesVpcEndpoints;
    }

    public final boolean hasNetworkLoadBalancerArns() {
        return this.networkLoadBalancerArns != null && !(this.networkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> networkLoadBalancerArns() {
        return this.networkLoadBalancerArns;
    }

    public final boolean hasGatewayLoadBalancerArns() {
        return this.gatewayLoadBalancerArns != null && !(this.gatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> gatewayLoadBalancerArns() {
        return this.gatewayLoadBalancerArns;
    }

    public final boolean hasBaseEndpointDnsNames() {
        return this.baseEndpointDnsNames != null && !(this.baseEndpointDnsNames instanceof SdkAutoConstructList);
    }

    public final List<String> baseEndpointDnsNames() {
        return this.baseEndpointDnsNames;
    }

    public final String privateDnsName() {
        return this.privateDnsName;
    }

    public final PrivateDnsNameConfiguration privateDnsNameConfiguration() {
        return this.privateDnsNameConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceType() ? this.serviceType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.managesVpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkLoadBalancerArns() ? this.networkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayLoadBalancerArns() ? this.gatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaseEndpointDnsNames() ? this.baseEndpointDnsNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsNameConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration)obj;
        return this.hasServiceType() == other.hasServiceType() && Objects.equals(this.serviceType(), other.serviceType()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceStateAsString(), other.serviceStateAsString()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.managesVpcEndpoints(), other.managesVpcEndpoints()) && this.hasNetworkLoadBalancerArns() == other.hasNetworkLoadBalancerArns() && Objects.equals(this.networkLoadBalancerArns(), other.networkLoadBalancerArns()) && this.hasGatewayLoadBalancerArns() == other.hasGatewayLoadBalancerArns() && Objects.equals(this.gatewayLoadBalancerArns(), other.gatewayLoadBalancerArns()) && this.hasBaseEndpointDnsNames() == other.hasBaseEndpointDnsNames() && Objects.equals(this.baseEndpointDnsNames(), other.baseEndpointDnsNames()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateDnsNameConfiguration(), other.privateDnsNameConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceConfiguration").add("ServiceType", this.hasServiceType() ? this.serviceType() : null).add("ServiceId", (Object)this.serviceId()).add("ServiceName", (Object)this.serviceName()).add("ServiceState", (Object)this.serviceStateAsString()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("ManagesVpcEndpoints", (Object)this.managesVpcEndpoints()).add("NetworkLoadBalancerArns", this.hasNetworkLoadBalancerArns() ? this.networkLoadBalancerArns() : null).add("GatewayLoadBalancerArns", this.hasGatewayLoadBalancerArns() ? this.gatewayLoadBalancerArns() : null).add("BaseEndpointDnsNames", this.hasBaseEndpointDnsNames() ? this.baseEndpointDnsNames() : null).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateDnsNameConfiguration", (Object)this.privateDnsNameConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceType()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceState": {
                return Optional.ofNullable(clazz.cast(this.serviceStateAsString()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "ManagesVpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.managesVpcEndpoints()));
            }
            case "NetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.networkLoadBalancerArns()));
            }
            case "GatewayLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.gatewayLoadBalancerArns()));
            }
            case "BaseEndpointDnsNames": {
                return Optional.ofNullable(clazz.cast(this.baseEndpointDnsNames()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "PrivateDnsNameConfiguration": {
                return Optional.ofNullable(clazz.cast(this.privateDnsNameConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceConfiguration, T> g) {
        return obj -> g.apply((ServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ServiceTypeDetail> serviceType = DefaultSdkAutoConstructList.getInstance();
        private String serviceId;
        private String serviceName;
        private String serviceState;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Boolean acceptanceRequired;
        private Boolean managesVpcEndpoints;
        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> gatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> baseEndpointDnsNames = DefaultSdkAutoConstructList.getInstance();
        private String privateDnsName;
        private PrivateDnsNameConfiguration privateDnsNameConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConfiguration model) {
            this.serviceType(model.serviceType);
            this.serviceId(model.serviceId);
            this.serviceName(model.serviceName);
            this.serviceState(model.serviceState);
            this.availabilityZones(model.availabilityZones);
            this.acceptanceRequired(model.acceptanceRequired);
            this.managesVpcEndpoints(model.managesVpcEndpoints);
            this.networkLoadBalancerArns(model.networkLoadBalancerArns);
            this.gatewayLoadBalancerArns(model.gatewayLoadBalancerArns);
            this.baseEndpointDnsNames(model.baseEndpointDnsNames);
            this.privateDnsName(model.privateDnsName);
            this.privateDnsNameConfiguration(model.privateDnsNameConfiguration);
            this.tags(model.tags);
        }

        public final Collection<ServiceTypeDetail.Builder> getServiceType() {
            if (this.serviceType instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceType != null ? (Collection)this.serviceType.stream().map(ServiceTypeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceType(Collection<ServiceTypeDetail> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copy(serviceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(ServiceTypeDetail ... serviceType) {
            this.serviceType(Arrays.asList(serviceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(Consumer<ServiceTypeDetail.Builder> ... serviceType) {
            this.serviceType(Stream.of(serviceType).map(c -> (ServiceTypeDetail)((ServiceTypeDetail.Builder)ServiceTypeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceType(Collection<ServiceTypeDetail.BuilderImpl> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copyFromBuilder(serviceType);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceState() {
            return this.serviceState;
        }

        @Override
        public final Builder serviceState(String serviceState) {
            this.serviceState = serviceState;
            return this;
        }

        @Override
        public final Builder serviceState(ServiceState serviceState) {
            this.serviceState(serviceState == null ? null : serviceState.toString());
            return this;
        }

        public final void setServiceState(String serviceState) {
            this.serviceState = serviceState;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final Boolean getManagesVpcEndpoints() {
            return this.managesVpcEndpoints;
        }

        @Override
        public final Builder managesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
            return this;
        }

        public final void setManagesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            if (this.networkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkLoadBalancerArns;
        }

        @Override
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String ... networkLoadBalancerArns) {
            this.networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
        }

        public final Collection<String> getGatewayLoadBalancerArns() {
            if (this.gatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatewayLoadBalancerArns;
        }

        @Override
        public final Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = ValueStringListCopier.copy(gatewayLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayLoadBalancerArns(String ... gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns(Arrays.asList(gatewayLoadBalancerArns));
            return this;
        }

        public final void setGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = ValueStringListCopier.copy(gatewayLoadBalancerArns);
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            if (this.baseEndpointDnsNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.baseEndpointDnsNames;
        }

        @Override
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String ... baseEndpointDnsNames) {
            this.baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final PrivateDnsNameConfiguration.Builder getPrivateDnsNameConfiguration() {
            return this.privateDnsNameConfiguration != null ? this.privateDnsNameConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder privateDnsNameConfiguration(PrivateDnsNameConfiguration privateDnsNameConfiguration) {
            this.privateDnsNameConfiguration = privateDnsNameConfiguration;
            return this;
        }

        public final void setPrivateDnsNameConfiguration(PrivateDnsNameConfiguration.BuilderImpl privateDnsNameConfiguration) {
            this.privateDnsNameConfiguration = privateDnsNameConfiguration != null ? privateDnsNameConfiguration.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ServiceConfiguration build() {
            return new ServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceConfiguration> {
        public Builder serviceType(Collection<ServiceTypeDetail> var1);

        public Builder serviceType(ServiceTypeDetail ... var1);

        public Builder serviceType(Consumer<ServiceTypeDetail.Builder> ... var1);

        public Builder serviceId(String var1);

        public Builder serviceName(String var1);

        public Builder serviceState(String var1);

        public Builder serviceState(ServiceState var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder acceptanceRequired(Boolean var1);

        public Builder managesVpcEndpoints(Boolean var1);

        public Builder networkLoadBalancerArns(Collection<String> var1);

        public Builder networkLoadBalancerArns(String ... var1);

        public Builder gatewayLoadBalancerArns(Collection<String> var1);

        public Builder gatewayLoadBalancerArns(String ... var1);

        public Builder baseEndpointDnsNames(Collection<String> var1);

        public Builder baseEndpointDnsNames(String ... var1);

        public Builder privateDnsName(String var1);

        public Builder privateDnsNameConfiguration(PrivateDnsNameConfiguration var1);

        default public Builder privateDnsNameConfiguration(Consumer<PrivateDnsNameConfiguration.Builder> privateDnsNameConfiguration) {
            return this.privateDnsNameConfiguration((PrivateDnsNameConfiguration)((PrivateDnsNameConfiguration.Builder)PrivateDnsNameConfiguration.builder().applyMutation(privateDnsNameConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

