/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEgressOnlyInternetGatewayResponse extends Ec2Response implements
        ToCopyableBuilder<CreateEgressOnlyInternetGatewayResponse.Builder, CreateEgressOnlyInternetGatewayResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateEgressOnlyInternetGatewayResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<EgressOnlyInternetGateway> EGRESS_ONLY_INTERNET_GATEWAY_FIELD = SdkField
            .<EgressOnlyInternetGateway> builder(MarshallingType.SDK_POJO)
            .memberName("EgressOnlyInternetGateway")
            .getter(getter(CreateEgressOnlyInternetGatewayResponse::egressOnlyInternetGateway))
            .setter(setter(Builder::egressOnlyInternetGateway))
            .constructor(EgressOnlyInternetGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGateway")
                    .unmarshallLocationName("egressOnlyInternetGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            EGRESS_ONLY_INTERNET_GATEWAY_FIELD));

    private final String clientToken;

    private final EgressOnlyInternetGateway egressOnlyInternetGateway;

    private CreateEgressOnlyInternetGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.egressOnlyInternetGateway = builder.egressOnlyInternetGateway;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Information about the egress-only internet gateway.
     * </p>
     * 
     * @return Information about the egress-only internet gateway.
     */
    public final EgressOnlyInternetGateway egressOnlyInternetGateway() {
        return egressOnlyInternetGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEgressOnlyInternetGatewayResponse)) {
            return false;
        }
        CreateEgressOnlyInternetGatewayResponse other = (CreateEgressOnlyInternetGatewayResponse) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(egressOnlyInternetGateway(), other.egressOnlyInternetGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEgressOnlyInternetGatewayResponse").add("ClientToken", clientToken())
                .add("EgressOnlyInternetGateway", egressOnlyInternetGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "EgressOnlyInternetGateway":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEgressOnlyInternetGatewayResponse, T> g) {
        return obj -> g.apply((CreateEgressOnlyInternetGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEgressOnlyInternetGatewayResponse> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Information about the egress-only internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGateway
         *        Information about the egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGateway(EgressOnlyInternetGateway egressOnlyInternetGateway);

        /**
         * <p>
         * Information about the egress-only internet gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link EgressOnlyInternetGateway.Builder} avoiding the
         * need to create one manually via {@link EgressOnlyInternetGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link EgressOnlyInternetGateway.Builder#build()} is called immediately
         * and its result is passed to {@link #egressOnlyInternetGateway(EgressOnlyInternetGateway)}.
         * 
         * @param egressOnlyInternetGateway
         *        a consumer that will call methods on {@link EgressOnlyInternetGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressOnlyInternetGateway(EgressOnlyInternetGateway)
         */
        default Builder egressOnlyInternetGateway(Consumer<EgressOnlyInternetGateway.Builder> egressOnlyInternetGateway) {
            return egressOnlyInternetGateway(EgressOnlyInternetGateway.builder().applyMutation(egressOnlyInternetGateway).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String clientToken;

        private EgressOnlyInternetGateway egressOnlyInternetGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEgressOnlyInternetGatewayResponse model) {
            super(model);
            clientToken(model.clientToken);
            egressOnlyInternetGateway(model.egressOnlyInternetGateway);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final EgressOnlyInternetGateway.Builder getEgressOnlyInternetGateway() {
            return egressOnlyInternetGateway != null ? egressOnlyInternetGateway.toBuilder() : null;
        }

        @Override
        public final Builder egressOnlyInternetGateway(EgressOnlyInternetGateway egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway;
            return this;
        }

        public final void setEgressOnlyInternetGateway(EgressOnlyInternetGateway.BuilderImpl egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway != null ? egressOnlyInternetGateway.build() : null;
        }

        @Override
        public CreateEgressOnlyInternetGatewayResponse build() {
            return new CreateEgressOnlyInternetGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
