/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route table route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRouteTableRoute implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisRouteTableRoute.Builder, AnalysisRouteTableRoute> {
    private static final SdkField<String> DESTINATION_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidr")
            .getter(getter(AnalysisRouteTableRoute::destinationCidr))
            .setter(setter(Builder::destinationCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidr")
                    .unmarshallLocationName("destinationCidr").build()).build();

    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationPrefixListId")
            .getter(getter(AnalysisRouteTableRoute::destinationPrefixListId))
            .setter(setter(Builder::destinationPrefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId")
                    .unmarshallLocationName("destinationPrefixListId").build()).build();

    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EgressOnlyInternetGatewayId")
            .getter(getter(AnalysisRouteTableRoute::egressOnlyInternetGatewayId))
            .setter(setter(Builder::egressOnlyInternetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId")
                    .unmarshallLocationName("egressOnlyInternetGatewayId").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GatewayId")
            .getter(getter(AnalysisRouteTableRoute::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId")
                    .unmarshallLocationName("gatewayId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(AnalysisRouteTableRoute::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId")
            .getter(getter(AnalysisRouteTableRoute::natGatewayId))
            .setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId")
                    .unmarshallLocationName("natGatewayId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AnalysisRouteTableRoute::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Origin")
            .getter(getter(AnalysisRouteTableRoute::origin))
            .setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin")
                    .unmarshallLocationName("origin").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(AnalysisRouteTableRoute::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId")
            .getter(getter(AnalysisRouteTableRoute::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId")
                    .unmarshallLocationName("vpcPeeringConnectionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_FIELD,
            DESTINATION_PREFIX_LIST_ID_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, INSTANCE_ID_FIELD,
            NAT_GATEWAY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, ORIGIN_FIELD, TRANSIT_GATEWAY_ID_FIELD,
            VPC_PEERING_CONNECTION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationCidr;

    private final String destinationPrefixListId;

    private final String egressOnlyInternetGatewayId;

    private final String gatewayId;

    private final String instanceId;

    private final String natGatewayId;

    private final String networkInterfaceId;

    private final String origin;

    private final String transitGatewayId;

    private final String vpcPeeringConnectionId;

    private AnalysisRouteTableRoute(BuilderImpl builder) {
        this.destinationCidr = builder.destinationCidr;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.natGatewayId = builder.natGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.origin = builder.origin;
        this.transitGatewayId = builder.transitGatewayId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The destination IPv4 address, in CIDR notation.
     * </p>
     * 
     * @return The destination IPv4 address, in CIDR notation.
     */
    public final String destinationCidr() {
        return destinationCidr;
    }

    /**
     * <p>
     * The prefix of the AWS service.
     * </p>
     * 
     * @return The prefix of the AWS service.
     */
    public final String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    /**
     * <p>
     * The ID of an egress-only internet gateway.
     * </p>
     * 
     * @return The ID of an egress-only internet gateway.
     */
    public final String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of the gateway, such as an internet gateway or virtual private gateway.
     * </p>
     * 
     * @return The ID of the gateway, such as an internet gateway or virtual private gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of the instance, such as a NAT instance.
     * </p>
     * 
     * @return The ID of the instance, such as a NAT instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of a NAT gateway.
     * </p>
     * 
     * @return The ID of a NAT gateway.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The ID of a network interface.
     * </p>
     * 
     * @return The ID of a network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Describes how the route was created. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateRoute</code> - The route was manually added to the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes how the route was created. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateRoute</code> - The route was manually added to the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     *         </p>
     *         </li>
     */
    public final String origin() {
        return origin;
    }

    /**
     * <p>
     * The ID of a transit gateway.
     * </p>
     * 
     * @return The ID of a transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of a VPC peering connection.
     * </p>
     * 
     * @return The ID of a VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidr());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(origin());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRouteTableRoute)) {
            return false;
        }
        AnalysisRouteTableRoute other = (AnalysisRouteTableRoute) obj;
        return Objects.equals(destinationCidr(), other.destinationCidr())
                && Objects.equals(destinationPrefixListId(), other.destinationPrefixListId())
                && Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId())
                && Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(natGatewayId(), other.natGatewayId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(origin(), other.origin())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRouteTableRoute").add("DestinationCidr", destinationCidr())
                .add("DestinationPrefixListId", destinationPrefixListId())
                .add("EgressOnlyInternetGatewayId", egressOnlyInternetGatewayId()).add("GatewayId", gatewayId())
                .add("InstanceId", instanceId()).add("NatGatewayId", natGatewayId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("Origin", origin())
                .add("TransitGatewayId", transitGatewayId()).add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidr":
            return Optional.ofNullable(clazz.cast(destinationCidr()));
        case "DestinationPrefixListId":
            return Optional.ofNullable(clazz.cast(destinationPrefixListId()));
        case "EgressOnlyInternetGatewayId":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGatewayId()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRouteTableRoute, T> g) {
        return obj -> g.apply((AnalysisRouteTableRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRouteTableRoute> {
        /**
         * <p>
         * The destination IPv4 address, in CIDR notation.
         * </p>
         * 
         * @param destinationCidr
         *        The destination IPv4 address, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidr(String destinationCidr);

        /**
         * <p>
         * The prefix of the AWS service.
         * </p>
         * 
         * @param destinationPrefixListId
         *        The prefix of the AWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        /**
         * <p>
         * The ID of an egress-only internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of an egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The ID of the gateway, such as an internet gateway or virtual private gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the gateway, such as an internet gateway or virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of the instance, such as a NAT instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance, such as a NAT instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of a NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The ID of a network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of a network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Describes how the route was created. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateRoute</code> - The route was manually added to the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        Describes how the route was created. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateRoute</code> - The route was manually added to the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(String origin);

        /**
         * <p>
         * The ID of a transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of a transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of a VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of a VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidr;

        private String destinationPrefixListId;

        private String egressOnlyInternetGatewayId;

        private String gatewayId;

        private String instanceId;

        private String natGatewayId;

        private String networkInterfaceId;

        private String origin;

        private String transitGatewayId;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRouteTableRoute model) {
            destinationCidr(model.destinationCidr);
            destinationPrefixListId(model.destinationPrefixListId);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            gatewayId(model.gatewayId);
            instanceId(model.instanceId);
            natGatewayId(model.natGatewayId);
            networkInterfaceId(model.networkInterfaceId);
            origin(model.origin);
            transitGatewayId(model.transitGatewayId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDestinationCidr() {
            return destinationCidr;
        }

        @Override
        public final Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            return this;
        }

        public final void setDestinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOrigin() {
            return origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public AnalysisRouteTableRoute build() {
            return new AnalysisRouteTableRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
