/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayMulticastDomainRequest extends Ec2Request implements
        ToCopyableBuilder<CreateTransitGatewayMulticastDomainRequest.Builder, CreateTransitGatewayMulticastDomainRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(CreateTransitGatewayMulticastDomainRequest::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("TransitGatewayId").build()).build();

    private static final SdkField<CreateTransitGatewayMulticastDomainRequestOptions> OPTIONS_FIELD = SdkField
            .<CreateTransitGatewayMulticastDomainRequestOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options")
            .getter(getter(CreateTransitGatewayMulticastDomainRequest::options))
            .setter(setter(Builder::options))
            .constructor(CreateTransitGatewayMulticastDomainRequestOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options")
                    .unmarshallLocationName("Options").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateTransitGatewayMulticastDomainRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD,
            OPTIONS_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String transitGatewayId;

    private final CreateTransitGatewayMulticastDomainRequestOptions options;

    private final List<TagSpecification> tagSpecifications;

    private CreateTransitGatewayMulticastDomainRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayId = builder.transitGatewayId;
        this.options = builder.options;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The options for the transit gateway multicast domain.
     * </p>
     * 
     * @return The options for the transit gateway multicast domain.
     */
    public final CreateTransitGatewayMulticastDomainRequestOptions options() {
        return options;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the transit gateway multicast domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the transit gateway multicast domain.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayMulticastDomainRequest)) {
            return false;
        }
        CreateTransitGatewayMulticastDomainRequest other = (CreateTransitGatewayMulticastDomainRequest) obj;
        return Objects.equals(transitGatewayId(), other.transitGatewayId()) && Objects.equals(options(), other.options())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayMulticastDomainRequest").add("TransitGatewayId", transitGatewayId())
                .add("Options", options()).add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayMulticastDomainRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayMulticastDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayMulticastDomainRequest> {
        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The options for the transit gateway multicast domain.
         * </p>
         * 
         * @param options
         *        The options for the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(CreateTransitGatewayMulticastDomainRequestOptions options);

        /**
         * <p>
         * The options for the transit gateway multicast domain.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link CreateTransitGatewayMulticastDomainRequestOptions.Builder} avoiding the need to create one manually
         * via {@link CreateTransitGatewayMulticastDomainRequestOptions#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link CreateTransitGatewayMulticastDomainRequestOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #options(CreateTransitGatewayMulticastDomainRequestOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link CreateTransitGatewayMulticastDomainRequestOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(CreateTransitGatewayMulticastDomainRequestOptions)
         */
        default Builder options(Consumer<CreateTransitGatewayMulticastDomainRequestOptions.Builder> options) {
            return options(CreateTransitGatewayMulticastDomainRequestOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The tags for the transit gateway multicast domain.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags for the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags for the transit gateway multicast domain.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags for the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags for the transit gateway multicast domain.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayId;

        private CreateTransitGatewayMulticastDomainRequestOptions options;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayMulticastDomainRequest model) {
            super(model);
            transitGatewayId(model.transitGatewayId);
            options(model.options);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final CreateTransitGatewayMulticastDomainRequestOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        @Override
        public final Builder options(CreateTransitGatewayMulticastDomainRequestOptions options) {
            this.options = options;
            return this;
        }

        public final void setOptions(CreateTransitGatewayMulticastDomainRequestOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            if (tagSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayMulticastDomainRequest build() {
            return new CreateTransitGatewayMulticastDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
