/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DeleteVpcEndpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcEndpointsResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteVpcEndpointsResponse.Builder, DeleteVpcEndpointsResponse> {
    private static final SdkField<List<UnsuccessfulItem>> UNSUCCESSFUL_FIELD = SdkField
            .<List<UnsuccessfulItem>> builder(MarshallingType.LIST)
            .memberName("Unsuccessful")
            .getter(getter(DeleteVpcEndpointsResponse::unsuccessful))
            .setter(setter(Builder::unsuccessful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful")
                    .unmarshallLocationName("unsuccessful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<UnsuccessfulItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsuccessfulItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNSUCCESSFUL_FIELD));

    private final List<UnsuccessfulItem> unsuccessful;

    private DeleteVpcEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * Returns true if the Unsuccessful property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUnsuccessful() {
        return unsuccessful != null && !(unsuccessful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the VPC endpoints that were not successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnsuccessful()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the VPC endpoints that were not successfully deleted.
     */
    public final List<UnsuccessfulItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsuccessful() ? unsuccessful() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointsResponse)) {
            return false;
        }
        DeleteVpcEndpointsResponse other = (DeleteVpcEndpointsResponse) obj;
        return hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcEndpointsResponse").add("Unsuccessful", hasUnsuccessful() ? unsuccessful() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Unsuccessful":
            return Optional.ofNullable(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointsResponse, T> g) {
        return obj -> g.apply((DeleteVpcEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVpcEndpointsResponse> {
        /**
         * <p>
         * Information about the VPC endpoints that were not successfully deleted.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the VPC endpoints that were not successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful);

        /**
         * <p>
         * Information about the VPC endpoints that were not successfully deleted.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the VPC endpoints that were not successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(UnsuccessfulItem... unsuccessful);

        /**
         * <p>
         * Information about the VPC endpoints that were not successfully deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnsuccessfulItem>.Builder} avoiding the
         * need to create one manually via {@link List<UnsuccessfulItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnsuccessfulItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #unsuccessful(List<UnsuccessfulItem>)}.
         * 
         * @param unsuccessful
         *        a consumer that will call methods on {@link List<UnsuccessfulItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessful(List<UnsuccessfulItem>)
         */
        Builder unsuccessful(Consumer<UnsuccessfulItem.Builder>... unsuccessful);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<UnsuccessfulItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointsResponse model) {
            super(model);
            unsuccessful(model.unsuccessful);
        }

        public final Collection<UnsuccessfulItem.Builder> getUnsuccessful() {
            if (unsuccessful instanceof SdkAutoConstructList) {
                return null;
            }
            return unsuccessful != null ? unsuccessful.stream().map(UnsuccessfulItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<UnsuccessfulItem.Builder>... unsuccessful) {
            unsuccessful(Stream.of(unsuccessful).map(c -> UnsuccessfulItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public DeleteVpcEndpointsResponse build() {
            return new DeleteVpcEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
