/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes service integrations with VPC Flow logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrateServices implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrateServices.Builder, IntegrateServices> {
    private static final SdkField<List<AthenaIntegration>> ATHENA_INTEGRATIONS_FIELD = SdkField
            .<List<AthenaIntegration>> builder(MarshallingType.LIST)
            .memberName("AthenaIntegrations")
            .getter(getter(IntegrateServices::athenaIntegrations))
            .setter(setter(Builder::athenaIntegrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaIntegration")
                    .unmarshallLocationName("AthenaIntegration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AthenaIntegration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AthenaIntegration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_INTEGRATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AthenaIntegration> athenaIntegrations;

    private IntegrateServices(BuilderImpl builder) {
        this.athenaIntegrations = builder.athenaIntegrations;
    }

    /**
     * Returns true if the AthenaIntegrations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAthenaIntegrations() {
        return athenaIntegrations != null && !(athenaIntegrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the integration with Amazon Athena.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAthenaIntegrations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the integration with Amazon Athena.
     */
    public final List<AthenaIntegration> athenaIntegrations() {
        return athenaIntegrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAthenaIntegrations() ? athenaIntegrations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrateServices)) {
            return false;
        }
        IntegrateServices other = (IntegrateServices) obj;
        return hasAthenaIntegrations() == other.hasAthenaIntegrations()
                && Objects.equals(athenaIntegrations(), other.athenaIntegrations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrateServices")
                .add("AthenaIntegrations", hasAthenaIntegrations() ? athenaIntegrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AthenaIntegrations":
            return Optional.ofNullable(clazz.cast(athenaIntegrations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntegrateServices, T> g) {
        return obj -> g.apply((IntegrateServices) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrateServices> {
        /**
         * <p>
         * Information about the integration with Amazon Athena.
         * </p>
         * 
         * @param athenaIntegrations
         *        Information about the integration with Amazon Athena.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaIntegrations(Collection<AthenaIntegration> athenaIntegrations);

        /**
         * <p>
         * Information about the integration with Amazon Athena.
         * </p>
         * 
         * @param athenaIntegrations
         *        Information about the integration with Amazon Athena.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaIntegrations(AthenaIntegration... athenaIntegrations);

        /**
         * <p>
         * Information about the integration with Amazon Athena.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AthenaIntegration>.Builder} avoiding the
         * need to create one manually via {@link List<AthenaIntegration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AthenaIntegration>.Builder#build()} is called immediately
         * and its result is passed to {@link #athenaIntegrations(List<AthenaIntegration>)}.
         * 
         * @param athenaIntegrations
         *        a consumer that will call methods on {@link List<AthenaIntegration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaIntegrations(List<AthenaIntegration>)
         */
        Builder athenaIntegrations(Consumer<AthenaIntegration.Builder>... athenaIntegrations);
    }

    static final class BuilderImpl implements Builder {
        private List<AthenaIntegration> athenaIntegrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrateServices model) {
            athenaIntegrations(model.athenaIntegrations);
        }

        public final Collection<AthenaIntegration.Builder> getAthenaIntegrations() {
            if (athenaIntegrations instanceof SdkAutoConstructList) {
                return null;
            }
            return athenaIntegrations != null ? athenaIntegrations.stream().map(AthenaIntegration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder athenaIntegrations(Collection<AthenaIntegration> athenaIntegrations) {
            this.athenaIntegrations = AthenaIntegrationsSetCopier.copy(athenaIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder athenaIntegrations(AthenaIntegration... athenaIntegrations) {
            athenaIntegrations(Arrays.asList(athenaIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder athenaIntegrations(Consumer<AthenaIntegration.Builder>... athenaIntegrations) {
            athenaIntegrations(Stream.of(athenaIntegrations).map(c -> AthenaIntegration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAthenaIntegrations(Collection<AthenaIntegration.BuilderImpl> athenaIntegrations) {
            this.athenaIntegrations = AthenaIntegrationsSetCopier.copyFromBuilder(athenaIntegrations);
        }

        @Override
        public IntegrateServices build() {
            return new IntegrateServices(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
