/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes modifications to the load permissions of an Amazon FPGA image (AFI).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadPermissionModifications implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadPermissionModifications.Builder, LoadPermissionModifications> {
    private static final SdkField<List<LoadPermissionRequest>> ADD_FIELD = SdkField
            .<List<LoadPermissionRequest>> builder(MarshallingType.LIST)
            .memberName("Add")
            .getter(getter(LoadPermissionModifications::add))
            .setter(setter(Builder::add))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Add").unmarshallLocationName("Add")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LoadPermissionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadPermissionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<LoadPermissionRequest>> REMOVE_FIELD = SdkField
            .<List<LoadPermissionRequest>> builder(MarshallingType.LIST)
            .memberName("Remove")
            .getter(getter(LoadPermissionModifications::remove))
            .setter(setter(Builder::remove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remove")
                    .unmarshallLocationName("Remove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LoadPermissionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadPermissionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_FIELD, REMOVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LoadPermissionRequest> add;

    private final List<LoadPermissionRequest> remove;

    private LoadPermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    /**
     * Returns true if the Add property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAdd() {
        return add != null && !(add instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The load permissions to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdd()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The load permissions to add.
     */
    public final List<LoadPermissionRequest> add() {
        return add;
    }

    /**
     * Returns true if the Remove property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRemove() {
        return remove != null && !(remove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The load permissions to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The load permissions to remove.
     */
    public final List<LoadPermissionRequest> remove() {
        return remove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdd() ? add() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemove() ? remove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadPermissionModifications)) {
            return false;
        }
        LoadPermissionModifications other = (LoadPermissionModifications) obj;
        return hasAdd() == other.hasAdd() && Objects.equals(add(), other.add()) && hasRemove() == other.hasRemove()
                && Objects.equals(remove(), other.remove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadPermissionModifications").add("Add", hasAdd() ? add() : null)
                .add("Remove", hasRemove() ? remove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Add":
            return Optional.ofNullable(clazz.cast(add()));
        case "Remove":
            return Optional.ofNullable(clazz.cast(remove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadPermissionModifications, T> g) {
        return obj -> g.apply((LoadPermissionModifications) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadPermissionModifications> {
        /**
         * <p>
         * The load permissions to add.
         * </p>
         * 
         * @param add
         *        The load permissions to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(Collection<LoadPermissionRequest> add);

        /**
         * <p>
         * The load permissions to add.
         * </p>
         * 
         * @param add
         *        The load permissions to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(LoadPermissionRequest... add);

        /**
         * <p>
         * The load permissions to add.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadPermissionRequest>.Builder} avoiding
         * the need to create one manually via {@link List<LoadPermissionRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadPermissionRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #add(List<LoadPermissionRequest>)}.
         * 
         * @param add
         *        a consumer that will call methods on {@link List<LoadPermissionRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #add(List<LoadPermissionRequest>)
         */
        Builder add(Consumer<LoadPermissionRequest.Builder>... add);

        /**
         * <p>
         * The load permissions to remove.
         * </p>
         * 
         * @param remove
         *        The load permissions to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(Collection<LoadPermissionRequest> remove);

        /**
         * <p>
         * The load permissions to remove.
         * </p>
         * 
         * @param remove
         *        The load permissions to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(LoadPermissionRequest... remove);

        /**
         * <p>
         * The load permissions to remove.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadPermissionRequest>.Builder} avoiding
         * the need to create one manually via {@link List<LoadPermissionRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadPermissionRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #remove(List<LoadPermissionRequest>)}.
         * 
         * @param remove
         *        a consumer that will call methods on {@link List<LoadPermissionRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remove(List<LoadPermissionRequest>)
         */
        Builder remove(Consumer<LoadPermissionRequest.Builder>... remove);
    }

    static final class BuilderImpl implements Builder {
        private List<LoadPermissionRequest> add = DefaultSdkAutoConstructList.getInstance();

        private List<LoadPermissionRequest> remove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadPermissionModifications model) {
            add(model.add);
            remove(model.remove);
        }

        public final Collection<LoadPermissionRequest.Builder> getAdd() {
            if (add instanceof SdkAutoConstructList) {
                return null;
            }
            return add != null ? add.stream().map(LoadPermissionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<LoadPermissionRequest> add) {
            this.add = LoadPermissionListRequestCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(LoadPermissionRequest... add) {
            add(Arrays.asList(add));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(Consumer<LoadPermissionRequest.Builder>... add) {
            add(Stream.of(add).map(c -> LoadPermissionRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdd(Collection<LoadPermissionRequest.BuilderImpl> add) {
            this.add = LoadPermissionListRequestCopier.copyFromBuilder(add);
        }

        public final Collection<LoadPermissionRequest.Builder> getRemove() {
            if (remove instanceof SdkAutoConstructList) {
                return null;
            }
            return remove != null ? remove.stream().map(LoadPermissionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<LoadPermissionRequest> remove) {
            this.remove = LoadPermissionListRequestCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(LoadPermissionRequest... remove) {
            remove(Arrays.asList(remove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(Consumer<LoadPermissionRequest.Builder>... remove) {
            remove(Stream.of(remove).map(c -> LoadPermissionRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRemove(Collection<LoadPermissionRequest.BuilderImpl> remove) {
            this.remove = LoadPermissionListRequestCopier.copyFromBuilder(remove);
        }

        @Override
        public LoadPermissionModifications build() {
            return new LoadPermissionModifications(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
