/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInternetGatewaysResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeInternetGatewaysResponse.Builder, DescribeInternetGatewaysResponse> {
    private static final SdkField<List<InternetGateway>> INTERNET_GATEWAYS_FIELD = SdkField
            .<List<InternetGateway>> builder(MarshallingType.LIST)
            .memberName("InternetGateways")
            .getter(getter(DescribeInternetGatewaysResponse::internetGateways))
            .setter(setter(Builder::internetGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewaySet")
                    .unmarshallLocationName("internetGatewaySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InternetGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(InternetGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeInternetGatewaysResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNET_GATEWAYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InternetGateway> internetGateways;

    private final String nextToken;

    private DescribeInternetGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.internetGateways = builder.internetGateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the InternetGateways property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInternetGateways() {
        return internetGateways != null && !(internetGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about one or more internet gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInternetGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about one or more internet gateways.
     */
    public final List<InternetGateway> internetGateways() {
        return internetGateways;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInternetGateways() ? internetGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInternetGatewaysResponse)) {
            return false;
        }
        DescribeInternetGatewaysResponse other = (DescribeInternetGatewaysResponse) obj;
        return hasInternetGateways() == other.hasInternetGateways()
                && Objects.equals(internetGateways(), other.internetGateways()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInternetGatewaysResponse")
                .add("InternetGateways", hasInternetGateways() ? internetGateways() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InternetGateways":
            return Optional.ofNullable(clazz.cast(internetGateways()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInternetGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeInternetGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
        /**
         * <p>
         * Information about one or more internet gateways.
         * </p>
         * 
         * @param internetGateways
         *        Information about one or more internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateways(Collection<InternetGateway> internetGateways);

        /**
         * <p>
         * Information about one or more internet gateways.
         * </p>
         * 
         * @param internetGateways
         *        Information about one or more internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateways(InternetGateway... internetGateways);

        /**
         * <p>
         * Information about one or more internet gateways.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InternetGateway>.Builder} avoiding the need
         * to create one manually via {@link List<InternetGateway>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InternetGateway>.Builder#build()} is called immediately and
         * its result is passed to {@link #internetGateways(List<InternetGateway>)}.
         * 
         * @param internetGateways
         *        a consumer that will call methods on {@link List<InternetGateway>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetGateways(List<InternetGateway>)
         */
        Builder internetGateways(Consumer<InternetGateway.Builder>... internetGateways);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InternetGateway> internetGateways = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInternetGatewaysResponse model) {
            super(model);
            internetGateways(model.internetGateways);
            nextToken(model.nextToken);
        }

        public final Collection<InternetGateway.Builder> getInternetGateways() {
            if (internetGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return internetGateways != null ? internetGateways.stream().map(InternetGateway::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder internetGateways(Collection<InternetGateway> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copy(internetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(InternetGateway... internetGateways) {
            internetGateways(Arrays.asList(internetGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(Consumer<InternetGateway.Builder>... internetGateways) {
            internetGateways(Stream.of(internetGateways).map(c -> InternetGateway.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInternetGateways(Collection<InternetGateway.BuilderImpl> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copyFromBuilder(internetGateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInternetGatewaysResponse build() {
            return new DescribeInternetGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
