/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ReportInstanceReasonCodes {
    INSTANCE_STUCK_IN_STATE("instance-stuck-in-state"),

    UNRESPONSIVE("unresponsive"),

    NOT_ACCEPTING_CREDENTIALS("not-accepting-credentials"),

    PASSWORD_NOT_AVAILABLE("password-not-available"),

    PERFORMANCE_NETWORK("performance-network"),

    PERFORMANCE_INSTANCE_STORE("performance-instance-store"),

    PERFORMANCE_EBS_VOLUME("performance-ebs-volume"),

    PERFORMANCE_OTHER("performance-other"),

    OTHER("other"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReportInstanceReasonCodes(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ReportInstanceReasonCodes corresponding to the value
     */
    public static ReportInstanceReasonCodes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReportInstanceReasonCodes.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ReportInstanceReasonCodes}s
     */
    public static Set<ReportInstanceReasonCodes> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
