/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Capacity Reservation usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceUsage implements SdkPojo, Serializable, ToCopyableBuilder<InstanceUsage.Builder, InstanceUsage> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(InstanceUsage::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId")
                    .unmarshallLocationName("accountId").build()).build();

    private static final SdkField<Integer> USED_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("UsedInstanceCount")
            .getter(getter(InstanceUsage::usedInstanceCount))
            .setter(setter(Builder::usedInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsedInstanceCount")
                    .unmarshallLocationName("usedInstanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            USED_INSTANCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Integer usedInstanceCount;

    private InstanceUsage(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.usedInstanceCount = builder.usedInstanceCount;
    }

    /**
     * <p>
     * The ID of the account that is making use of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the account that is making use of the Capacity Reservation.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The number of instances the account currently has in the Capacity Reservation.
     * </p>
     * 
     * @return The number of instances the account currently has in the Capacity Reservation.
     */
    public final Integer usedInstanceCount() {
        return usedInstanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(usedInstanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceUsage)) {
            return false;
        }
        InstanceUsage other = (InstanceUsage) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(usedInstanceCount(), other.usedInstanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceUsage").add("AccountId", accountId()).add("UsedInstanceCount", usedInstanceCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "UsedInstanceCount":
            return Optional.ofNullable(clazz.cast(usedInstanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceUsage, T> g) {
        return obj -> g.apply((InstanceUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceUsage> {
        /**
         * <p>
         * The ID of the account that is making use of the Capacity Reservation.
         * </p>
         * 
         * @param accountId
         *        The ID of the account that is making use of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The number of instances the account currently has in the Capacity Reservation.
         * </p>
         * 
         * @param usedInstanceCount
         *        The number of instances the account currently has in the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usedInstanceCount(Integer usedInstanceCount);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Integer usedInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceUsage model) {
            accountId(model.accountId);
            usedInstanceCount(model.usedInstanceCount);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Integer getUsedInstanceCount() {
            return usedInstanceCount;
        }

        @Override
        public final Builder usedInstanceCount(Integer usedInstanceCount) {
            this.usedInstanceCount = usedInstanceCount;
            return this;
        }

        public final void setUsedInstanceCount(Integer usedInstanceCount) {
            this.usedInstanceCount = usedInstanceCount;
        }

        @Override
        public InstanceUsage build() {
            return new InstanceUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
