/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotResponse extends Ec2Response implements
        ToCopyableBuilder<CreateSnapshotResponse.Builder, CreateSnapshotResponse> {
    private static final SdkField<String> DATA_ENCRYPTION_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataEncryptionKeyId")
            .getter(getter(CreateSnapshotResponse::dataEncryptionKeyId))
            .setter(setter(Builder::dataEncryptionKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEncryptionKeyId")
                    .unmarshallLocationName("dataEncryptionKeyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateSnapshotResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(CreateSnapshotResponse::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(CreateSnapshotResponse::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("kmsKeyId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(CreateSnapshotResponse::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Progress")
            .getter(getter(CreateSnapshotResponse::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(CreateSnapshotResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(CreateSnapshotResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(CreateSnapshotResponse::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateMessage")
            .getter(getter(CreateSnapshotResponse::stateMessage))
            .setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(CreateSnapshotResponse::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize")
            .getter(getter(CreateSnapshotResponse::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize")
                    .unmarshallLocationName("volumeSize").build()).build();

    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerAlias")
            .getter(getter(CreateSnapshotResponse::ownerAlias))
            .setter(setter(Builder::ownerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias")
                    .unmarshallLocationName("ownerAlias").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(CreateSnapshotResponse::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateSnapshotResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ENCRYPTION_KEY_ID_FIELD,
            DESCRIPTION_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, OWNER_ID_FIELD, PROGRESS_FIELD, SNAPSHOT_ID_FIELD,
            START_TIME_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, VOLUME_ID_FIELD, VOLUME_SIZE_FIELD, OWNER_ALIAS_FIELD,
            OUTPOST_ARN_FIELD, TAGS_FIELD));

    private final String dataEncryptionKeyId;

    private final String description;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String ownerId;

    private final String progress;

    private final String snapshotId;

    private final Instant startTime;

    private final String state;

    private final String stateMessage;

    private final String volumeId;

    private final Integer volumeSize;

    private final String ownerAlias;

    private final String outpostArn;

    private final List<Tag> tags;

    private CreateSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.dataEncryptionKeyId = builder.dataEncryptionKeyId;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.ownerId = builder.ownerId;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.volumeId = builder.volumeId;
        this.volumeSize = builder.volumeSize;
        this.ownerAlias = builder.ownerAlias;
        this.outpostArn = builder.outpostArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to the
     * data encryption key that was used to encrypt the original volume or snapshot copy. Because data encryption keys
     * are inherited by volumes created from snapshots, and vice versa, if snapshots share the same data encryption key
     * identifier, then they belong to the same volume/snapshot lineage. This parameter is only returned by
     * <a>DescribeSnapshots</a>.
     * </p>
     * 
     * @return The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds
     *         to the data encryption key that was used to encrypt the original volume or snapshot copy. Because data
     *         encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the
     *         same data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter
     *         is only returned by <a>DescribeSnapshots</a>.
     */
    public final String dataEncryptionKeyId() {
        return dataEncryptionKeyId;
    }

    /**
     * <p>
     * The description for the snapshot.
     * </p>
     * 
     * @return The description for the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the snapshot is encrypted.
     * </p>
     * 
     * @return Indicates whether the snapshot is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was
     * used to protect the volume encryption key for the parent volume.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS KMS) customer master key (CMK) that
     *         was used to protect the volume encryption key for the parent volume.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The AWS account ID of the EBS snapshot owner.
     * </p>
     * 
     * @return The AWS account ID of the EBS snapshot owner.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The progress of the snapshot, as a percentage.
     * </p>
     * 
     * @return The progress of the snapshot, as a percentage.
     */
    public final String progress() {
        return progress;
    }

    /**
     * <p>
     * The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
     * </p>
     * 
     * @return The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The time stamp when the snapshot was initiated.
     * </p>
     * 
     * @return The time stamp when the snapshot was initiated.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The snapshot state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The snapshot state.
     * @see SnapshotState
     */
    public final SnapshotState state() {
        return SnapshotState.fromValue(state);
    }

    /**
     * <p>
     * The snapshot state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The snapshot state.
     * @see SnapshotState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if the
     * proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field displays error state details
     * to help you diagnose why the error occurred. This parameter is only returned by <a>DescribeSnapshots</a>.
     * </p>
     * 
     * @return Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for
     *         example, if the proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field
     *         displays error state details to help you diagnose why the error occurred. This parameter is only returned
     *         by <a>DescribeSnapshots</a>.
     */
    public final String stateMessage() {
        return stateMessage;
    }

    /**
     * <p>
     * The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a> action
     * have an arbitrary volume ID that should not be used for any purpose.
     * </p>
     * 
     * @return The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a>
     *         action have an arbitrary volume ID that should not be used for any purpose.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The AWS owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the user-configured AWS
     * account alias set using the IAM console.
     * </p>
     * 
     * @return The AWS owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the
     *         user-configured AWS account alias set using the IAM console.
     */
    public final String ownerAlias() {
        return ownerAlias;
    }

    /**
     * <p>
     * The ARN of the AWS Outpost on which the snapshot is stored. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">EBS Local Snapshot on
     * Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The ARN of the AWS Outpost on which the snapshot is stored. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">EBS Local Snapshot on
     *         Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the snapshot.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataEncryptionKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotResponse)) {
            return false;
        }
        CreateSnapshotResponse other = (CreateSnapshotResponse) obj;
        return Objects.equals(dataEncryptionKeyId(), other.dataEncryptionKeyId())
                && Objects.equals(description(), other.description()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(progress(), other.progress()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateMessage(), other.stateMessage()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(volumeSize(), other.volumeSize()) && Objects.equals(ownerAlias(), other.ownerAlias())
                && Objects.equals(outpostArn(), other.outpostArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSnapshotResponse").add("DataEncryptionKeyId", dataEncryptionKeyId())
                .add("Description", description()).add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId())
                .add("OwnerId", ownerId()).add("Progress", progress()).add("SnapshotId", snapshotId())
                .add("StartTime", startTime()).add("State", stateAsString()).add("StateMessage", stateMessage())
                .add("VolumeId", volumeId()).add("VolumeSize", volumeSize()).add("OwnerAlias", ownerAlias())
                .add("OutpostArn", outpostArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataEncryptionKeyId":
            return Optional.ofNullable(clazz.cast(dataEncryptionKeyId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "OwnerAlias":
            return Optional.ofNullable(clazz.cast(ownerAlias()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotResponse, T> g) {
        return obj -> g.apply((CreateSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateSnapshotResponse> {
        /**
         * <p>
         * The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to
         * the data encryption key that was used to encrypt the original volume or snapshot copy. Because data
         * encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the same
         * data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter is only
         * returned by <a>DescribeSnapshots</a>.
         * </p>
         * 
         * @param dataEncryptionKeyId
         *        The data encryption key identifier for the snapshot. This value is a unique identifier that
         *        corresponds to the data encryption key that was used to encrypt the original volume or snapshot copy.
         *        Because data encryption keys are inherited by volumes created from snapshots, and vice versa, if
         *        snapshots share the same data encryption key identifier, then they belong to the same volume/snapshot
         *        lineage. This parameter is only returned by <a>DescribeSnapshots</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEncryptionKeyId(String dataEncryptionKeyId);

        /**
         * <p>
         * The description for the snapshot.
         * </p>
         * 
         * @param description
         *        The description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the snapshot is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the snapshot is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was
         * used to protect the volume encryption key for the parent volume.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS KMS) customer master key (CMK)
         *        that was used to protect the volume encryption key for the parent volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The AWS account ID of the EBS snapshot owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the EBS snapshot owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The progress of the snapshot, as a percentage.
         * </p>
         * 
         * @param progress
         *        The progress of the snapshot, as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The time stamp when the snapshot was initiated.
         * </p>
         * 
         * @param startTime
         *        The time stamp when the snapshot was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The snapshot state.
         * </p>
         * 
         * @param state
         *        The snapshot state.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(String state);

        /**
         * <p>
         * The snapshot state.
         * </p>
         * 
         * @param state
         *        The snapshot state.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(SnapshotState state);

        /**
         * <p>
         * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if
         * the proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field displays error state
         * details to help you diagnose why the error occurred. This parameter is only returned by
         * <a>DescribeSnapshots</a>.
         * </p>
         * 
         * @param stateMessage
         *        Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for
         *        example, if the proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field
         *        displays error state details to help you diagnose why the error occurred. This parameter is only
         *        returned by <a>DescribeSnapshots</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);

        /**
         * <p>
         * The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a>
         * action have an arbitrary volume ID that should not be used for any purpose.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that was used to create the snapshot. Snapshots created by the
         *        <a>CopySnapshot</a> action have an arbitrary volume ID that should not be used for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The AWS owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the user-configured
         * AWS account alias set using the IAM console.
         * </p>
         * 
         * @param ownerAlias
         *        The AWS owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the
         *        user-configured AWS account alias set using the IAM console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAlias(String ownerAlias);

        /**
         * <p>
         * The ARN of the AWS Outpost on which the snapshot is stored. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">EBS Local Snapshot on
         * Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param outpostArn
         *        The ARN of the AWS Outpost on which the snapshot is stored. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">EBS Local Snapshot
         *        on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * Any tags assigned to the snapshot.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the snapshot.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String dataEncryptionKeyId;

        private String description;

        private Boolean encrypted;

        private String kmsKeyId;

        private String ownerId;

        private String progress;

        private String snapshotId;

        private Instant startTime;

        private String state;

        private String stateMessage;

        private String volumeId;

        private Integer volumeSize;

        private String ownerAlias;

        private String outpostArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotResponse model) {
            super(model);
            dataEncryptionKeyId(model.dataEncryptionKeyId);
            description(model.description);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            ownerId(model.ownerId);
            progress(model.progress);
            snapshotId(model.snapshotId);
            startTime(model.startTime);
            state(model.state);
            stateMessage(model.stateMessage);
            volumeId(model.volumeId);
            volumeSize(model.volumeSize);
            ownerAlias(model.ownerAlias);
            outpostArn(model.outpostArn);
            tags(model.tags);
        }

        public final String getDataEncryptionKeyId() {
            return dataEncryptionKeyId;
        }

        @Override
        public final Builder dataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
            return this;
        }

        public final void setDataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getOwnerAlias() {
            return ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public CreateSnapshotResponse build() {
            return new CreateSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
