/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the errors that occurred when enabling fast snapshot restores.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFastSnapshotRestoreErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EnableFastSnapshotRestoreErrorItem.Builder, EnableFastSnapshotRestoreErrorItem> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(EnableFastSnapshotRestoreErrorItem::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<List<EnableFastSnapshotRestoreStateErrorItem>> FAST_SNAPSHOT_RESTORE_STATE_ERRORS_FIELD = SdkField
            .<List<EnableFastSnapshotRestoreStateErrorItem>> builder(MarshallingType.LIST)
            .memberName("FastSnapshotRestoreStateErrors")
            .getter(getter(EnableFastSnapshotRestoreErrorItem::fastSnapshotRestoreStateErrors))
            .setter(setter(Builder::fastSnapshotRestoreStateErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastSnapshotRestoreStateErrorSet")
                    .unmarshallLocationName("fastSnapshotRestoreStateErrorSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<EnableFastSnapshotRestoreStateErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnableFastSnapshotRestoreStateErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            FAST_SNAPSHOT_RESTORE_STATE_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final List<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors;

    private EnableFastSnapshotRestoreErrorItem(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.fastSnapshotRestoreStateErrors = builder.fastSnapshotRestoreStateErrors;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * Returns true if the FastSnapshotRestoreStateErrors property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasFastSnapshotRestoreStateErrors() {
        return fastSnapshotRestoreStateErrors != null && !(fastSnapshotRestoreStateErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFastSnapshotRestoreStateErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The errors.
     */
    public final List<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors() {
        return fastSnapshotRestoreStateErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasFastSnapshotRestoreStateErrors() ? fastSnapshotRestoreStateErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoreErrorItem)) {
            return false;
        }
        EnableFastSnapshotRestoreErrorItem other = (EnableFastSnapshotRestoreErrorItem) obj;
        return Objects.equals(snapshotId(), other.snapshotId())
                && hasFastSnapshotRestoreStateErrors() == other.hasFastSnapshotRestoreStateErrors()
                && Objects.equals(fastSnapshotRestoreStateErrors(), other.fastSnapshotRestoreStateErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EnableFastSnapshotRestoreErrorItem")
                .add("SnapshotId", snapshotId())
                .add("FastSnapshotRestoreStateErrors",
                        hasFastSnapshotRestoreStateErrors() ? fastSnapshotRestoreStateErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "FastSnapshotRestoreStateErrors":
            return Optional.ofNullable(clazz.cast(fastSnapshotRestoreStateErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastSnapshotRestoreErrorItem, T> g) {
        return obj -> g.apply((EnableFastSnapshotRestoreErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnableFastSnapshotRestoreErrorItem> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The errors.
         * </p>
         * 
         * @param fastSnapshotRestoreStateErrors
         *        The errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastSnapshotRestoreStateErrors(Collection<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors);

        /**
         * <p>
         * The errors.
         * </p>
         * 
         * @param fastSnapshotRestoreStateErrors
         *        The errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastSnapshotRestoreStateErrors(EnableFastSnapshotRestoreStateErrorItem... fastSnapshotRestoreStateErrors);

        /**
         * <p>
         * The errors.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <EnableFastSnapshotRestoreStateErrorItem>.Builder} avoiding the need to create one manually via {@link List
         * <EnableFastSnapshotRestoreStateErrorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnableFastSnapshotRestoreStateErrorItem>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #fastSnapshotRestoreStateErrors(List<EnableFastSnapshotRestoreStateErrorItem>)}.
         * 
         * @param fastSnapshotRestoreStateErrors
         *        a consumer that will call methods on {@link List<EnableFastSnapshotRestoreStateErrorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fastSnapshotRestoreStateErrors(List<EnableFastSnapshotRestoreStateErrorItem>)
         */
        Builder fastSnapshotRestoreStateErrors(
                Consumer<EnableFastSnapshotRestoreStateErrorItem.Builder>... fastSnapshotRestoreStateErrors);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private List<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastSnapshotRestoreErrorItem model) {
            snapshotId(model.snapshotId);
            fastSnapshotRestoreStateErrors(model.fastSnapshotRestoreStateErrors);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final List<EnableFastSnapshotRestoreStateErrorItem.Builder> getFastSnapshotRestoreStateErrors() {
            List<EnableFastSnapshotRestoreStateErrorItem.Builder> result = EnableFastSnapshotRestoreStateErrorSetCopier
                    .copyToBuilder(this.fastSnapshotRestoreStateErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder fastSnapshotRestoreStateErrors(
                Collection<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors) {
            this.fastSnapshotRestoreStateErrors = EnableFastSnapshotRestoreStateErrorSetCopier
                    .copy(fastSnapshotRestoreStateErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastSnapshotRestoreStateErrors(
                EnableFastSnapshotRestoreStateErrorItem... fastSnapshotRestoreStateErrors) {
            fastSnapshotRestoreStateErrors(Arrays.asList(fastSnapshotRestoreStateErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastSnapshotRestoreStateErrors(
                Consumer<EnableFastSnapshotRestoreStateErrorItem.Builder>... fastSnapshotRestoreStateErrors) {
            fastSnapshotRestoreStateErrors(Stream.of(fastSnapshotRestoreStateErrors)
                    .map(c -> EnableFastSnapshotRestoreStateErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFastSnapshotRestoreStateErrors(
                Collection<EnableFastSnapshotRestoreStateErrorItem.BuilderImpl> fastSnapshotRestoreStateErrors) {
            this.fastSnapshotRestoreStateErrors = EnableFastSnapshotRestoreStateErrorSetCopier
                    .copyFromBuilder(fastSnapshotRestoreStateErrors);
        }

        @Override
        public EnableFastSnapshotRestoreErrorItem build() {
            return new EnableFastSnapshotRestoreErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
