/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import instance task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportInstanceTaskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportInstanceTaskDetails.Builder, ImportInstanceTaskDetails> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportInstanceTaskDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ImportInstanceTaskDetails::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(ImportInstanceTaskDetails::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<List<ImportInstanceVolumeDetailItem>> VOLUMES_FIELD = SdkField
            .<List<ImportInstanceVolumeDetailItem>> builder(MarshallingType.LIST)
            .memberName("Volumes")
            .getter(getter(ImportInstanceTaskDetails::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volumes")
                    .unmarshallLocationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImportInstanceVolumeDetailItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportInstanceVolumeDetailItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            INSTANCE_ID_FIELD, PLATFORM_FIELD, VOLUMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String instanceId;

    private final String platform;

    private final List<ImportInstanceVolumeDetailItem> volumes;

    private ImportInstanceTaskDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.platform = builder.platform;
        this.volumes = builder.volumes;
    }

    /**
     * <p>
     * A description of the task.
     * </p>
     * 
     * @return A description of the task.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The instance operating system.
     * @see PlatformValues
     */
    public final PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * The instance operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The instance operating system.
     * @see PlatformValues
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * Returns true if the Volumes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVolumes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The volumes.
     */
    public final List<ImportInstanceVolumeDetailItem> volumes() {
        return volumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceTaskDetails)) {
            return false;
        }
        ImportInstanceTaskDetails other = (ImportInstanceTaskDetails) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(platformAsString(), other.platformAsString()) && hasVolumes() == other.hasVolumes()
                && Objects.equals(volumes(), other.volumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportInstanceTaskDetails").add("Description", description()).add("InstanceId", instanceId())
                .add("Platform", platformAsString()).add("Volumes", hasVolumes() ? volumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "Volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportInstanceTaskDetails, T> g) {
        return obj -> g.apply((ImportInstanceTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportInstanceTaskDetails> {
        /**
         * <p>
         * A description of the task.
         * </p>
         * 
         * @param description
         *        A description of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * The volumes.
         * </p>
         * 
         * @param volumes
         *        The volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes);

        /**
         * <p>
         * The volumes.
         * </p>
         * 
         * @param volumes
         *        The volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(ImportInstanceVolumeDetailItem... volumes);

        /**
         * <p>
         * The volumes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImportInstanceVolumeDetailItem>.Builder}
         * avoiding the need to create one manually via {@link List<ImportInstanceVolumeDetailItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportInstanceVolumeDetailItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #volumes(List<ImportInstanceVolumeDetailItem>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on {@link List<ImportInstanceVolumeDetailItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(List<ImportInstanceVolumeDetailItem>)
         */
        Builder volumes(Consumer<ImportInstanceVolumeDetailItem.Builder>... volumes);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String instanceId;

        private String platform;

        private List<ImportInstanceVolumeDetailItem> volumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceTaskDetails model) {
            description(model.description);
            instanceId(model.instanceId);
            platform(model.platform);
            volumes(model.volumes);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final List<ImportInstanceVolumeDetailItem.Builder> getVolumes() {
            List<ImportInstanceVolumeDetailItem.Builder> result = ImportInstanceVolumeDetailSetCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(ImportInstanceVolumeDetailItem... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<ImportInstanceVolumeDetailItem.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> ImportInstanceVolumeDetailItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVolumes(Collection<ImportInstanceVolumeDetailItem.BuilderImpl> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copyFromBuilder(volumes);
        }

        @Override
        public ImportInstanceTaskDetails build() {
            return new ImportInstanceTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
