/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for GetReservedInstanceExchangeQuote.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservedInstancesExchangeQuoteRequest extends Ec2Request implements
        ToCopyableBuilder<GetReservedInstancesExchangeQuoteRequest.Builder, GetReservedInstancesExchangeQuoteRequest> {
    private static final SdkField<List<String>> RESERVED_INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReservedInstanceIds")
            .getter(getter(GetReservedInstancesExchangeQuoteRequest::reservedInstanceIds))
            .setter(setter(Builder::reservedInstanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId")
                    .unmarshallLocationName("ReservedInstanceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedInstanceId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedInstanceId")
                                                    .unmarshallLocationName("ReservedInstanceId").build()).build()).build())
            .build();

    private static final SdkField<List<TargetConfigurationRequest>> TARGET_CONFIGURATIONS_FIELD = SdkField
            .<List<TargetConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("TargetConfigurations")
            .getter(getter(GetReservedInstancesExchangeQuoteRequest::targetConfigurations))
            .setter(setter(Builder::targetConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration")
                    .unmarshallLocationName("TargetConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TargetConfigurationRequest")
                            .memberFieldInfo(
                                    SdkField.<TargetConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TargetConfigurationRequest")
                                                    .unmarshallLocationName("TargetConfigurationRequest").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCE_IDS_FIELD,
            TARGET_CONFIGURATIONS_FIELD));

    private final List<String> reservedInstanceIds;

    private final List<TargetConfigurationRequest> targetConfigurations;

    private GetReservedInstancesExchangeQuoteRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstanceIds = builder.reservedInstanceIds;
        this.targetConfigurations = builder.targetConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedInstanceIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReservedInstanceIds() {
        return reservedInstanceIds != null && !(reservedInstanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Convertible Reserved Instances to exchange.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedInstanceIds} method.
     * </p>
     * 
     * @return The IDs of the Convertible Reserved Instances to exchange.
     */
    public final List<String> reservedInstanceIds() {
        return reservedInstanceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetConfigurations() {
        return targetConfigurations != null && !(targetConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved
     * Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetConfigurations} method.
     * </p>
     * 
     * @return The configuration of the target Convertible Reserved Instance to exchange for your current Convertible
     *         Reserved Instances.
     */
    public final List<TargetConfigurationRequest> targetConfigurations() {
        return targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedInstanceIds() ? reservedInstanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetConfigurations() ? targetConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteRequest)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteRequest other = (GetReservedInstancesExchangeQuoteRequest) obj;
        return hasReservedInstanceIds() == other.hasReservedInstanceIds()
                && Objects.equals(reservedInstanceIds(), other.reservedInstanceIds())
                && hasTargetConfigurations() == other.hasTargetConfigurations()
                && Objects.equals(targetConfigurations(), other.targetConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReservedInstancesExchangeQuoteRequest")
                .add("ReservedInstanceIds", hasReservedInstanceIds() ? reservedInstanceIds() : null)
                .add("TargetConfigurations", hasTargetConfigurations() ? targetConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstanceIds":
            return Optional.ofNullable(clazz.cast(reservedInstanceIds()));
        case "TargetConfigurations":
            return Optional.ofNullable(clazz.cast(targetConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservedInstancesExchangeQuoteRequest, T> g) {
        return obj -> g.apply((GetReservedInstancesExchangeQuoteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteRequest> {
        /**
         * <p>
         * The IDs of the Convertible Reserved Instances to exchange.
         * </p>
         * 
         * @param reservedInstanceIds
         *        The IDs of the Convertible Reserved Instances to exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceIds(Collection<String> reservedInstanceIds);

        /**
         * <p>
         * The IDs of the Convertible Reserved Instances to exchange.
         * </p>
         * 
         * @param reservedInstanceIds
         *        The IDs of the Convertible Reserved Instances to exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceIds(String... reservedInstanceIds);

        /**
         * <p>
         * The configuration of the target Convertible Reserved Instance to exchange for your current Convertible
         * Reserved Instances.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration of the target Convertible Reserved Instance to exchange for your current Convertible
         *        Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations);

        /**
         * <p>
         * The configuration of the target Convertible Reserved Instance to exchange for your current Convertible
         * Reserved Instances.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration of the target Convertible Reserved Instance to exchange for your current Convertible
         *        Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(TargetConfigurationRequest... targetConfigurations);

        /**
         * <p>
         * The configuration of the target Convertible Reserved Instance to exchange for your current Convertible
         * Reserved Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetConfigurationRequest>.Builder}
         * avoiding the need to create one manually via {@link List<TargetConfigurationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetConfigurationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #targetConfigurations(List<TargetConfigurationRequest>)}.
         * 
         * @param targetConfigurations
         *        a consumer that will call methods on {@link List<TargetConfigurationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfigurations(List<TargetConfigurationRequest>)
         */
        Builder targetConfigurations(Consumer<TargetConfigurationRequest.Builder>... targetConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> reservedInstanceIds = DefaultSdkAutoConstructList.getInstance();

        private List<TargetConfigurationRequest> targetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteRequest model) {
            super(model);
            reservedInstanceIds(model.reservedInstanceIds);
            targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstanceIds() {
            if (reservedInstanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return reservedInstanceIds;
        }

        public final void setReservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
        }

        @Override
        @Transient
        public final Builder reservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedInstanceIds(String... reservedInstanceIds) {
            reservedInstanceIds(Arrays.asList(reservedInstanceIds));
            return this;
        }

        public final List<TargetConfigurationRequest.Builder> getTargetConfigurations() {
            List<TargetConfigurationRequest.Builder> result = TargetConfigurationRequestSetCopier
                    .copyToBuilder(this.targetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetConfigurations(Collection<TargetConfigurationRequest.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        @Transient
        public final Builder targetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetConfigurations(TargetConfigurationRequest... targetConfigurations) {
            targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetConfigurations(Consumer<TargetConfigurationRequest.Builder>... targetConfigurations) {
            targetConfigurations(Stream.of(targetConfigurations)
                    .map(c -> TargetConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReservedInstancesExchangeQuoteRequest build() {
            return new GetReservedInstancesExchangeQuoteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
