/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointServicePermissionsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcEndpointServicePermissionsRequest.Builder, ModifyVpcEndpointServicePermissionsRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceId")
            .getter(getter(ModifyVpcEndpointServicePermissionsRequest::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("ServiceId").build()).build();

    private static final SdkField<List<String>> ADD_ALLOWED_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddAllowedPrincipals")
            .getter(getter(ModifyVpcEndpointServicePermissionsRequest::addAllowedPrincipals))
            .setter(setter(Builder::addAllowedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddAllowedPrincipals")
                    .unmarshallLocationName("AddAllowedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_ALLOWED_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveAllowedPrincipals")
            .getter(getter(ModifyVpcEndpointServicePermissionsRequest::removeAllowedPrincipals))
            .setter(setter(Builder::removeAllowedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAllowedPrincipals")
                    .unmarshallLocationName("RemoveAllowedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD,
            ADD_ALLOWED_PRINCIPALS_FIELD, REMOVE_ALLOWED_PRINCIPALS_FIELD));

    private final String serviceId;

    private final List<String> addAllowedPrincipals;

    private final List<String> removeAllowedPrincipals;

    private ModifyVpcEndpointServicePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.addAllowedPrincipals = builder.addAllowedPrincipals;
        this.removeAllowedPrincipals = builder.removeAllowedPrincipals;
    }

    /**
     * <p>
     * The ID of the service.
     * </p>
     * 
     * @return The ID of the service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddAllowedPrincipals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddAllowedPrincipals() {
        return addAllowedPrincipals != null && !(addAllowedPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in this
     * list. To grant permissions to all principals, specify an asterisk (*).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddAllowedPrincipals} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in
     *         this list. To grant permissions to all principals, specify an asterisk (*).
     */
    public final List<String> addAllowedPrincipals() {
        return addAllowedPrincipals;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveAllowedPrincipals property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveAllowedPrincipals() {
        return removeAllowedPrincipals != null && !(removeAllowedPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveAllowedPrincipals} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this
     *         list.
     */
    public final List<String> removeAllowedPrincipals() {
        return removeAllowedPrincipals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddAllowedPrincipals() ? addAllowedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveAllowedPrincipals() ? removeAllowedPrincipals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServicePermissionsRequest)) {
            return false;
        }
        ModifyVpcEndpointServicePermissionsRequest other = (ModifyVpcEndpointServicePermissionsRequest) obj;
        return Objects.equals(serviceId(), other.serviceId()) && hasAddAllowedPrincipals() == other.hasAddAllowedPrincipals()
                && Objects.equals(addAllowedPrincipals(), other.addAllowedPrincipals())
                && hasRemoveAllowedPrincipals() == other.hasRemoveAllowedPrincipals()
                && Objects.equals(removeAllowedPrincipals(), other.removeAllowedPrincipals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcEndpointServicePermissionsRequest").add("ServiceId", serviceId())
                .add("AddAllowedPrincipals", hasAddAllowedPrincipals() ? addAllowedPrincipals() : null)
                .add("RemoveAllowedPrincipals", hasRemoveAllowedPrincipals() ? removeAllowedPrincipals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "AddAllowedPrincipals":
            return Optional.ofNullable(clazz.cast(addAllowedPrincipals()));
        case "RemoveAllowedPrincipals":
            return Optional.ofNullable(clazz.cast(removeAllowedPrincipals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServicePermissionsRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServicePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcEndpointServicePermissionsRequest> {
        /**
         * <p>
         * The ID of the service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in this
         * list. To grant permissions to all principals, specify an asterisk (*).
         * </p>
         * 
         * @param addAllowedPrincipals
         *        The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals
         *        in this list. To grant permissions to all principals, specify an asterisk (*).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedPrincipals(Collection<String> addAllowedPrincipals);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in this
         * list. To grant permissions to all principals, specify an asterisk (*).
         * </p>
         * 
         * @param addAllowedPrincipals
         *        The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals
         *        in this list. To grant permissions to all principals, specify an asterisk (*).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedPrincipals(String... addAllowedPrincipals);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this
         * list.
         * </p>
         * 
         * @param removeAllowedPrincipals
         *        The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in
         *        this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllowedPrincipals(Collection<String> removeAllowedPrincipals);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this
         * list.
         * </p>
         * 
         * @param removeAllowedPrincipals
         *        The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in
         *        this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllowedPrincipals(String... removeAllowedPrincipals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String serviceId;

        private List<String> addAllowedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeAllowedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServicePermissionsRequest model) {
            super(model);
            serviceId(model.serviceId);
            addAllowedPrincipals(model.addAllowedPrincipals);
            removeAllowedPrincipals(model.removeAllowedPrincipals);
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        @Transient
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final Collection<String> getAddAllowedPrincipals() {
            if (addAllowedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return addAllowedPrincipals;
        }

        public final void setAddAllowedPrincipals(Collection<String> addAllowedPrincipals) {
            this.addAllowedPrincipals = ValueStringListCopier.copy(addAllowedPrincipals);
        }

        @Override
        @Transient
        public final Builder addAllowedPrincipals(Collection<String> addAllowedPrincipals) {
            this.addAllowedPrincipals = ValueStringListCopier.copy(addAllowedPrincipals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addAllowedPrincipals(String... addAllowedPrincipals) {
            addAllowedPrincipals(Arrays.asList(addAllowedPrincipals));
            return this;
        }

        public final Collection<String> getRemoveAllowedPrincipals() {
            if (removeAllowedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return removeAllowedPrincipals;
        }

        public final void setRemoveAllowedPrincipals(Collection<String> removeAllowedPrincipals) {
            this.removeAllowedPrincipals = ValueStringListCopier.copy(removeAllowedPrincipals);
        }

        @Override
        @Transient
        public final Builder removeAllowedPrincipals(Collection<String> removeAllowedPrincipals) {
            this.removeAllowedPrincipals = ValueStringListCopier.copy(removeAllowedPrincipals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeAllowedPrincipals(String... removeAllowedPrincipals) {
            removeAllowedPrincipals(Arrays.asList(removeAllowedPrincipals));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointServicePermissionsRequest build() {
            return new ModifyVpcEndpointServicePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
