/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSpotPlacementScoresRequest extends Ec2Request implements
        ToCopyableBuilder<GetSpotPlacementScoresRequest.Builder, GetSpotPlacementScoresRequest> {
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceTypes")
            .getter(getter(GetSpotPlacementScoresRequest::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetCapacity")
            .getter(getter(GetSpotPlacementScoresRequest::targetCapacity))
            .setter(setter(Builder::targetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacity")
                    .unmarshallLocationName("TargetCapacity").build()).build();

    private static final SdkField<String> TARGET_CAPACITY_UNIT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetCapacityUnitType")
            .getter(getter(GetSpotPlacementScoresRequest::targetCapacityUnitTypeAsString))
            .setter(setter(Builder::targetCapacityUnitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacityUnitType")
                    .unmarshallLocationName("TargetCapacityUnitType").build()).build();

    private static final SdkField<Boolean> SINGLE_AVAILABILITY_ZONE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SingleAvailabilityZone")
            .getter(getter(GetSpotPlacementScoresRequest::singleAvailabilityZone))
            .setter(setter(Builder::singleAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAvailabilityZone")
                    .unmarshallLocationName("SingleAvailabilityZone").build()).build();

    private static final SdkField<List<String>> REGION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegionNames")
            .getter(getter(GetSpotPlacementScoresRequest::regionNames))
            .setter(setter(Builder::regionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName")
                    .unmarshallLocationName("RegionName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<InstanceRequirementsWithMetadataRequest> INSTANCE_REQUIREMENTS_WITH_METADATA_FIELD = SdkField
            .<InstanceRequirementsWithMetadataRequest> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceRequirementsWithMetadata")
            .getter(getter(GetSpotPlacementScoresRequest::instanceRequirementsWithMetadata))
            .setter(setter(Builder::instanceRequirementsWithMetadata))
            .constructor(InstanceRequirementsWithMetadataRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirementsWithMetadata")
                    .unmarshallLocationName("InstanceRequirementsWithMetadata").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(GetSpotPlacementScoresRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetSpotPlacementScoresRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPES_FIELD,
            TARGET_CAPACITY_FIELD, TARGET_CAPACITY_UNIT_TYPE_FIELD, SINGLE_AVAILABILITY_ZONE_FIELD, REGION_NAMES_FIELD,
            INSTANCE_REQUIREMENTS_WITH_METADATA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> instanceTypes;

    private final Integer targetCapacity;

    private final String targetCapacityUnitType;

    private final Boolean singleAvailabilityZone;

    private final List<String> regionNames;

    private final InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata;

    private final Integer maxResults;

    private final String nextToken;

    private GetSpotPlacementScoresRequest(BuilderImpl builder) {
        super(builder);
        this.instanceTypes = builder.instanceTypes;
        this.targetCapacity = builder.targetCapacity;
        this.targetCapacityUnitType = builder.targetCapacityUnitType;
        this.singleAvailabilityZone = builder.singleAvailabilityZone;
        this.regionNames = builder.regionNames;
        this.instanceRequirementsWithMetadata = builder.instanceRequirementsWithMetadata;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance types. We recommend that you specify at least three instance types. If you specify one or two
     * instance types, or specify variations of a single instance type (for example, an <code>m3.xlarge</code> with and
     * without instance storage), the returned placement score will always be low.
     * </p>
     * <p>
     * If you specify <code>InstanceTypes</code>, you can't specify <code>InstanceRequirementsWithMetadata</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTypes} method.
     * </p>
     * 
     * @return The instance types. We recommend that you specify at least three instance types. If you specify one or
     *         two instance types, or specify variations of a single instance type (for example, an
     *         <code>m3.xlarge</code> with and without instance storage), the returned placement score will always be
     *         low. </p>
     *         <p>
     *         If you specify <code>InstanceTypes</code>, you can't specify
     *         <code>InstanceRequirementsWithMetadata</code>.
     */
    public final List<String> instanceTypes() {
        return instanceTypes;
    }

    /**
     * <p>
     * The target capacity.
     * </p>
     * 
     * @return The target capacity.
     */
    public final Integer targetCapacity() {
        return targetCapacity;
    }

    /**
     * <p>
     * The unit for the target capacity.
     * </p>
     * <p>
     * Default: <code>units</code> (translates to number of instances)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCapacityUnitType} will return {@link TargetCapacityUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCapacityUnitTypeAsString}.
     * </p>
     * 
     * @return The unit for the target capacity.</p>
     *         <p>
     *         Default: <code>units</code> (translates to number of instances)
     * @see TargetCapacityUnitType
     */
    public final TargetCapacityUnitType targetCapacityUnitType() {
        return TargetCapacityUnitType.fromValue(targetCapacityUnitType);
    }

    /**
     * <p>
     * The unit for the target capacity.
     * </p>
     * <p>
     * Default: <code>units</code> (translates to number of instances)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCapacityUnitType} will return {@link TargetCapacityUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCapacityUnitTypeAsString}.
     * </p>
     * 
     * @return The unit for the target capacity.</p>
     *         <p>
     *         Default: <code>units</code> (translates to number of instances)
     * @see TargetCapacityUnitType
     */
    public final String targetCapacityUnitTypeAsString() {
        return targetCapacityUnitType;
    }

    /**
     * <p>
     * Specify <code>true</code> so that the response returns a list of scored Availability Zones. Otherwise, the
     * response returns a list of scored Regions.
     * </p>
     * <p>
     * A list of scored Availability Zones is useful if you want to launch all of your Spot capacity into a single
     * Availability Zone.
     * </p>
     * 
     * @return Specify <code>true</code> so that the response returns a list of scored Availability Zones. Otherwise,
     *         the response returns a list of scored Regions.</p>
     *         <p>
     *         A list of scored Availability Zones is useful if you want to launch all of your Spot capacity into a
     *         single Availability Zone.
     */
    public final Boolean singleAvailabilityZone() {
        return singleAvailabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegionNames() {
        return regionNames != null && !(regionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Regions used to narrow down the list of Regions to be scored. Enter the Region code, for example,
     * <code>us-east-1</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionNames} method.
     * </p>
     * 
     * @return The Regions used to narrow down the list of Regions to be scored. Enter the Region code, for example,
     *         <code>us-east-1</code>.
     */
    public final List<String> regionNames() {
        return regionNames;
    }

    /**
     * <p>
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance
     * types with those attributes.
     * </p>
     * <p>
     * If you specify <code>InstanceRequirementsWithMetadata</code>, you can't specify <code>InstanceTypes</code>.
     * </p>
     * 
     * @return The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
     *         instance types with those attributes.</p>
     *         <p>
     *         If you specify <code>InstanceRequirementsWithMetadata</code>, you can't specify
     *         <code>InstanceTypes</code>.
     */
    public final InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata() {
        return instanceRequirementsWithMetadata;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. Specify a value between 1 and&#x2028; 1000. The default
     * value is 1000. To retrieve the remaining results, make another call with&#x2028; the returned
     * <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. Specify a value between 1 and&#x2028; 1000. The
     *         default value is 1000. To retrieve the remaining results, make another call with&#x2028; the returned
     *         <code>NextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypes() ? instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacityUnitTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(singleAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionNames() ? regionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirementsWithMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSpotPlacementScoresRequest)) {
            return false;
        }
        GetSpotPlacementScoresRequest other = (GetSpotPlacementScoresRequest) obj;
        return hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(instanceTypes(), other.instanceTypes())
                && Objects.equals(targetCapacity(), other.targetCapacity())
                && Objects.equals(targetCapacityUnitTypeAsString(), other.targetCapacityUnitTypeAsString())
                && Objects.equals(singleAvailabilityZone(), other.singleAvailabilityZone())
                && hasRegionNames() == other.hasRegionNames() && Objects.equals(regionNames(), other.regionNames())
                && Objects.equals(instanceRequirementsWithMetadata(), other.instanceRequirementsWithMetadata())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSpotPlacementScoresRequest")
                .add("InstanceTypes", hasInstanceTypes() ? instanceTypes() : null).add("TargetCapacity", targetCapacity())
                .add("TargetCapacityUnitType", targetCapacityUnitTypeAsString())
                .add("SingleAvailabilityZone", singleAvailabilityZone())
                .add("RegionNames", hasRegionNames() ? regionNames() : null)
                .add("InstanceRequirementsWithMetadata", instanceRequirementsWithMetadata()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "TargetCapacity":
            return Optional.ofNullable(clazz.cast(targetCapacity()));
        case "TargetCapacityUnitType":
            return Optional.ofNullable(clazz.cast(targetCapacityUnitTypeAsString()));
        case "SingleAvailabilityZone":
            return Optional.ofNullable(clazz.cast(singleAvailabilityZone()));
        case "RegionNames":
            return Optional.ofNullable(clazz.cast(regionNames()));
        case "InstanceRequirementsWithMetadata":
            return Optional.ofNullable(clazz.cast(instanceRequirementsWithMetadata()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSpotPlacementScoresRequest, T> g) {
        return obj -> g.apply((GetSpotPlacementScoresRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetSpotPlacementScoresRequest> {
        /**
         * <p>
         * The instance types. We recommend that you specify at least three instance types. If you specify one or two
         * instance types, or specify variations of a single instance type (for example, an <code>m3.xlarge</code> with
         * and without instance storage), the returned placement score will always be low.
         * </p>
         * <p>
         * If you specify <code>InstanceTypes</code>, you can't specify <code>InstanceRequirementsWithMetadata</code>.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types. We recommend that you specify at least three instance types. If you specify one or
         *        two instance types, or specify variations of a single instance type (for example, an
         *        <code>m3.xlarge</code> with and without instance storage), the returned placement score will always be
         *        low. </p>
         *        <p>
         *        If you specify <code>InstanceTypes</code>, you can't specify
         *        <code>InstanceRequirementsWithMetadata</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<String> instanceTypes);

        /**
         * <p>
         * The instance types. We recommend that you specify at least three instance types. If you specify one or two
         * instance types, or specify variations of a single instance type (for example, an <code>m3.xlarge</code> with
         * and without instance storage), the returned placement score will always be low.
         * </p>
         * <p>
         * If you specify <code>InstanceTypes</code>, you can't specify <code>InstanceRequirementsWithMetadata</code>.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types. We recommend that you specify at least three instance types. If you specify one or
         *        two instance types, or specify variations of a single instance type (for example, an
         *        <code>m3.xlarge</code> with and without instance storage), the returned placement score will always be
         *        low. </p>
         *        <p>
         *        If you specify <code>InstanceTypes</code>, you can't specify
         *        <code>InstanceRequirementsWithMetadata</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(String... instanceTypes);

        /**
         * <p>
         * The target capacity.
         * </p>
         * 
         * @param targetCapacity
         *        The target capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacity(Integer targetCapacity);

        /**
         * <p>
         * The unit for the target capacity.
         * </p>
         * <p>
         * Default: <code>units</code> (translates to number of instances)
         * </p>
         * 
         * @param targetCapacityUnitType
         *        The unit for the target capacity.</p>
         *        <p>
         *        Default: <code>units</code> (translates to number of instances)
         * @see TargetCapacityUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCapacityUnitType
         */
        Builder targetCapacityUnitType(String targetCapacityUnitType);

        /**
         * <p>
         * The unit for the target capacity.
         * </p>
         * <p>
         * Default: <code>units</code> (translates to number of instances)
         * </p>
         * 
         * @param targetCapacityUnitType
         *        The unit for the target capacity.</p>
         *        <p>
         *        Default: <code>units</code> (translates to number of instances)
         * @see TargetCapacityUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCapacityUnitType
         */
        Builder targetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType);

        /**
         * <p>
         * Specify <code>true</code> so that the response returns a list of scored Availability Zones. Otherwise, the
         * response returns a list of scored Regions.
         * </p>
         * <p>
         * A list of scored Availability Zones is useful if you want to launch all of your Spot capacity into a single
         * Availability Zone.
         * </p>
         * 
         * @param singleAvailabilityZone
         *        Specify <code>true</code> so that the response returns a list of scored Availability Zones. Otherwise,
         *        the response returns a list of scored Regions.</p>
         *        <p>
         *        A list of scored Availability Zones is useful if you want to launch all of your Spot capacity into a
         *        single Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleAvailabilityZone(Boolean singleAvailabilityZone);

        /**
         * <p>
         * The Regions used to narrow down the list of Regions to be scored. Enter the Region code, for example,
         * <code>us-east-1</code>.
         * </p>
         * 
         * @param regionNames
         *        The Regions used to narrow down the list of Regions to be scored. Enter the Region code, for example,
         *        <code>us-east-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNames(Collection<String> regionNames);

        /**
         * <p>
         * The Regions used to narrow down the list of Regions to be scored. Enter the Region code, for example,
         * <code>us-east-1</code>.
         * </p>
         * 
         * @param regionNames
         *        The Regions used to narrow down the list of Regions to be scored. Enter the Region code, for example,
         *        <code>us-east-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNames(String... regionNames);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with those attributes.
         * </p>
         * <p>
         * If you specify <code>InstanceRequirementsWithMetadata</code>, you can't specify <code>InstanceTypes</code>.
         * </p>
         * 
         * @param instanceRequirementsWithMetadata
         *        The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         *        instance types with those attributes.</p>
         *        <p>
         *        If you specify <code>InstanceRequirementsWithMetadata</code>, you can't specify
         *        <code>InstanceTypes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with those attributes.
         * </p>
         * <p>
         * If you specify <code>InstanceRequirementsWithMetadata</code>, you can't specify <code>InstanceTypes</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceRequirementsWithMetadataRequest.Builder}
         * avoiding the need to create one manually via {@link InstanceRequirementsWithMetadataRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceRequirementsWithMetadataRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #instanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest)}.
         * 
         * @param instanceRequirementsWithMetadata
         *        a consumer that will call methods on {@link InstanceRequirementsWithMetadataRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest)
         */
        default Builder instanceRequirementsWithMetadata(
                Consumer<InstanceRequirementsWithMetadataRequest.Builder> instanceRequirementsWithMetadata) {
            return instanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest.builder()
                    .applyMutation(instanceRequirementsWithMetadata).build());
        }

        /**
         * <p>
         * The maximum number of results to return in a single call. Specify a value between 1 and&#x2028; 1000. The
         * default value is 1000. To retrieve the remaining results, make another call with&#x2028; the returned
         * <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. Specify a value between 1 and&#x2028; 1000.
         *        The default value is 1000. To retrieve the remaining results, make another call with&#x2028; the
         *        returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer targetCapacity;

        private String targetCapacityUnitType;

        private Boolean singleAvailabilityZone;

        private List<String> regionNames = DefaultSdkAutoConstructList.getInstance();

        private InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSpotPlacementScoresRequest model) {
            super(model);
            instanceTypes(model.instanceTypes);
            targetCapacity(model.targetCapacity);
            targetCapacityUnitType(model.targetCapacityUnitType);
            singleAvailabilityZone(model.singleAvailabilityZone);
            regionNames(model.regionNames);
            instanceRequirementsWithMetadata(model.instanceRequirementsWithMetadata);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getInstanceTypes() {
            if (instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypesCopier.copy(instanceTypes);
        }

        @Override
        @Transient
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypesCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceTypes(String... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final Integer getTargetCapacity() {
            return targetCapacity;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        @Override
        @Transient
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final String getTargetCapacityUnitType() {
            return targetCapacityUnitType;
        }

        public final void setTargetCapacityUnitType(String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
        }

        @Override
        @Transient
        public final Builder targetCapacityUnitType(String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
            return this;
        }

        @Override
        @Transient
        public final Builder targetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType) {
            this.targetCapacityUnitType(targetCapacityUnitType == null ? null : targetCapacityUnitType.toString());
            return this;
        }

        public final Boolean getSingleAvailabilityZone() {
            return singleAvailabilityZone;
        }

        public final void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
        }

        @Override
        @Transient
        public final Builder singleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
            return this;
        }

        public final Collection<String> getRegionNames() {
            if (regionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return regionNames;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            this.regionNames = RegionNamesCopier.copy(regionNames);
        }

        @Override
        @Transient
        public final Builder regionNames(Collection<String> regionNames) {
            this.regionNames = RegionNamesCopier.copy(regionNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regionNames(String... regionNames) {
            regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final InstanceRequirementsWithMetadataRequest.Builder getInstanceRequirementsWithMetadata() {
            return instanceRequirementsWithMetadata != null ? instanceRequirementsWithMetadata.toBuilder() : null;
        }

        public final void setInstanceRequirementsWithMetadata(
                InstanceRequirementsWithMetadataRequest.BuilderImpl instanceRequirementsWithMetadata) {
            this.instanceRequirementsWithMetadata = instanceRequirementsWithMetadata != null ? instanceRequirementsWithMetadata
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder instanceRequirementsWithMetadata(
                InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata) {
            this.instanceRequirementsWithMetadata = instanceRequirementsWithMetadata;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSpotPlacementScoresRequest build() {
            return new GetSpotPlacementScoresRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
