/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SecurityGroupReferencesCopier {
    static List<SecurityGroupReference> copy(Collection<? extends SecurityGroupReference> securityGroupReferencesParam) {
        List<SecurityGroupReference> list;
        if (securityGroupReferencesParam == null || securityGroupReferencesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecurityGroupReference> modifiableList = new ArrayList<>();
            securityGroupReferencesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SecurityGroupReference> copyFromBuilder(
            Collection<? extends SecurityGroupReference.Builder> securityGroupReferencesParam) {
        List<SecurityGroupReference> list;
        if (securityGroupReferencesParam == null || securityGroupReferencesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecurityGroupReference> modifiableList = new ArrayList<>();
            securityGroupReferencesParam.forEach(entry -> {
                SecurityGroupReference member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SecurityGroupReference.Builder> copyToBuilder(
            Collection<? extends SecurityGroupReference> securityGroupReferencesParam) {
        List<SecurityGroupReference.Builder> list;
        if (securityGroupReferencesParam == null || securityGroupReferencesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecurityGroupReference.Builder> modifiableList = new ArrayList<>();
            securityGroupReferencesParam.forEach(entry -> {
                SecurityGroupReference.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
