/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a route table and a resource attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayRouteTableAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayRouteTableAssociation.Builder, TransitGatewayRouteTableAssociation> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(TransitGatewayRouteTableAssociation::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(TransitGatewayRouteTableAssociation::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(TransitGatewayRouteTableAssociation::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayRouteTableAssociation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentId;

    private final String resourceId;

    private final String resourceType;

    private final String state;

    private TransitGatewayRouteTableAssociation(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * @see TransitGatewayAttachmentResourceType
     */
    public final TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * @see TransitGatewayAttachmentResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the association.
     * @see TransitGatewayAssociationState
     */
    public final TransitGatewayAssociationState state() {
        return TransitGatewayAssociationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the association.
     * @see TransitGatewayAssociationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRouteTableAssociation)) {
            return false;
        }
        TransitGatewayRouteTableAssociation other = (TransitGatewayRouteTableAssociation) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayRouteTableAssociation")
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId()).add("ResourceId", resourceId())
                .add("ResourceType", resourceTypeAsString()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRouteTableAssociation, T> g) {
        return obj -> g.apply((TransitGatewayRouteTableAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayRouteTableAssociation> {
        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
         * </p>
         * 
         * @param resourceType
         *        The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
         * </p>
         * 
         * @param resourceType
         *        The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(TransitGatewayAttachmentResourceType resourceType);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param state
         *        The state of the association.
         * @see TransitGatewayAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAssociationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param state
         *        The state of the association.
         * @see TransitGatewayAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAssociationState
         */
        Builder state(TransitGatewayAssociationState state);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String resourceId;

        private String resourceType;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRouteTableAssociation model) {
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            state(model.state);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        @Transient
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(TransitGatewayAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public TransitGatewayRouteTableAssociation build() {
            return new TransitGatewayRouteTableAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
